/*
 * Decompiled with CFR 0.152.
 */
package com.objective.threesixty.remoteagent.sdk.utils;

import io.grpc.ChannelCredentials;
import io.grpc.TlsChannelCredentials;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class CertificateUtils {
    private static final Logger log = LogManager.getLogger(CertificateUtils.class);

    public static TrustManagerFactory getTrustManagerFactory(String password) throws GeneralSecurityException, IOException {
        KeyStore keyStore = CertificateUtils.loadKeyStore(password);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        return trustManagerFactory;
    }

    public static ChannelCredentials getChannelCredentials(TrustManagerFactory tmf) {
        return TlsChannelCredentials.newBuilder().trustManager(tmf.getTrustManagers()).build();
    }

    public static SslContext getSslContext(TrustManagerFactory tmf) throws SSLException {
        return SslContextBuilder.forClient().trustManager(tmf).build();
    }

    private static KeyStore loadKeyStore(String password) throws GeneralSecurityException, IOException {
        KeyStore keyStore;
        String cacertsPath = Paths.get(System.getProperty("java.home"), "lib", "security", "cacerts").toString();
        try (FileInputStream fis = new FileInputStream(cacertsPath);){
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(fis, password.toCharArray());
        }
        catch (IOException e) {
            log.error("Error reading the keystore file at {}: {}", (Object)cacertsPath, (Object)e.getMessage());
            throw e;
        }
        catch (GeneralSecurityException e) {
            log.error("Error initializing the keystore: {}", (Object)e.getMessage());
            throw e;
        }
        return keyStore;
    }

    @Generated
    private CertificateUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

