/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 1.2.0
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package com.okta.sdk.client;

import com.okta.sdk.resource.user.AppLink;
import com.okta.sdk.resource.application.AppUser;
import com.okta.sdk.resource.application.Application;
import com.okta.sdk.resource.application.ApplicationGroupAssignment;
import com.okta.sdk.resource.user.ChangePasswordRequest;
import com.okta.sdk.resource.session.CreateSessionRequest;
import com.okta.sdk.resource.user.factor.Factor;
import com.okta.sdk.resource.user.ForgotPasswordResponse;
import com.okta.sdk.resource.group.Group;
import com.okta.sdk.resource.group.rule.GroupRule;
import com.okta.sdk.resource.application.JsonWebKey;
import com.okta.sdk.resource.log.LogEvent;
import com.okta.sdk.resource.user.ResetPasswordToken;
import com.okta.sdk.resource.user.Role;
import com.okta.sdk.resource.user.factor.SecurityQuestion;
import com.okta.sdk.resource.session.Session;
import com.okta.sdk.resource.user.TempPassword;
import com.okta.sdk.resource.user.User;
import com.okta.sdk.resource.user.UserActivationToken;
import com.okta.sdk.resource.user.UserCredentials;
import com.okta.sdk.resource.user.factor.VerifyFactorRequest;
import com.okta.sdk.resource.user.factor.VerifyFactorResponse;
import com.okta.sdk.resource.group.rule.GroupRuleList;
import com.okta.sdk.resource.user.factor.FactorList;
import com.okta.sdk.resource.user.UserList;
import com.okta.sdk.resource.user.AuthenticationProviderType;
import com.okta.sdk.resource.application.ApplicationGroupAssignmentList;
import com.okta.sdk.resource.application.JsonWebKeyList;
import com.okta.sdk.resource.application.AppUserList;
import com.okta.sdk.resource.group.GroupList;
import com.okta.sdk.resource.user.factor.SecurityQuestionList;
import com.okta.sdk.resource.log.LogEventList;
import com.okta.sdk.resource.application.ApplicationList;
import com.okta.sdk.resource.user.AppLinkList;
import com.okta.sdk.resource.user.RoleList;

import java.util.LinkedHashMap;
import com.okta.sdk.ds.DataStore;

/**
* The {@code Client} is the main entry point to the Okta Java SDK.  A JVM project wishing to
* communicate with the Okta REST API service must build a {@code Client} instance.  After obtaining
* a {@code Client instance}, the REST API may be used by making simple Java calls on objects returned from
* the Client (or any children objects obtained therein).
* <p>
* For example:
* <pre>
* Client client = Clients.builder().build();
*
* client.getUser(userId)
* </pre>
* @see <a href="http://www.okta.com/docs/quickstart/connect">Communicating with Okta: Get your API Key</a>
* @see DataStore
* @since 0.5.0
*/
@javax.annotation.Generated(value = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
                            date  = "2018-05-18T15:09:48.268-04:00")
public interface Client extends DataStore {

    /**
    * Returns the internal {@link DataStore} of the client.  It is typically not necessary to invoke this method as
    * the Client implements the {@link DataStore} API and will delegate to this instance automatically.
    *
    * @return the client's internal {@link DataStore}.
    */
    DataStore getDataStore();

    
    /**
    * Add Application
    * Adds a new application to your Okta organization.
    * @param application  (required)
    * @param activate Executes activation lifecycle operation when creating the app (optional, default to true)
    * @return Application
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "POST - /api/v1/apps")
    Application createApplication(Application application, Boolean activate);

    /**
    * Add Application
    * Adds a new application to your Okta organization.
    * @param application  (required)
    * @return Application
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "POST - /api/v1/apps")
    Application createApplication(Application application);

    /**
    * Add Group
    * Adds a new group with &#x60;OKTA_GROUP&#x60; type to your organization.
    * @param group  (required)
    * @return Group
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "POST - /api/v1/groups")
    Group createGroup(Group group);


    /**
    * Create Group Rule
    * Creates a group rule to dynamically add users to the specified group if they match the condition
    * @param groupRule  (required)
    * @return GroupRule
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "POST - /api/v1/groups/rules")
    GroupRule createRule(GroupRule groupRule);


    /**
    * Create Session with Session Token
    * Creates a new session for a user with a valid session token. Use this API if, for example, you want to set the session cookie yourself instead of allowing Okta to set it, or want to hold the session ID in order to delete a session via the API instead of visiting the logout URL.
    * @param createSessionRequest  (required)
    * @return Session
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "POST - /api/v1/sessions")
    Session createSession(CreateSessionRequest createSessionRequest);


    /**
    * Create User
    * Creates a new user in your Okta organization with or without credentials.
    * @param body  (required)
    * @param activate Executes activation lifecycle operation when creating the user (optional, default to true)
    * @param provider Indicates whether to create a user with a specified authentication provider (optional, default to false)
    * @return User
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "POST - /api/v1/users")
    User createUser(User body, Boolean activate, Boolean provider);

    /**
    * Create User
    * Creates a new user in your Okta organization with or without credentials.
    * @param body  (required)
    * @return User
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "POST - /api/v1/users")
    User createUser(User body);

    /**
    * Get Application
    * Fetches an application from your Okta organization by &#x60;id&#x60;.
    * @param appId  (required)
    * @param expand  (optional)
    * @return Application
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "GET - /api/v1/apps/{appId}")
    Application getApplication(String appId, String expand);

    /**
    * Get Application
    * Fetches an application from your Okta organization by &#x60;id&#x60;.
    * @param appId  (required)
    * @return Application
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "GET - /api/v1/apps/{appId}")
    Application getApplication(String appId);

    /**
    * List Group Rules
    * Lists all group rules for your organization.
    * @param groupId  (required)
    * @param expand  (optional)
    * @return Group
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "GET - /api/v1/groups/{groupId}")
    Group getGroup(String groupId, String expand);

    /**
    * List Group Rules
    * Lists all group rules for your organization.
    * @param groupId  (required)
    * @return Group
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "GET - /api/v1/groups/{groupId}")
    Group getGroup(String groupId);

    /**
    * Fetch a list of events from your Okta organization system log.
    * The Okta System Log API provides read access to your organization’s system log. This API provides more functionality than the Events API
    * @param until  (optional)
    * @param since  (optional)
    * @param filter  (optional)
    * @param q  (optional)
    * @param sortOrder  (optional, default to ASCENDING)
    * @return LogEventList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "GET - /api/v1/logs")
    LogEventList getLogs(String until, String since, String filter, String q, String sortOrder);

    /**
    * Fetch a list of events from your Okta organization system log.
    * The Okta System Log API provides read access to your organization’s system log. This API provides more functionality than the Events API
    * @return LogEventList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "GET - /api/v1/logs")
    LogEventList getLogs();

    /**
    * Get Group Rule
    * Fetches a specific group rule by id from your organization
    * @param ruleId  (required)
    * @return GroupRule
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "GET - /api/v1/groups/rules/{ruleId}")
    GroupRule getRule(String ruleId);


    /**
    * 
    * Get details about a session.
    * @param sessionId  (required)
    * @return Session
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "GET - /api/v1/sessions/{sessionId}")
    Session getSession(String sessionId);


    /**
    * Get User
    * Fetches a user from your Okta organization.
    * @param userId  (required)
    * @return User
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "GET - /api/v1/users/{userId}")
    User getUser(String userId);


    /**
    * List Applications
    * Enumerates apps added to your organization with pagination. A subset of apps can be returned that match a supported filter expression or query.
    * @param q  (optional)
    * @param filter Filters apps by status, user.id, group.id or credentials.signing.kid expression (optional)
    * @param expand Traverses users link relationship and optionally embeds Application User resource (optional)
    * @param includeNonDeleted  (optional, default to false)
    * @return ApplicationList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "GET - /api/v1/apps")
    ApplicationList listApplications(String q, String filter, String expand, Boolean includeNonDeleted);

    /**
    * List Applications
    * Enumerates apps added to your organization with pagination. A subset of apps can be returned that match a supported filter expression or query.
    * @return ApplicationList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "GET - /api/v1/apps")
    ApplicationList listApplications();

    /**
    * List Groups
    * Enumerates groups in your organization with pagination. A subset of groups can be returned that match a supported filter expression or query.
    * @param q Searches the name property of groups for matching value (optional)
    * @param filter Filter expression for groups (optional)
    * @param expand  (optional)
    * @return GroupList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "GET - /api/v1/groups")
    GroupList listGroups(String q, String filter, String expand);

    /**
    * List Groups
    * Enumerates groups in your organization with pagination. A subset of groups can be returned that match a supported filter expression or query.
    * @return GroupList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "GET - /api/v1/groups")
    GroupList listGroups();

    /**
    * List Group Rules
    * Lists all group rules for your organization.
    * @return GroupRuleList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "GET - /api/v1/groups/rules")
    GroupRuleList listRules();


    /**
    * List Users
    * Lists users in your organization with pagination in most cases.  A subset of users can be returned that match a supported filter expression or search criteria.
    * @param q Finds a user that matches firstName, lastName, and email properties (optional)
    * @param filter Filters users with a supported expression for a subset of properties (optional)
    * @param format  (optional)
    * @param search Searches for users with a supported filtering  expression for most properties (optional)
    * @param expand  (optional)
    * @return UserList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "GET - /api/v1/users")
    UserList listUsers(String q, String filter, String format, String search, String expand);

    /**
    * List Users
    * Lists users in your organization with pagination in most cases.  A subset of users can be returned that match a supported filter expression or search criteria.
    * @return UserList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "GET - /api/v1/users")
    UserList listUsers();

}
