/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 1.2.0
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.resource.group;

import com.okta.sdk.resource.group.Group;
import com.okta.sdk.resource.group.GroupProfile;
import com.okta.sdk.resource.user.UserList;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import java.util.Map;
import com.okta.sdk.resource.Resource;
import com.okta.sdk.resource.Deletable;
import com.okta.sdk.resource.Saveable;


/**
 * Group
 */
@javax.annotation.Generated(value = "com.okta.swagger.codegen.OktaJavaClientApiCodegen", date = "2018-05-18T15:09:48.268-04:00")
public interface Group extends Resource, Deletable {

    Map<String, Object> getEmbedded();

    Map<String, Object> getLinks();

    Date getCreated();

    String getId();

    Date getLastMembershipUpdated();

    Date getLastUpdated();

    List<String> getObjectClass();

    GroupProfile getProfile();

    Group setProfile(GroupProfile profile);

    String getType();


    /**
    * List Group Members
    * Enumerates all [users](/docs/api/resources/users.html#user-model) that are a member of a group.
    * @return UserList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "GET - /api/v1/groups/{groupId}/users")
    UserList listUsers();


    /**
    * Update Group
    * Updates the profile for a group with &#x60;OKTA_GROUP&#x60; type from your organization.
    * @return Group
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "PUT - /api/v1/groups/{groupId}")
    Group update();


    /**
    * Remove Group
    * Removes a group with &#x60;OKTA_GROUP&#x60; type from your organization.
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "DELETE - /api/v1/groups/{groupId}")
    void delete();


    /**
    * Remove User from Group
    * Removes a [user](users.html#user-model) from a group with &#x60;OKTA_GROUP&#x60; type.
    * @param userId  (required)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "DELETE - /api/v1/groups/{groupId}/users/{userId}")
    void removeUser(String userId);




}

