/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 1.2.0
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.resource.user;

import com.okta.sdk.resource.group.GroupList;
import com.okta.sdk.resource.user.AppLinkList;
import com.okta.sdk.resource.user.AuthenticationProviderType;
import com.okta.sdk.resource.user.ChangePasswordRequest;
import com.okta.sdk.resource.user.ForgotPasswordResponse;
import com.okta.sdk.resource.user.ResetPasswordToken;
import com.okta.sdk.resource.user.Role;
import com.okta.sdk.resource.user.RoleList;
import com.okta.sdk.resource.user.TempPassword;
import com.okta.sdk.resource.user.User;
import com.okta.sdk.resource.user.UserActivationToken;
import com.okta.sdk.resource.user.UserCredentials;
import com.okta.sdk.resource.user.UserProfile;
import com.okta.sdk.resource.user.UserStatus;
import com.okta.sdk.resource.user.factor.Factor;
import com.okta.sdk.resource.user.factor.FactorList;
import com.okta.sdk.resource.user.factor.SecurityQuestionList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import java.util.Map;
import com.okta.sdk.resource.Resource;
import com.okta.sdk.resource.Deletable;
import com.okta.sdk.resource.Saveable;


/**
 * User
 */
@javax.annotation.Generated(value = "com.okta.swagger.codegen.OktaJavaClientApiCodegen", date = "2018-05-18T15:09:48.268-04:00")
public interface User extends Resource, Deletable {

    Map<String, Object> getEmbedded();

    Map<String, Object> getLinks();

    Date getActivated();

    Date getCreated();

    UserCredentials getCredentials();

    User setCredentials(UserCredentials credentials);

    String getId();

    Date getLastLogin();

    Date getLastUpdated();

    Date getPasswordChanged();

    UserProfile getProfile();

    User setProfile(UserProfile profile);

    UserStatus getStatus();

    Date getStatusChanged();

    UserStatus getTransitioningToStatus();


    /**
    * Deactivate User
    * Deactivates a user.  This operation can only be performed on users that do not have a &#x60;DEPROVISIONED&#x60; status.  Deactivation of a user is an asynchronous operation.  The user will have the &#x60;transitioningToStatus&#x60; property with a value of &#x60;DEPROVISIONED&#x60; during deactivation to indicate that the user hasn&#39;t completed the asynchronous operation.  The user will have a status of &#x60;DEPROVISIONED&#x60; when the deactivation process is complete.
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "POST - /api/v1/users/{userId}/lifecycle/deactivate")
    void deactivate();


    /**
    * Reset Password
    * Generates a one-time token (OTT) that can be used to reset a user&#39;s password.  The OTT link can be automatically emailed to the user or returned to the API caller and distributed using a custom flow.
    * @param provider  (optional)
    * @param sendEmail  (optional)
    * @return ResetPasswordToken
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "POST - /api/v1/users/{userId}/lifecycle/reset_password")
    ResetPasswordToken resetPassword(String provider, Boolean sendEmail);

    /**
    * Reset Password
    * Generates a one-time token (OTT) that can be used to reset a user&#39;s password.  The OTT link can be automatically emailed to the user or returned to the API caller and distributed using a custom flow.
    * @return ResetPasswordToken
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "POST - /api/v1/users/{userId}/lifecycle/reset_password")
    ResetPasswordToken resetPassword();


    /**
    * 
    * Enumerates all the enrolled factors for the specified user
    * @return FactorList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "GET - /api/v1/users/{userId}/factors")
    FactorList listFactors();


    /**
    * 
    * 
    * @param roleId  (required)
    * @return GroupList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "GET - /api/v1/users/{userId}/roles/{roleId}/targets/groups")
    GroupList listGroupTargetsForRole(String roleId);


    /**
    * Forgot Password
    * Generates a one-time token (OTT) that can be used to reset a user&#39;s password.  The user will be required to validate their security question&#39;s answer when visiting the reset link.  This operation can only be performed on users with a valid [recovery question credential](#recovery-question-object) and have an &#x60;ACTIVE&#x60; status.
    * @param sendEmail  (optional, default to true)
    * @param userCredentials  (optional)
    * @return ForgotPasswordResponse
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "POST - /api/v1/users/{userId}/credentials/forgot_password")
    ForgotPasswordResponse forgotPassword(Boolean sendEmail, UserCredentials userCredentials);

    /**
    * Forgot Password
    * Generates a one-time token (OTT) that can be used to reset a user&#39;s password.  The user will be required to validate their security question&#39;s answer when visiting the reset link.  This operation can only be performed on users with a valid [recovery question credential](#recovery-question-object) and have an &#x60;ACTIVE&#x60; status.
    * @return ForgotPasswordResponse
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "POST - /api/v1/users/{userId}/credentials/forgot_password")
    ForgotPasswordResponse forgotPassword();


    /**
    * 
    * Unassigns a role from a user.
    * @param roleId  (required)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "DELETE - /api/v1/users/{userId}/roles/{roleId}")
    void removeRole(String roleId);


    /**
    * Expire Password
    * This operation transitions the user to the status of &#x60;PASSWORD_EXPIRED&#x60; so that the user is required to change their password at their next login.
    * @param tempPassword Sets the user&#39;s password to a temporary password,  if true (optional, default to false)
    * @return TempPassword
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "POST - /api/v1/users/{userId}/lifecycle/expire_password")
    TempPassword expirePassword(Boolean tempPassword);

    /**
    * Expire Password
    * This operation transitions the user to the status of &#x60;PASSWORD_EXPIRED&#x60; so that the user is required to change their password at their next login.
    * @return TempPassword
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "POST - /api/v1/users/{userId}/lifecycle/expire_password")
    TempPassword expirePassword();


    /**
    * Activate User
    * Activates a user.  This operation can only be performed on users with a &#x60;STAGED&#x60; status.  Activation of a user is an asynchronous operation.  The user will have the &#x60;transitioningToStatus&#x60; property with a value of &#x60;ACTIVE&#x60; during activation to indicate that the user hasn&#39;t completed the asynchronous operation.  The user will have a status of &#x60;ACTIVE&#x60; when the activation process is complete.
    * @param sendEmail Sends an activation email to the user if true (required)
    * @return UserActivationToken
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "POST - /api/v1/users/{userId}/lifecycle/activate")
    UserActivationToken activate(Boolean sendEmail);


    /**
    * Change Recovery Question
    * Changes a user&#39;s recovery question &amp; answer credential by validating the user&#39;s current password.  This operation can only be performed on users in **STAGED**, **ACTIVE** or **RECOVERY** &#x60;status&#x60; that have a valid [password credential](#password-object)
    * @param userCredentials  (required)
    * @return UserCredentials
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "POST - /api/v1/users/{userId}/credentials/change_recovery_question")
    UserCredentials changeRecoveryQuestion(UserCredentials userCredentials);


    /**
    * Unsuspend User
    * Unsuspends a user and returns them to the &#x60;ACTIVE&#x60; state.  This operation can only be performed on users that have a &#x60;SUSPENDED&#x60; status.
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "POST - /api/v1/users/{userId}/lifecycle/unsuspend")
    void unsuspend();


    /**
    * Enroll Factor
    * Enrolls a user with a supported [factor](#list-factors-to-enroll)
    * @param updatePhone  (optional, default to false)
    * @param templateId id of SMS template (only for SMS factor) (optional)
    * @param body Factor (required)
    * @return Factor
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "POST - /api/v1/users/{userId}/factors")
    Factor addFactor(Boolean updatePhone, String templateId, Factor body);

    /**
    * Enroll Factor
    * Enrolls a user with a supported [factor](#list-factors-to-enroll)
    * @param body Factor (required)
    * @return Factor
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "POST - /api/v1/users/{userId}/factors")
    Factor addFactor(Factor body);


    /**
    * Get Member Groups
    * Fetches the groups of which the user is a member.
    * @return GroupList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "GET - /api/v1/users/{userId}/groups")
    GroupList listGroups();


    /**
    * 
    * 
    * @param roleId  (required)
    * @param groupId  (required)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "DELETE - /api/v1/users/{userId}/roles/{roleId}/targets/groups/{groupId}")
    void removeGroupTargetFromRole(String roleId, String groupId);


    /**
    * 
    * Enumerates all the [supported factors](#supported-factors-for-providers) that can be enrolled for the specified user
    * @return FactorList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "GET - /api/v1/users/{userId}/factors/catalog")
    FactorList listSupportedFactors();


    /**
    * Delete User
    * Deletes a user permanently.  This operation can only be performed on users that have a &#x60;DEPROVISIONED&#x60; status.  **This action cannot be recovered!**
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "DELETE - /api/v1/users/{userId}")
    void delete();


    /**
    * Reset Factors
    * This operation resets all factors for the specified user. All MFA factor enrollments returned to the unenrolled state. The user&#39;s status remains ACTIVE. This link is present only if the user is currently enrolled in one or more MFA factors.
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "POST - /api/v1/users/{userId}/lifecycle/reset_factors")
    void resetFactors();


    /**
    * Suspend User
    * Suspends a user.  This operation can only be performed on users with an &#x60;ACTIVE&#x60; status.  The user will have a status of &#x60;SUSPENDED&#x60; when the process is complete.
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "POST - /api/v1/users/{userId}/lifecycle/suspend")
    void suspend();


    /**
    * 
    * Lists all roles assigned to a user.
    * @param expand  (optional)
    * @return RoleList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "GET - /api/v1/users/{userId}/roles")
    RoleList listRoles(String expand);

    /**
    * 
    * Lists all roles assigned to a user.
    * @return RoleList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "GET - /api/v1/users/{userId}/roles")
    RoleList listRoles();


    /**
    * Unlock User
    * Unlocks a user with a &#x60;LOCKED_OUT&#x60; status and returns them to &#x60;ACTIVE&#x60; status.  Users will be able to login with their current password.
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "POST - /api/v1/users/{userId}/lifecycle/unlock")
    void unlock();


    /**
    * Update User
    * Update a user&#39;s profile and/or credentials using strict-update semantics.
    * @return User
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "PUT - /api/v1/users/{userId}")
    User update();


    /**
    * 
    * Fetches a factor for the specified user
    * @param factorId  (required)
    * @return Factor
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "GET - /api/v1/users/{userId}/factors/{factorId}")
    Factor getFactor(String factorId);


    /**
    * Change Password
    * Changes a user&#39;s password by validating the user&#39;s current password.  This operation can only be performed on users in &#x60;STAGED&#x60;, &#x60;ACTIVE&#x60;, &#x60;PASSWORD_EXPIRED&#x60;, or &#x60;RECOVERY&#x60; status that have a valid [password credential](#password-object)
    * @param changePasswordRequest  (required)
    * @return UserCredentials
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "POST - /api/v1/users/{userId}/credentials/change_password")
    UserCredentials changePassword(ChangePasswordRequest changePasswordRequest);


    /**
    * Get Assigned App Links
    * Fetches appLinks for all direct or indirect (via group membership) assigned applications.
    * @param showAll  (optional, default to false)
    * @return AppLinkList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "GET - /api/v1/users/{userId}/appLinks")
    AppLinkList listAppLinks(Boolean showAll);

    /**
    * Get Assigned App Links
    * Fetches appLinks for all direct or indirect (via group membership) assigned applications.
    * @return AppLinkList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "GET - /api/v1/users/{userId}/appLinks")
    AppLinkList listAppLinks();


    /**
    * 
    * 
    * @param roleId  (required)
    * @param groupId  (required)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "PUT - /api/v1/users/{userId}/roles/{roleId}/targets/groups/{groupId}")
    void addGroupTargetToRole(String roleId, String groupId);


    /**
    * 
    * Enumerates all available security questions for a user&#39;s &#x60;question&#x60; factor
    * @return SecurityQuestionList
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "GET - /api/v1/users/{userId}/factors/questions")
    SecurityQuestionList listSupportedSecurityQuestions();


    /**
    * 
    * Removes all active identity provider sessions. This forces the user to authenticate on the next operation. Optionally revokes OpenID Connect and OAuth refresh and access tokens issued to the user.
    * @param oAuthTokens Revoke issued OpenID Connect and OAuth refresh and access tokens (optional, default to false)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "DELETE - /api/v1/users/{userId}/sessions")
    void endAllSessions(Boolean oAuthTokens);

    /**
    * 
    * Removes all active identity provider sessions. This forces the user to authenticate on the next operation. Optionally revokes OpenID Connect and OAuth refresh and access tokens issued to the user.
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "DELETE - /api/v1/users/{userId}/sessions")
    void endAllSessions();


    /**
    * Add User to Group
    * Adds a [user](users.html#user-model) to a group with &#x60;OKTA_GROUP&#x60; type.
    * @param groupId  (required)
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "PUT - /api/v1/groups/{groupId}/users/{userId}")
    void addToGroup(String groupId);


    /**
    * 
    * Assigns a role to a user.
    * @param role  (required)
    * @return Role
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "POST - /api/v1/users/{userId}/roles")
    Role addRole(Role role);




}

