/*
 * Okta API
 * Allows customers to easily access the Okta API
 *
 * OpenAPI spec version: 1.2.0
 * Contact: devex-public@okta.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.okta.sdk.resource.user.factor;

import com.okta.sdk.resource.user.factor.Factor;
import com.okta.sdk.resource.user.factor.FactorProfile;
import com.okta.sdk.resource.user.factor.FactorProvider;
import com.okta.sdk.resource.user.factor.FactorStatus;
import com.okta.sdk.resource.user.factor.FactorType;
import com.okta.sdk.resource.user.factor.VerifyFactorRequest;
import com.okta.sdk.resource.user.factor.VerifyFactorResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


import java.util.Map;
import com.okta.sdk.resource.Resource;
import com.okta.sdk.resource.Deletable;
import com.okta.sdk.resource.Saveable;


/**
 * Factor
 */
@javax.annotation.Generated(value = "com.okta.swagger.codegen.OktaJavaClientApiCodegen", date = "2018-05-18T15:09:48.268-04:00")
public interface Factor extends Resource, Deletable {

    Map<String, Object> getEmbedded();

    Map<String, Object> getLinks();

    String getDevice();

    Factor setDevice(String device);

    String getDeviceType();

    FactorType getFactorType();

    Factor setFactorType(FactorType factorType);

    String getId();

    String getMfaStateTokenId();

    Factor setMfaStateTokenId(String mfaStateTokenId);

    FactorProfile getProfile();

    Factor setProfile(FactorProfile profile);

    FactorProvider getProvider();

    Factor setProvider(FactorProvider provider);

    Boolean getRechallengeExistingFactor();

    Factor setRechallengeExistingFactor(Boolean rechallengeExistingFactor);

    String getSessionId();

    Factor setSessionId(String sessionId);

    FactorStatus getStatus();

    String getUserId();

    Factor setUserId(String userId);

    VerifyFactorRequest getVerify();

    Factor setVerify(VerifyFactorRequest verify);


    /**
    * 
    * Unenrolls an existing factor for the specified user, allowing the user to enroll a new factor.
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "DELETE - /api/v1/users/{userId}/factors/{factorId}")
    void delete();


    /**
    * Activate Factor
    * The &#x60;sms&#x60; and &#x60;token:software:totp&#x60; [factor types](#factor-type) require activation to complete the enrollment process.
    * @param body  (required)
    * @return Factor
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "POST - /api/v1/users/{userId}/factors/{factorId}/lifecycle/activate")
    Factor activate(VerifyFactorRequest body);


    /**
    * Verify MFA Factor
    * Verifies an OTP for a &#x60;token&#x60; or &#x60;token:hardware&#x60; factor
    * @param templateId  (optional)
    * @param body  (required)
    * @return VerifyFactorResponse
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "POST - /api/v1/users/{userId}/factors/{factorId}/verify")
    VerifyFactorResponse verify(String templateId, VerifyFactorRequest body);

    /**
    * Verify MFA Factor
    * Verifies an OTP for a &#x60;token&#x60; or &#x60;token:hardware&#x60; factor
    * @param body  (required)
    * @return VerifyFactorResponse
    */
    @javax.annotation.Generated(
            value    = "com.okta.swagger.codegen.OktaJavaClientApiCodegen",
            date     = "2018-05-18T15:09:48.268-04:00",
            comments = "POST - /api/v1/users/{userId}/factors/{factorId}/verify")
    VerifyFactorResponse verify(VerifyFactorRequest body);




}

