/*
 * Decompiled with CFR 0.152.
 */
package com.okta.spring.boot.sdk.cache;

import com.okta.commons.lang.Assert;
import org.springframework.cache.Cache;

public class SpringCache<K, V>
implements com.okta.sdk.cache.Cache<K, V> {
    private final Cache springCache;

    public SpringCache(Cache springCache) {
        Assert.notNull((Object)springCache, (String)"spring cache instance cannot be null.");
        this.springCache = springCache;
    }

    public V get(K key) {
        Cache.ValueWrapper vw = this.springCache.get(key);
        if (vw == null) {
            return null;
        }
        return (V)vw.get();
    }

    public V put(K key, V value) {
        this.springCache.put(key, value);
        return this.get(key);
    }

    public V remove(K key) {
        V v = this.get(key);
        this.springCache.evict(key);
        return v;
    }
}

