/*
 * Decompiled with CFR 0.152.
 */
package com.onelogin.sdk.conn;

import com.onelogin.sdk.conn.OneLoginResponse;
import com.onelogin.sdk.conn.OneloginOAuthJSONAccessTokenResponse;
import com.onelogin.sdk.conn.OneloginOAuthJSONResourceResponse;
import com.onelogin.sdk.conn.OneloginURLConnectionClient;
import com.onelogin.sdk.exception.Error;
import com.onelogin.sdk.model.App;
import com.onelogin.sdk.model.AuthFactor;
import com.onelogin.sdk.model.EmbedApp;
import com.onelogin.sdk.model.Event;
import com.onelogin.sdk.model.EventType;
import com.onelogin.sdk.model.FactorEnrollmentResponse;
import com.onelogin.sdk.model.Group;
import com.onelogin.sdk.model.MFA;
import com.onelogin.sdk.model.OTPDevice;
import com.onelogin.sdk.model.RateLimit;
import com.onelogin.sdk.model.Role;
import com.onelogin.sdk.model.SAMLEndpointResponse;
import com.onelogin.sdk.model.SessionTokenInfo;
import com.onelogin.sdk.model.SessionTokenMFAInfo;
import com.onelogin.sdk.model.User;
import com.onelogin.sdk.util.Settings;
import java.io.IOException;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.oltu.oauth2.client.HttpClient;
import org.apache.oltu.oauth2.client.OAuthClient;
import org.apache.oltu.oauth2.client.request.OAuthBearerClientRequest;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.exception.OAuthRuntimeException;
import org.apache.oltu.oauth2.common.exception.OAuthSystemException;
import org.apache.oltu.oauth2.common.message.types.GrantType;
import org.apache.oltu.oauth2.common.utils.JSONUtils;
import org.joda.time.DateTime;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Client {
    public static final String VERSION = "1.4.1";
    public static final String CUSTOM_USER_AGENT = "onelogin-java-sdk 1.4.1";
    protected String accessToken;
    protected String refreshToken;
    protected DateTime expiration;
    protected String error;
    protected String errorDescription;
    protected String errorAttribute;
    protected Settings settings;
    public String userAgent;
    public int maxResults;

    public Client(int maxResults, boolean throwOAuthProblemException) throws IOException, Error {
        this.settings = new Settings();
        this.userAgent = CUSTOM_USER_AGENT;
        this.maxResults = maxResults;
        OneloginOAuthJSONAccessTokenResponse.enableThrowingOAuthProblemException(throwOAuthProblemException);
        OneloginOAuthJSONResourceResponse.enableThrowingOAuthProblemException(throwOAuthProblemException);
    }

    public Client(int maxResults) throws IOException, Error {
        this(maxResults, true);
    }

    public Client() throws IOException, Error {
        this(1000);
    }

    public Client(boolean throwOAuthProblemException) throws IOException, Error {
        this(1000, true);
    }

    public Client(String clientID, String clientSecret, String region) {
        this(clientID, clientSecret, region, true);
    }

    public Client(String clientID, String clientSecret, String region, boolean throwOAuthProblemException) {
        this.settings = new Settings(clientID, clientSecret, region);
        this.userAgent = CUSTOM_USER_AGENT;
        this.maxResults = 1000;
        OneloginOAuthJSONAccessTokenResponse.enableThrowingOAuthProblemException(throwOAuthProblemException);
        OneloginOAuthJSONResourceResponse.enableThrowingOAuthProblemException(throwOAuthProblemException);
    }

    public void getAccessToken() throws OAuthSystemException, OAuthProblemException {
        this.cleanError();
        OneloginURLConnectionClient httpClient = new OneloginURLConnectionClient();
        OAuthClientRequest request = OAuthClientRequest.tokenLocation((String)this.settings.getURL("https://api.%s.onelogin.com/auth/oauth2/v2/token")).buildBodyMessage();
        Map<String, String> headers = this.getAuthorizedHeader(false);
        HashMap<String, GrantType> params = new HashMap<String, GrantType>();
        params.put("grant_type", GrantType.CLIENT_CREDENTIALS);
        String body = JSONUtils.buildJSON(params);
        request.setBody(body);
        this.updateTokens(httpClient, request, headers);
    }

    public void refreshToken() throws OAuthSystemException, OAuthProblemException {
        this.cleanError();
        if (this.accessToken == null || this.refreshToken == null) {
            throw new OAuthRuntimeException("Access token ot Refresh token not provided");
        }
        OneloginURLConnectionClient httpClient = new OneloginURLConnectionClient();
        OAuthClientRequest request = OAuthClientRequest.tokenLocation((String)this.settings.getURL("https://api.%s.onelogin.com/auth/oauth2/v2/token")).buildBodyMessage();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("User-Agent", this.userAgent);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("grant_type", GrantType.REFRESH_TOKEN);
        params.put("access_token", this.accessToken);
        params.put("refresh_token", this.refreshToken);
        String body = JSONUtils.buildJSON(params);
        request.setBody(body);
        this.updateTokens(httpClient, request, headers);
    }

    public void revokeToken() throws OAuthSystemException, OAuthProblemException {
        this.cleanError();
        if (this.accessToken == null) {
            throw new OAuthRuntimeException("Access token not provided");
        }
        OneloginURLConnectionClient httpClient = new OneloginURLConnectionClient();
        OAuthClientRequest request = OAuthClientRequest.tokenLocation((String)this.settings.getURL("https://api.%s.onelogin.com/auth/oauth2/revoke")).buildBodyMessage();
        Map<String, String> headers = this.getAuthorizedHeader(false);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("access_token", this.accessToken);
        String body = JSONUtils.buildJSON(params);
        request.setBody(body);
        OneloginOAuthJSONAccessTokenResponse oAuthResponse = httpClient.execute(request, headers, "POST", OneloginOAuthJSONAccessTokenResponse.class);
        if (oAuthResponse.getResponseCode() == 200) {
            this.accessToken = null;
            this.refreshToken = null;
            this.expiration = null;
        } else {
            this.error = oAuthResponse.getError();
            this.errorDescription = oAuthResponse.getErrorDescription();
        }
    }

    public RateLimit getRateLimit() throws OAuthSystemException, OAuthProblemException {
        this.cleanError();
        this.prepareToken();
        OneloginURLConnectionClient httpClient = new OneloginURLConnectionClient();
        OAuthClient oAuthClient = new OAuthClient((HttpClient)httpClient);
        OAuthClientRequest bearerRequest = new OAuthBearerClientRequest(this.settings.getURL("https://api.%s.onelogin.com/auth/rate_limit")).buildHeaderMessage();
        Map<String, String> headers = this.getAuthorizedHeader();
        bearerRequest.setHeaders(headers);
        OneloginOAuthJSONResourceResponse oAuthResponse = (OneloginOAuthJSONResourceResponse)oAuthClient.resource(bearerRequest, "GET", OneloginOAuthJSONResourceResponse.class);
        RateLimit ratelimit = null;
        if (oAuthResponse.getResponseCode() == 200) {
            JSONObject data = oAuthResponse.getData();
            if (data != null) {
                ratelimit = new RateLimit(data);
            }
        } else {
            this.error = oAuthResponse.getError();
            this.errorDescription = oAuthResponse.getErrorDescription();
        }
        return ratelimit;
    }

    public List<User> getUsers(HashMap<String, String> queryParameters, int maxResults) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        ExtractionContext context = this.getResource(queryParameters, "https://api.%s.onelogin.com/api/1/users");
        OneloginOAuthJSONResourceResponse oAuthResponse = null;
        String afterCursor = null;
        ArrayList<User> users = new ArrayList<User>(maxResults);
        while (oAuthResponse == null || users.size() < maxResults && afterCursor != null) {
            oAuthResponse = (OneloginOAuthJSONResourceResponse)context.oAuthClient.resource(context.bearerRequest, "GET", OneloginOAuthJSONResourceResponse.class);
            afterCursor = this.getUsersBatch(users, context.url, context.bearerRequest, oAuthResponse);
            if (afterCursor != null) continue;
            break;
        }
        return users;
    }

    public OneLoginResponse<User> getUsersBatch(int batchSize) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        return this.getUsersBatch(batchSize, null);
    }

    public OneLoginResponse<User> getUsersBatch(int batchSize, String afterCursor) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        return this.getUsersBatch(new HashMap<String, String>(), batchSize, afterCursor);
    }

    public OneLoginResponse<User> getUsersBatch(HashMap<String, String> queryParameters, int batchSize, String afterCursor) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        ExtractionContext context = this.extractResourceBatch(queryParameters, batchSize, afterCursor, "https://api.%s.onelogin.com/api/1/users");
        ArrayList<User> users = new ArrayList<User>(batchSize);
        afterCursor = this.getUsersBatch(users, context.url, context.bearerRequest, context.oAuthResponse);
        return new OneLoginResponse<User>(users, afterCursor);
    }

    private String getUsersBatch(List<User> users, URIBuilder url, OAuthClientRequest bearerRequest, OneloginOAuthJSONResourceResponse oAuthResponse) {
        if (oAuthResponse.getResponseCode() == 200) {
            JSONObject[] dataArray = oAuthResponse.getDataArray();
            if (dataArray != null && dataArray.length > 0) {
                for (JSONObject data : dataArray) {
                    users.add(new User(data));
                }
            }
            return this.collectAfterCursor(url, bearerRequest, oAuthResponse);
        }
        this.error = oAuthResponse.getError();
        this.errorDescription = oAuthResponse.getErrorDescription();
        return null;
    }

    public List<User> getUsers(HashMap<String, String> queryParameters) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        return this.getUsers(queryParameters, this.maxResults);
    }

    public List<User> getUsers(int maxResults) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        return this.getUsers(queryParameters, maxResults);
    }

    public List<User> getUsers() throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        return this.getUsers(queryParameters);
    }

    public User getUser(long id) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        this.cleanError();
        this.prepareToken();
        URIBuilder url = new URIBuilder(this.settings.getURL("https://api.%s.onelogin.com/api/1/users/%s", Long.toString(id)));
        OneloginURLConnectionClient httpClient = new OneloginURLConnectionClient();
        OAuthClient oAuthClient = new OAuthClient((HttpClient)httpClient);
        OAuthClientRequest bearerRequest = new OAuthBearerClientRequest(url.toString()).buildHeaderMessage();
        Map<String, String> headers = this.getAuthorizedHeader();
        bearerRequest.setHeaders(headers);
        User user = null;
        OneloginOAuthJSONResourceResponse oAuthResponse = (OneloginOAuthJSONResourceResponse)oAuthClient.resource(bearerRequest, "GET", OneloginOAuthJSONResourceResponse.class);
        if (oAuthResponse.getResponseCode() == 200) {
            JSONObject data = oAuthResponse.getData();
            user = new User(data);
        } else {
            this.error = oAuthResponse.getError();
            this.errorDescription = oAuthResponse.getErrorDescription();
        }
        return user;
    }

    public List<App> getUserApps(long id) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        this.cleanError();
        this.prepareToken();
        URIBuilder url = new URIBuilder(this.settings.getURL("https://api.%s.onelogin.com/api/1/users/%s/apps", Long.toString(id)));
        OneloginURLConnectionClient httpClient = new OneloginURLConnectionClient();
        OAuthClient oAuthClient = new OAuthClient((HttpClient)httpClient);
        OAuthClientRequest bearerRequest = new OAuthBearerClientRequest(url.toString()).buildHeaderMessage();
        Map<String, String> headers = this.getAuthorizedHeader();
        bearerRequest.setHeaders(headers);
        ArrayList<App> apps = new ArrayList<App>();
        App app = null;
        OneloginOAuthJSONResourceResponse oAuthResponse = (OneloginOAuthJSONResourceResponse)oAuthClient.resource(bearerRequest, "GET", OneloginOAuthJSONResourceResponse.class);
        if (oAuthResponse.getResponseCode() == 200) {
            JSONObject[] dataArray = oAuthResponse.getDataArray();
            if (dataArray != null && dataArray.length > 0) {
                for (JSONObject data : dataArray) {
                    app = new App(data);
                    apps.add(app);
                }
            }
        } else {
            this.error = oAuthResponse.getError();
            this.errorDescription = oAuthResponse.getErrorDescription();
        }
        return apps;
    }

    public List<Integer> getUserRoles(long id) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        this.cleanError();
        this.prepareToken();
        URIBuilder url = new URIBuilder(this.settings.getURL("https://api.%s.onelogin.com/api/1/users/%s/roles", Long.toString(id)));
        OneloginURLConnectionClient httpClient = new OneloginURLConnectionClient();
        OAuthClient oAuthClient = new OAuthClient((HttpClient)httpClient);
        OAuthClientRequest bearerRequest = new OAuthBearerClientRequest(url.toString()).buildHeaderMessage();
        Map<String, String> headers = this.getAuthorizedHeader();
        bearerRequest.setHeaders(headers);
        List<Integer> roles = null;
        OneloginOAuthJSONResourceResponse oAuthResponse = (OneloginOAuthJSONResourceResponse)oAuthClient.resource(bearerRequest, "GET", OneloginOAuthJSONResourceResponse.class);
        if (oAuthResponse.getResponseCode() == 200) {
            roles = oAuthResponse.getIdsFromData();
        } else {
            this.error = oAuthResponse.getError();
            this.errorDescription = oAuthResponse.getErrorDescription();
        }
        return roles;
    }

    public List<String> getCustomAttributes() throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        this.cleanError();
        this.prepareToken();
        URIBuilder url = new URIBuilder(this.settings.getURL("https://api.%s.onelogin.com/api/1/users/custom_attributes"));
        OneloginURLConnectionClient httpClient = new OneloginURLConnectionClient();
        OAuthClient oAuthClient = new OAuthClient((HttpClient)httpClient);
        OAuthClientRequest bearerRequest = new OAuthBearerClientRequest(url.toString()).buildHeaderMessage();
        Map<String, String> headers = this.getAuthorizedHeader();
        bearerRequest.setHeaders(headers);
        List<String> customAttributes = null;
        OneloginOAuthJSONResourceResponse oAuthResponse = (OneloginOAuthJSONResourceResponse)oAuthClient.resource(bearerRequest, "GET", OneloginOAuthJSONResourceResponse.class);
        if (oAuthResponse.getResponseCode() == 200) {
            customAttributes = oAuthResponse.getValuesFromData();
        } else {
            this.error = oAuthResponse.getError();
            this.errorDescription = oAuthResponse.getErrorDescription();
        }
        return customAttributes;
    }

    public User createUser(Map<String, Object> userParams) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        this.cleanError();
        this.prepareToken();
        OneloginURLConnectionClient httpClient = new OneloginURLConnectionClient();
        OAuthClient oAuthClient = new OAuthClient((HttpClient)httpClient);
        URIBuilder url = new URIBuilder(this.settings.getURL("https://api.%s.onelogin.com/api/1/users"));
        OAuthClientRequest bearerRequest = new OAuthBearerClientRequest(url.toString()).buildHeaderMessage();
        Map<String, String> headers = this.getAuthorizedHeader();
        bearerRequest.setHeaders(headers);
        String body = JSONUtils.buildJSON(userParams);
        bearerRequest.setBody(body);
        User user = null;
        OneloginOAuthJSONResourceResponse oAuthResponse = (OneloginOAuthJSONResourceResponse)oAuthClient.resource(bearerRequest, "POST", OneloginOAuthJSONResourceResponse.class);
        if (oAuthResponse.getResponseCode() == 200) {
            if (oAuthResponse.getType().equals("success") && oAuthResponse.getMessage().equals("Success")) {
                JSONObject data = oAuthResponse.getData();
                user = new User(data);
            }
        } else {
            this.error = oAuthResponse.getError();
            this.errorDescription = oAuthResponse.getErrorDescription();
            this.errorAttribute = oAuthResponse.getErrorAttribute();
        }
        return user;
    }

    public Object createSessionLoginToken(Map<String, Object> queryParams, String allowedOrigin) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        this.cleanError();
        this.prepareToken();
        OneloginURLConnectionClient httpClient = new OneloginURLConnectionClient();
        OAuthClient oAuthClient = new OAuthClient((HttpClient)httpClient);
        URIBuilder url = new URIBuilder(this.settings.getURL("https://api.%s.onelogin.com/api/1/login/auth"));
        OAuthClientRequest bearerRequest = new OAuthBearerClientRequest(url.toString()).buildHeaderMessage();
        Map<String, String> headers = this.getAuthorizedHeader();
        if (allowedOrigin != null) {
            headers.put("Custom-Allowed-Origin-Header-1", allowedOrigin);
        }
        bearerRequest.setHeaders(headers);
        String body = JSONUtils.buildJSON(queryParams);
        bearerRequest.setBody(body);
        Object sessionToken = null;
        OneloginOAuthJSONResourceResponse oAuthResponse = (OneloginOAuthJSONResourceResponse)oAuthClient.resource(bearerRequest, "POST", OneloginOAuthJSONResourceResponse.class);
        if (oAuthResponse.getResponseCode() == 200) {
            if (oAuthResponse.getType().equals("success")) {
                JSONObject data = oAuthResponse.getData();
                if (oAuthResponse.getMessage().equals("Success")) {
                    sessionToken = new SessionTokenInfo(data);
                } else if (oAuthResponse.getMessage().equals("MFA is required for this user")) {
                    sessionToken = new SessionTokenMFAInfo(data);
                }
            }
        } else {
            this.error = oAuthResponse.getError();
            this.errorDescription = oAuthResponse.getErrorDescription();
        }
        return sessionToken;
    }

    public Object createSessionLoginToken(Map<String, Object> queryParams) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        return this.createSessionLoginToken(queryParams, null);
    }

    public SessionTokenInfo getSessionTokenVerified(String devideId, String stateToken, String otpToken, String allowedOrigin, Boolean doNotNotify) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        this.cleanError();
        this.prepareToken();
        URIBuilder url = new URIBuilder(this.settings.getURL("https://api.%s.onelogin.com/api/1/login/verify_factor"));
        OneloginURLConnectionClient httpClient = new OneloginURLConnectionClient();
        OAuthClient oAuthClient = new OAuthClient((HttpClient)httpClient);
        OAuthClientRequest bearerRequest = new OAuthBearerClientRequest(url.toString()).buildHeaderMessage();
        Map<String, String> headers = this.getAuthorizedHeader();
        if (allowedOrigin != null) {
            headers.put("Custom-Allowed-Origin-Header-1", allowedOrigin);
        }
        bearerRequest.setHeaders(headers);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("device_id", devideId);
        params.put("state_token", stateToken);
        params.put("do_not_notify", doNotNotify);
        if (otpToken != null && !otpToken.isEmpty()) {
            params.put("otp_token", otpToken);
        }
        String body = JSONUtils.buildJSON(params);
        bearerRequest.setBody(body);
        SessionTokenInfo sessionToken = null;
        OneloginOAuthJSONResourceResponse oAuthResponse = (OneloginOAuthJSONResourceResponse)oAuthClient.resource(bearerRequest, "POST", OneloginOAuthJSONResourceResponse.class);
        if (oAuthResponse.getResponseCode() == 200) {
            if (oAuthResponse.getType().equals("success") && oAuthResponse.getMessage().equals("Success")) {
                JSONObject data = oAuthResponse.getData();
                sessionToken = new SessionTokenInfo(data);
            }
        } else {
            this.error = oAuthResponse.getError();
            this.errorDescription = oAuthResponse.getErrorDescription();
        }
        return sessionToken;
    }

    public SessionTokenInfo getSessionTokenVerified(String devideId, String stateToken, String otpToken, String allowedOrigin) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        return this.getSessionTokenVerified(devideId, stateToken, otpToken, allowedOrigin, false);
    }

    public SessionTokenInfo getSessionTokenVerified(String devideId, String stateToken, String otpToken) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        return this.getSessionTokenVerified(devideId, stateToken, otpToken, null, false);
    }

    public SessionTokenInfo getSessionTokenVerified(String devideId, String stateToken) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        return this.getSessionTokenVerified(devideId, stateToken, null);
    }

    public User updateUser(long id, Map<String, Object> userParams) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        this.cleanError();
        this.prepareToken();
        OneloginURLConnectionClient httpClient = new OneloginURLConnectionClient();
        OAuthClient oAuthClient = new OAuthClient((HttpClient)httpClient);
        URIBuilder url = new URIBuilder(this.settings.getURL("https://api.%s.onelogin.com/api/1/users/%s", Long.toString(id)));
        OAuthClientRequest bearerRequest = new OAuthBearerClientRequest(url.toString()).buildHeaderMessage();
        Map<String, String> headers = this.getAuthorizedHeader();
        bearerRequest.setHeaders(headers);
        String body = JSONUtils.buildJSON(userParams);
        bearerRequest.setBody(body);
        User user = null;
        OneloginOAuthJSONResourceResponse oAuthResponse = (OneloginOAuthJSONResourceResponse)oAuthClient.resource(bearerRequest, "PUT", OneloginOAuthJSONResourceResponse.class);
        if (oAuthResponse.getResponseCode() == 200) {
            if (oAuthResponse.getType().equals("success") && oAuthResponse.getMessage().equals("Success")) {
                JSONObject data = oAuthResponse.getData();
                user = new User(data);
            }
        } else {
            this.error = oAuthResponse.getError();
            this.errorDescription = oAuthResponse.getErrorDescription();
            this.errorAttribute = oAuthResponse.getErrorAttribute();
        }
        return user;
    }

    public Boolean assignRoleToUser(long id, List<Long> roleIds) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        this.cleanError();
        this.prepareToken();
        OneloginURLConnectionClient httpClient = new OneloginURLConnectionClient();
        OAuthClient oAuthClient = new OAuthClient((HttpClient)httpClient);
        URIBuilder url = new URIBuilder(this.settings.getURL("https://api.%s.onelogin.com/api/1/users/%s/add_roles", Long.toString(id)));
        OAuthClientRequest bearerRequest = new OAuthBearerClientRequest(url.toString()).buildHeaderMessage();
        Map<String, String> headers = this.getAuthorizedHeader();
        bearerRequest.setHeaders(headers);
        HashMap<String, List<Long>> params = new HashMap<String, List<Long>>();
        params.put("role_id_array", roleIds);
        String body = JSONUtils.buildJSON(params);
        bearerRequest.setBody(body);
        Boolean success = true;
        OneloginOAuthJSONResourceResponse oAuthResponse = (OneloginOAuthJSONResourceResponse)oAuthClient.resource(bearerRequest, "PUT", OneloginOAuthJSONResourceResponse.class);
        if (oAuthResponse.getResponseCode() != 200) {
            success = false;
            this.error = oAuthResponse.getError();
            this.errorDescription = oAuthResponse.getErrorDescription();
            this.errorAttribute = oAuthResponse.getErrorAttribute();
        }
        return success;
    }

    public Boolean removeRoleFromUser(long id, List<Long> roleIds) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        this.cleanError();
        this.prepareToken();
        OneloginURLConnectionClient httpClient = new OneloginURLConnectionClient();
        OAuthClient oAuthClient = new OAuthClient((HttpClient)httpClient);
        URIBuilder url = new URIBuilder(this.settings.getURL("https://api.%s.onelogin.com/api/1/users/%s/remove_roles", Long.toString(id)));
        OAuthClientRequest bearerRequest = new OAuthBearerClientRequest(url.toString()).buildHeaderMessage();
        Map<String, String> headers = this.getAuthorizedHeader();
        bearerRequest.setHeaders(headers);
        HashMap<String, List<Long>> params = new HashMap<String, List<Long>>();
        params.put("role_id_array", roleIds);
        String body = JSONUtils.buildJSON(params);
        bearerRequest.setBody(body);
        Boolean success = true;
        OneloginOAuthJSONResourceResponse oAuthResponse = (OneloginOAuthJSONResourceResponse)oAuthClient.resource(bearerRequest, "PUT", OneloginOAuthJSONResourceResponse.class);
        if (oAuthResponse.getResponseCode() != 200) {
            success = false;
            this.error = oAuthResponse.getError();
            this.errorDescription = oAuthResponse.getErrorDescription();
            this.errorAttribute = oAuthResponse.getErrorAttribute();
        }
        return success;
    }

    public Boolean setPasswordUsingClearText(long id, String password, String passwordConfirmation) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        this.cleanError();
        this.prepareToken();
        OneloginURLConnectionClient httpClient = new OneloginURLConnectionClient();
        OAuthClient oAuthClient = new OAuthClient((HttpClient)httpClient);
        URIBuilder url = new URIBuilder(this.settings.getURL("https://api.%s.onelogin.com/api/1/users/set_password_clear_text/%s", Long.toString(id)));
        OAuthClientRequest bearerRequest = new OAuthBearerClientRequest(url.toString()).buildHeaderMessage();
        Map<String, String> headers = this.getAuthorizedHeader();
        bearerRequest.setHeaders(headers);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("password", password);
        params.put("password_confirmation", passwordConfirmation);
        String body = JSONUtils.buildJSON(params);
        bearerRequest.setBody(body);
        Boolean success = true;
        OneloginOAuthJSONResourceResponse oAuthResponse = (OneloginOAuthJSONResourceResponse)oAuthClient.resource(bearerRequest, "PUT", OneloginOAuthJSONResourceResponse.class);
        if (oAuthResponse.getResponseCode() != 200) {
            success = false;
            this.error = oAuthResponse.getError();
            this.errorDescription = oAuthResponse.getErrorDescription();
            this.errorAttribute = oAuthResponse.getErrorAttribute();
        }
        return success;
    }

    public Boolean setPasswordUsingHashSalt(long id, String password, String passwordConfirmation, String passwordAlgorithm, String passwordSalt) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        this.cleanError();
        this.prepareToken();
        OneloginURLConnectionClient httpClient = new OneloginURLConnectionClient();
        OAuthClient oAuthClient = new OAuthClient((HttpClient)httpClient);
        URIBuilder url = new URIBuilder(this.settings.getURL("https://api.%s.onelogin.com/api/1/users/set_password_using_salt/%s", Long.toString(id)));
        OAuthClientRequest bearerRequest = new OAuthBearerClientRequest(url.toString()).buildHeaderMessage();
        Map<String, String> headers = this.getAuthorizedHeader();
        bearerRequest.setHeaders(headers);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("password", password);
        params.put("password_confirmation", passwordConfirmation);
        params.put("password_algorithm", passwordAlgorithm);
        if (passwordSalt != null && !passwordSalt.isEmpty()) {
            params.put("password_salt", passwordSalt);
        }
        String body = JSONUtils.buildJSON(params);
        bearerRequest.setBody(body);
        Boolean success = true;
        OneloginOAuthJSONResourceResponse oAuthResponse = (OneloginOAuthJSONResourceResponse)oAuthClient.resource(bearerRequest, "PUT", OneloginOAuthJSONResourceResponse.class);
        if (oAuthResponse.getResponseCode() != 200) {
            success = false;
            this.error = oAuthResponse.getError();
            this.errorDescription = oAuthResponse.getErrorDescription();
            this.errorAttribute = oAuthResponse.getErrorAttribute();
        }
        return success;
    }

    public Boolean setPasswordUsingHashSalt(long id, String password, String passwordConfirmation, String passwordAlgorithm) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        return this.setPasswordUsingHashSalt(id, password, passwordConfirmation, passwordAlgorithm, null);
    }

    public Boolean setStateToUser(long id, int state) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        this.cleanError();
        this.prepareToken();
        OneloginURLConnectionClient httpClient = new OneloginURLConnectionClient();
        OAuthClient oAuthClient = new OAuthClient((HttpClient)httpClient);
        URIBuilder url = new URIBuilder(this.settings.getURL("https://api.%s.onelogin.com/api/1/users/%s/set_state", Long.toString(id)));
        OAuthClientRequest bearerRequest = new OAuthBearerClientRequest(url.toString()).buildHeaderMessage();
        Map<String, String> headers = this.getAuthorizedHeader();
        bearerRequest.setHeaders(headers);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("state", state);
        String body = JSONUtils.buildJSON(params);
        bearerRequest.setBody(body);
        Boolean success = true;
        OneloginOAuthJSONResourceResponse oAuthResponse = (OneloginOAuthJSONResourceResponse)oAuthClient.resource(bearerRequest, "PUT", OneloginOAuthJSONResourceResponse.class);
        if (oAuthResponse.getResponseCode() != 200) {
            success = false;
            this.error = oAuthResponse.getError();
            this.errorDescription = oAuthResponse.getErrorDescription();
            this.errorAttribute = oAuthResponse.getErrorAttribute();
        }
        return success;
    }

    public Boolean setCustomAttributeToUser(long id, Map<String, Object> customAttributes) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        this.cleanError();
        this.prepareToken();
        OneloginURLConnectionClient httpClient = new OneloginURLConnectionClient();
        OAuthClient oAuthClient = new OAuthClient((HttpClient)httpClient);
        URIBuilder url = new URIBuilder(this.settings.getURL("https://api.%s.onelogin.com/api/1/users/%s/set_custom_attributes", Long.toString(id)));
        OAuthClientRequest bearerRequest = new OAuthBearerClientRequest(url.toString()).buildHeaderMessage();
        Map<String, String> headers = this.getAuthorizedHeader();
        bearerRequest.setHeaders(headers);
        HashMap<String, Map<String, Object>> params = new HashMap<String, Map<String, Object>>();
        params.put("custom_attributes", customAttributes);
        String body = JSONUtils.buildJSON(params);
        bearerRequest.setBody(body);
        Boolean success = true;
        OneloginOAuthJSONResourceResponse oAuthResponse = (OneloginOAuthJSONResourceResponse)oAuthClient.resource(bearerRequest, "PUT", OneloginOAuthJSONResourceResponse.class);
        if (oAuthResponse.getResponseCode() != 200) {
            success = false;
            this.error = oAuthResponse.getError();
            this.errorDescription = oAuthResponse.getErrorDescription();
            this.errorAttribute = oAuthResponse.getErrorAttribute();
        }
        return success;
    }

    public Boolean logUserOut(long id) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        this.cleanError();
        this.prepareToken();
        OneloginURLConnectionClient httpClient = new OneloginURLConnectionClient();
        OAuthClient oAuthClient = new OAuthClient((HttpClient)httpClient);
        URIBuilder url = new URIBuilder(this.settings.getURL("https://api.%s.onelogin.com/api/1/users/%s/logout", Long.toString(id)));
        OAuthClientRequest bearerRequest = new OAuthBearerClientRequest(url.toString()).buildHeaderMessage();
        Map<String, String> headers = this.getAuthorizedHeader();
        bearerRequest.setHeaders(headers);
        Boolean success = true;
        OneloginOAuthJSONResourceResponse oAuthResponse = (OneloginOAuthJSONResourceResponse)oAuthClient.resource(bearerRequest, "PUT", OneloginOAuthJSONResourceResponse.class);
        if (oAuthResponse.getResponseCode() != 200) {
            success = false;
            this.error = oAuthResponse.getError();
            this.errorDescription = oAuthResponse.getErrorDescription();
            this.errorAttribute = oAuthResponse.getErrorAttribute();
        }
        return success;
    }

    public Boolean lockUser(long id, int minutes) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        this.cleanError();
        this.prepareToken();
        OneloginURLConnectionClient httpClient = new OneloginURLConnectionClient();
        OAuthClient oAuthClient = new OAuthClient((HttpClient)httpClient);
        URIBuilder url = new URIBuilder(this.settings.getURL("https://api.%s.onelogin.com/api/1/users/%s/lock_user", Long.toString(id)));
        OAuthClientRequest bearerRequest = new OAuthBearerClientRequest(url.toString()).buildHeaderMessage();
        Map<String, String> headers = this.getAuthorizedHeader();
        bearerRequest.setHeaders(headers);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("locked_until", minutes);
        String body = JSONUtils.buildJSON(params);
        bearerRequest.setBody(body);
        Boolean success = true;
        OneloginOAuthJSONResourceResponse oAuthResponse = (OneloginOAuthJSONResourceResponse)oAuthClient.resource(bearerRequest, "PUT", OneloginOAuthJSONResourceResponse.class);
        if (oAuthResponse.getResponseCode() != 200) {
            success = false;
            this.error = oAuthResponse.getError();
            this.errorDescription = oAuthResponse.getErrorDescription();
            this.errorAttribute = oAuthResponse.getErrorAttribute();
        }
        return success;
    }

    public Boolean deleteUser(long id) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        this.cleanError();
        this.prepareToken();
        OneloginURLConnectionClient httpClient = new OneloginURLConnectionClient();
        OAuthClient oAuthClient = new OAuthClient((HttpClient)httpClient);
        URIBuilder url = new URIBuilder(this.settings.getURL("https://api.%s.onelogin.com/api/1/users/%s", Long.toString(id)));
        OAuthClientRequest bearerRequest = new OAuthBearerClientRequest(url.toString()).buildHeaderMessage();
        Map<String, String> headers = this.getAuthorizedHeader();
        bearerRequest.setHeaders(headers);
        Boolean removed = true;
        OneloginOAuthJSONResourceResponse oAuthResponse = (OneloginOAuthJSONResourceResponse)oAuthClient.resource(bearerRequest, "DELETE", OneloginOAuthJSONResourceResponse.class);
        if (oAuthResponse.getResponseCode() != 200) {
            removed = false;
            this.error = oAuthResponse.getError();
            this.errorDescription = oAuthResponse.getErrorDescription();
            this.errorAttribute = oAuthResponse.getErrorAttribute();
        }
        return removed;
    }

    public List<Role> getRoles(HashMap<String, String> queryParameters, int maxResults) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        ExtractionContext context = this.getResource(queryParameters, "https://api.%s.onelogin.com/api/1/roles");
        OneloginOAuthJSONResourceResponse oAuthResponse = null;
        String afterCursor = null;
        ArrayList<Role> roles = new ArrayList<Role>(maxResults);
        while (oAuthResponse == null || roles.size() < maxResults && afterCursor != null) {
            oAuthResponse = (OneloginOAuthJSONResourceResponse)context.oAuthClient.resource(context.bearerRequest, "GET", OneloginOAuthJSONResourceResponse.class);
            afterCursor = this.getRolesBatch(roles, context.url, context.bearerRequest, oAuthResponse);
            if (afterCursor != null) continue;
            break;
        }
        return roles;
    }

    public OneLoginResponse<Role> getRolesBatch(int batchSize) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        return this.getRolesBatch(batchSize, null);
    }

    public OneLoginResponse<Role> getRolesBatch(int batchSize, String afterCursor) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        return this.getRolesBatch(new HashMap<String, String>(), batchSize, afterCursor);
    }

    public OneLoginResponse<Role> getRolesBatch(HashMap<String, String> queryParameters, int batchSize, String afterCursor) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        ExtractionContext context = this.extractResourceBatch(queryParameters, batchSize, afterCursor, "https://api.%s.onelogin.com/api/1/roles");
        ArrayList<Role> roles = new ArrayList<Role>(batchSize);
        afterCursor = this.getRolesBatch(roles, context.url, context.bearerRequest, context.oAuthResponse);
        return new OneLoginResponse<Role>(roles, afterCursor);
    }

    private String getRolesBatch(List<Role> roles, URIBuilder url, OAuthClientRequest bearerRequest, OneloginOAuthJSONResourceResponse oAuthResponse) {
        if (oAuthResponse.getResponseCode() == 200) {
            JSONObject[] dataArray = oAuthResponse.getDataArray();
            if (dataArray != null && dataArray.length > 0) {
                for (JSONObject data : dataArray) {
                    roles.add(new Role(data));
                }
            }
            return this.collectAfterCursor(url, bearerRequest, oAuthResponse);
        }
        this.error = oAuthResponse.getError();
        this.errorDescription = oAuthResponse.getErrorDescription();
        return null;
    }

    public List<Role> getRoles(HashMap<String, String> queryParameters) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        return this.getRoles(queryParameters, this.maxResults);
    }

    public List<Role> getRoles(int maxResults) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        return this.getRoles(queryParameters, maxResults);
    }

    public List<Role> getRoles() throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        return this.getRoles(queryParameters);
    }

    public Role getRole(long id) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        this.cleanError();
        this.prepareToken();
        URIBuilder url = new URIBuilder(this.settings.getURL("https://api.%s.onelogin.com/api/1/roles/%s", Long.toString(id)));
        OneloginURLConnectionClient httpClient = new OneloginURLConnectionClient();
        OAuthClient oAuthClient = new OAuthClient((HttpClient)httpClient);
        OAuthClientRequest bearerRequest = new OAuthBearerClientRequest(url.toString()).buildHeaderMessage();
        Map<String, String> headers = this.getAuthorizedHeader();
        bearerRequest.setHeaders(headers);
        Role role = null;
        OneloginOAuthJSONResourceResponse oAuthResponse = (OneloginOAuthJSONResourceResponse)oAuthClient.resource(bearerRequest, "GET", OneloginOAuthJSONResourceResponse.class);
        if (oAuthResponse.getResponseCode() == 200) {
            JSONObject data = oAuthResponse.getData();
            role = new Role(data);
        } else {
            this.error = oAuthResponse.getError();
            this.errorDescription = oAuthResponse.getErrorDescription();
        }
        return role;
    }

    public List<EventType> getEventTypes() throws URISyntaxException, ClientProtocolException, IOException {
        URIBuilder url = new URIBuilder(this.settings.getURL("https://api.%s.onelogin.com/api/1/events/types"));
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpGet httpGet = new HttpGet(url.toString());
        httpGet.setHeader("Accept", "application/json");
        CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
        String json_string = EntityUtils.toString((HttpEntity)response.getEntity());
        JSONObject json_object = new JSONObject(json_string);
        JSONArray data = json_object.getJSONArray("data");
        ArrayList<EventType> eventTypes = new ArrayList<EventType>();
        for (int i = 0; i < data.length(); ++i) {
            JSONObject j_object = data.getJSONObject(i);
            EventType eventType = new EventType(j_object);
            eventTypes.add(eventType);
        }
        return eventTypes;
    }

    public List<Event> getEvents(HashMap<String, String> queryParameters, int maxResults) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        ExtractionContext context = this.getResource(queryParameters, "https://api.%s.onelogin.com/api/1/events");
        OneloginOAuthJSONResourceResponse oAuthResponse = null;
        String afterCursor = null;
        ArrayList<Event> events = new ArrayList<Event>(maxResults);
        while (oAuthResponse == null || events.size() < maxResults && afterCursor != null) {
            oAuthResponse = (OneloginOAuthJSONResourceResponse)context.oAuthClient.resource(context.bearerRequest, "GET", OneloginOAuthJSONResourceResponse.class);
            afterCursor = this.getEventsBatch(events, context.url, context.bearerRequest, oAuthResponse);
            if (afterCursor != null) continue;
            break;
        }
        return events;
    }

    public OneLoginResponse<Event> getEventsBatch(int batchSize) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        return this.getEventsBatch(batchSize, null);
    }

    public OneLoginResponse<Event> getEventsBatch(int batchSize, String afterCursor) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        return this.getEventsBatch(new HashMap<String, String>(), batchSize, afterCursor);
    }

    public OneLoginResponse<Event> getEventsBatch(HashMap<String, String> queryParameters, int batchSize, String afterCursor) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        ExtractionContext context = this.extractResourceBatch(queryParameters, batchSize, afterCursor, "https://api.%s.onelogin.com/api/1/events");
        ArrayList<Event> events = new ArrayList<Event>(batchSize);
        afterCursor = this.getEventsBatch(events, context.url, context.bearerRequest, context.oAuthResponse);
        return new OneLoginResponse<Event>(events, afterCursor);
    }

    private String getEventsBatch(List<Event> events, URIBuilder url, OAuthClientRequest bearerRequest, OneloginOAuthJSONResourceResponse oAuthResponse) {
        if (oAuthResponse.getResponseCode() == 200) {
            JSONObject[] dataArray = oAuthResponse.getDataArray();
            if (dataArray != null && dataArray.length > 0) {
                for (JSONObject data : dataArray) {
                    events.add(new Event(data));
                }
            }
            return this.collectAfterCursor(url, bearerRequest, oAuthResponse);
        }
        this.error = oAuthResponse.getError();
        this.errorDescription = oAuthResponse.getErrorDescription();
        return null;
    }

    public List<Event> getEvents(HashMap<String, String> queryParameters) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        return this.getEvents(queryParameters, this.maxResults);
    }

    public List<Event> getEvents(int maxResults) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        return this.getEvents(queryParameters, maxResults);
    }

    public List<Event> getEvents() throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        return this.getEvents(queryParameters);
    }

    public Event getEvent(long id) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        this.cleanError();
        this.prepareToken();
        URIBuilder url = new URIBuilder(this.settings.getURL("https://api.%s.onelogin.com/api/1/events/%s", Long.toString(id)));
        OneloginURLConnectionClient httpClient = new OneloginURLConnectionClient();
        OAuthClient oAuthClient = new OAuthClient((HttpClient)httpClient);
        OAuthClientRequest bearerRequest = new OAuthBearerClientRequest(url.toString()).buildHeaderMessage();
        Map<String, String> headers = this.getAuthorizedHeader();
        bearerRequest.setHeaders(headers);
        Event event = null;
        OneloginOAuthJSONResourceResponse oAuthResponse = (OneloginOAuthJSONResourceResponse)oAuthClient.resource(bearerRequest, "GET", OneloginOAuthJSONResourceResponse.class);
        if (oAuthResponse.getResponseCode() == 200) {
            JSONObject data = oAuthResponse.getData();
            event = new Event(data);
        } else {
            this.error = oAuthResponse.getError();
            this.errorDescription = oAuthResponse.getErrorDescription();
        }
        return event;
    }

    public void createEvent(Map<String, Object> eventParams) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        this.cleanError();
        this.prepareToken();
        OneloginURLConnectionClient httpClient = new OneloginURLConnectionClient();
        OAuthClient oAuthClient = new OAuthClient((HttpClient)httpClient);
        URIBuilder url = new URIBuilder(this.settings.getURL("https://api.%s.onelogin.com/api/1/events"));
        OAuthClientRequest bearerRequest = new OAuthBearerClientRequest(url.toString()).buildHeaderMessage();
        Map<String, String> headers = this.getAuthorizedHeader();
        bearerRequest.setHeaders(headers);
        String body = JSONUtils.buildJSON(eventParams);
        bearerRequest.setBody(body);
        OneloginOAuthJSONResourceResponse oAuthResponse = (OneloginOAuthJSONResourceResponse)oAuthClient.resource(bearerRequest, "POST", OneloginOAuthJSONResourceResponse.class);
        if (oAuthResponse.getResponseCode() != 200 || !oAuthResponse.getType().equals("success")) {
            this.error = oAuthResponse.getError();
            this.errorDescription = oAuthResponse.getErrorDescription();
            this.errorAttribute = oAuthResponse.getErrorAttribute();
        }
    }

    public List<Group> getGroups(int maxResults) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        ExtractionContext context = this.getResource(new HashMap<String, String>(), "https://api.%s.onelogin.com/api/1/groups");
        OneloginOAuthJSONResourceResponse oAuthResponse = null;
        String afterCursor = null;
        ArrayList<Group> groups = new ArrayList<Group>(maxResults);
        while (oAuthResponse == null || groups.size() < maxResults && afterCursor != null) {
            oAuthResponse = (OneloginOAuthJSONResourceResponse)context.oAuthClient.resource(context.bearerRequest, "GET", OneloginOAuthJSONResourceResponse.class);
            afterCursor = this.getGroupsBatch(groups, context.url, context.bearerRequest, oAuthResponse);
            if (afterCursor != null) continue;
            break;
        }
        return groups;
    }

    public List<Group> getGroups() throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        return this.getGroups(this.maxResults);
    }

    public OneLoginResponse<Group> getGroupsBatch(int batchSize) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        return this.getGroupsBatch(batchSize, null);
    }

    public OneLoginResponse<Group> getGroupsBatch(int batchSize, String afterCursor) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        return this.getGroupsBatch(new HashMap<String, String>(), batchSize, afterCursor);
    }

    public OneLoginResponse<Group> getGroupsBatch(HashMap<String, String> queryParameters, int batchSize, String afterCursor) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        ExtractionContext context = this.extractResourceBatch(queryParameters, batchSize, afterCursor, "https://api.%s.onelogin.com/api/1/groups");
        ArrayList<Group> groups = new ArrayList<Group>(batchSize);
        afterCursor = this.getGroupsBatch(groups, context.url, context.bearerRequest, context.oAuthResponse);
        return new OneLoginResponse<Group>(groups, afterCursor);
    }

    private String getGroupsBatch(List<Group> groups, URIBuilder url, OAuthClientRequest bearerRequest, OneloginOAuthJSONResourceResponse oAuthResponse) {
        if (oAuthResponse.getResponseCode() == 200) {
            JSONObject[] dataArray = oAuthResponse.getDataArray();
            if (dataArray != null && dataArray.length > 0) {
                for (JSONObject data : dataArray) {
                    groups.add(new Group(data));
                }
            }
            return this.collectAfterCursor(url, bearerRequest, oAuthResponse);
        }
        this.error = oAuthResponse.getError();
        this.errorDescription = oAuthResponse.getErrorDescription();
        return null;
    }

    public Group getGroup(long id) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        this.cleanError();
        this.prepareToken();
        URIBuilder url = new URIBuilder(this.settings.getURL("https://api.%s.onelogin.com/api/1/groups/%s", Long.toString(id)));
        OneloginURLConnectionClient httpClient = new OneloginURLConnectionClient();
        OAuthClient oAuthClient = new OAuthClient((HttpClient)httpClient);
        OAuthClientRequest bearerRequest = new OAuthBearerClientRequest(url.toString()).buildHeaderMessage();
        Map<String, String> headers = this.getAuthorizedHeader();
        bearerRequest.setHeaders(headers);
        Group group = null;
        OneloginOAuthJSONResourceResponse oAuthResponse = (OneloginOAuthJSONResourceResponse)oAuthClient.resource(bearerRequest, "GET", OneloginOAuthJSONResourceResponse.class);
        if (oAuthResponse.getResponseCode() == 200) {
            JSONObject data = oAuthResponse.getData();
            group = new Group(data);
        } else {
            this.error = oAuthResponse.getError();
            this.errorDescription = oAuthResponse.getErrorDescription();
        }
        return group;
    }

    public SAMLEndpointResponse getSAMLAssertion(String usernameOrEmail, String password, String appId, String subdomain, String ipAddress) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        this.cleanError();
        this.prepareToken();
        URIBuilder url = new URIBuilder(this.settings.getURL("https://api.%s.onelogin.com/api/1/saml_assertion"));
        OneloginURLConnectionClient httpClient = new OneloginURLConnectionClient();
        OAuthClient oAuthClient = new OAuthClient((HttpClient)httpClient);
        OAuthClientRequest bearerRequest = new OAuthBearerClientRequest(url.toString()).buildHeaderMessage();
        Map<String, String> headers = this.getAuthorizedHeader();
        bearerRequest.setHeaders(headers);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("username_or_email", usernameOrEmail);
        params.put("password", password);
        params.put("app_id", appId);
        params.put("subdomain", subdomain);
        if (ipAddress != null && !ipAddress.isEmpty()) {
            params.put("ip_address", ipAddress);
        }
        String body = JSONUtils.buildJSON(params);
        bearerRequest.setBody(body);
        SAMLEndpointResponse samlEndpointResponse = null;
        OneloginOAuthJSONResourceResponse oAuthResponse = (OneloginOAuthJSONResourceResponse)oAuthClient.resource(bearerRequest, "POST", OneloginOAuthJSONResourceResponse.class);
        if (oAuthResponse.getResponseCode() == 200) {
            samlEndpointResponse = new SAMLEndpointResponse(oAuthResponse.getType(), oAuthResponse.getMessage());
            if (oAuthResponse.getType().equals("success")) {
                if (oAuthResponse.getMessage().equals("Success")) {
                    samlEndpointResponse.setSAMLResponse(oAuthResponse.getStringFromData());
                } else {
                    MFA mfa = new MFA(oAuthResponse.getData());
                    samlEndpointResponse.setMFA(mfa);
                }
            }
        } else {
            this.error = oAuthResponse.getError();
            this.errorDescription = oAuthResponse.getErrorDescription();
        }
        return samlEndpointResponse;
    }

    public SAMLEndpointResponse getSAMLAssertion(String usernameOrEmail, String password, String appId, String subdomain) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        return this.getSAMLAssertion(usernameOrEmail, password, appId, subdomain, null);
    }

    public SAMLEndpointResponse getSAMLAssertionVerifying(String appId, String devideId, String stateToken, String otpToken, String urlEndpoint, Boolean doNotNotify) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        String target;
        this.cleanError();
        this.prepareToken();
        if (urlEndpoint != null && !urlEndpoint.isEmpty()) {
            target = urlEndpoint;
        } else {
            URIBuilder url = new URIBuilder(this.settings.getURL("https://api.%s.onelogin.com/api/1/saml_assertion/verify_factor"));
            target = url.toString();
        }
        OneloginURLConnectionClient httpClient = new OneloginURLConnectionClient();
        OAuthClient oAuthClient = new OAuthClient((HttpClient)httpClient);
        OAuthClientRequest bearerRequest = new OAuthBearerClientRequest(target).buildHeaderMessage();
        Map<String, String> headers = this.getAuthorizedHeader();
        bearerRequest.setHeaders(headers);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("app_id", appId);
        params.put("device_id", devideId);
        params.put("state_token", stateToken);
        params.put("do_not_notify", doNotNotify);
        if (otpToken != null && !otpToken.isEmpty()) {
            params.put("otp_token", otpToken);
        }
        String body = JSONUtils.buildJSON(params);
        bearerRequest.setBody(body);
        SAMLEndpointResponse samlEndpointResponse = null;
        OneloginOAuthJSONResourceResponse oAuthResponse = (OneloginOAuthJSONResourceResponse)oAuthClient.resource(bearerRequest, "POST", OneloginOAuthJSONResourceResponse.class);
        if (oAuthResponse.getResponseCode() == 200) {
            samlEndpointResponse = new SAMLEndpointResponse(oAuthResponse.getType(), oAuthResponse.getMessage());
            if (oAuthResponse.getType().equals("success") && oAuthResponse.getMessage().equals("Success")) {
                samlEndpointResponse.setSAMLResponse(oAuthResponse.getStringFromData());
            }
        } else {
            this.error = oAuthResponse.getError();
            this.errorDescription = oAuthResponse.getErrorDescription();
        }
        return samlEndpointResponse;
    }

    public SAMLEndpointResponse getSAMLAssertionVerifying(String appId, String devideId, String stateToken, String otpToken, String urlEndpoint) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        return this.getSAMLAssertionVerifying(appId, devideId, stateToken, otpToken, urlEndpoint, false);
    }

    public SAMLEndpointResponse getSAMLAssertionVerifying(String appId, String devideId, String stateToken, String otpToken) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        return this.getSAMLAssertionVerifying(appId, devideId, stateToken, otpToken, null);
    }

    public SAMLEndpointResponse getSAMLAssertionVerifying(String appId, String devideId, String stateToken) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        return this.getSAMLAssertionVerifying(appId, devideId, stateToken, null, null);
    }

    public List<AuthFactor> getFactors(long userId) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        this.cleanError();
        this.prepareToken();
        URIBuilder url = new URIBuilder(this.settings.getURL("https://api.%s.onelogin.com/api/1/users/%s/auth_factors", userId));
        OneloginURLConnectionClient httpClient = new OneloginURLConnectionClient();
        OAuthClient oAuthClient = new OAuthClient((HttpClient)httpClient);
        OAuthClientRequest bearerRequest = new OAuthBearerClientRequest(url.toString()).buildHeaderMessage();
        Map<String, String> headers = this.getAuthorizedHeader();
        bearerRequest.setHeaders(headers);
        ArrayList<AuthFactor> authFactors = new ArrayList<AuthFactor>();
        OneloginOAuthJSONResourceResponse oAuthResponse = (OneloginOAuthJSONResourceResponse)oAuthClient.resource(bearerRequest, "GET", OneloginOAuthJSONResourceResponse.class);
        if (oAuthResponse.getResponseCode() == 200) {
            JSONArray dataArray;
            JSONObject data = oAuthResponse.getData();
            if (data.has("auth_factors") && (dataArray = data.getJSONArray("auth_factors")) != null && dataArray.length() > 0) {
                for (int i = 0; i < dataArray.length(); ++i) {
                    AuthFactor authFactor = new AuthFactor(dataArray.getJSONObject(i));
                    authFactors.add(authFactor);
                }
            }
        } else {
            this.error = oAuthResponse.getError();
            this.errorDescription = oAuthResponse.getErrorDescription();
        }
        return authFactors;
    }

    public OTPDevice enrollFactor(long userId, long factorId, String displayName, String number) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        this.cleanError();
        this.prepareToken();
        URIBuilder url = new URIBuilder(this.settings.getURL("https://api.%s.onelogin.com/api/1/users/%s/otp_devices", userId));
        OneloginURLConnectionClient httpClient = new OneloginURLConnectionClient();
        OAuthClient oAuthClient = new OAuthClient((HttpClient)httpClient);
        OAuthClientRequest bearerRequest = new OAuthBearerClientRequest(url.toString()).buildHeaderMessage();
        Map<String, String> headers = this.getAuthorizedHeader();
        bearerRequest.setHeaders(headers);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("factor_id", factorId);
        params.put("display_name", displayName);
        params.put("number", number);
        String body = JSONUtils.buildJSON(params);
        bearerRequest.setBody(body);
        OTPDevice otpDevice = null;
        OneloginOAuthJSONResourceResponse oAuthResponse = (OneloginOAuthJSONResourceResponse)oAuthClient.resource(bearerRequest, "POST", OneloginOAuthJSONResourceResponse.class);
        if (oAuthResponse.getResponseCode() == 200) {
            JSONObject data = oAuthResponse.getData();
            otpDevice = new OTPDevice(data);
        } else {
            this.error = oAuthResponse.getError();
            this.errorDescription = oAuthResponse.getErrorDescription();
        }
        return otpDevice;
    }

    public List<OTPDevice> getEnrolledFactors(long userId) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        this.cleanError();
        this.prepareToken();
        URIBuilder url = new URIBuilder(this.settings.getURL("https://api.%s.onelogin.com/api/1/users/%s/otp_devices", userId));
        OneloginURLConnectionClient httpClient = new OneloginURLConnectionClient();
        OAuthClient oAuthClient = new OAuthClient((HttpClient)httpClient);
        OAuthClientRequest bearerRequest = new OAuthBearerClientRequest(url.toString()).buildHeaderMessage();
        Map<String, String> headers = this.getAuthorizedHeader();
        bearerRequest.setHeaders(headers);
        ArrayList<OTPDevice> otpDevices = new ArrayList<OTPDevice>();
        OneloginOAuthJSONResourceResponse oAuthResponse = (OneloginOAuthJSONResourceResponse)oAuthClient.resource(bearerRequest, "GET", OneloginOAuthJSONResourceResponse.class);
        if (oAuthResponse.getResponseCode() == 200) {
            JSONArray dataArray;
            JSONObject data = oAuthResponse.getData();
            if (data.has("otp_devices") && (dataArray = data.getJSONArray("otp_devices")) != null && dataArray.length() > 0) {
                for (int i = 0; i < dataArray.length(); ++i) {
                    OTPDevice otpDevice = new OTPDevice(dataArray.getJSONObject(i));
                    otpDevices.add(otpDevice);
                }
            }
        } else {
            this.error = oAuthResponse.getError();
            this.errorDescription = oAuthResponse.getErrorDescription();
        }
        return otpDevices;
    }

    public FactorEnrollmentResponse activateFactor(long userId, long deviceId) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        this.cleanError();
        this.prepareToken();
        URIBuilder url = new URIBuilder(this.settings.getURL("https://api.%s.onelogin.com/api/1/users/%s/otp_devices/%s/trigger", userId, deviceId));
        OneloginURLConnectionClient httpClient = new OneloginURLConnectionClient();
        OAuthClient oAuthClient = new OAuthClient((HttpClient)httpClient);
        OAuthClientRequest bearerRequest = new OAuthBearerClientRequest(url.toString()).buildHeaderMessage();
        Map<String, String> headers = this.getAuthorizedHeader();
        bearerRequest.setHeaders(headers);
        FactorEnrollmentResponse factorEntollmentResponse = null;
        OneloginOAuthJSONResourceResponse oAuthResponse = (OneloginOAuthJSONResourceResponse)oAuthClient.resource(bearerRequest, "POST", OneloginOAuthJSONResourceResponse.class);
        if (oAuthResponse.getResponseCode() == 200) {
            JSONObject data = oAuthResponse.getData();
            factorEntollmentResponse = new FactorEnrollmentResponse(data);
        } else {
            this.error = oAuthResponse.getError();
            this.errorDescription = oAuthResponse.getErrorDescription();
        }
        return factorEntollmentResponse;
    }

    public Boolean verifyFactor(long userId, long deviceId, String otpToken, String stateToken) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        this.cleanError();
        this.prepareToken();
        URIBuilder url = new URIBuilder(this.settings.getURL("https://api.%s.onelogin.com/api/1/users/%s/otp_devices/%s/verify", userId, deviceId));
        url = new URIBuilder("http://pitbulk.no-ip.org/newonelogin/demo1/data.json");
        OneloginURLConnectionClient httpClient = new OneloginURLConnectionClient();
        OAuthClient oAuthClient = new OAuthClient((HttpClient)httpClient);
        OAuthClientRequest bearerRequest = new OAuthBearerClientRequest(url.toString()).buildHeaderMessage();
        Map<String, String> headers = this.getAuthorizedHeader();
        bearerRequest.setHeaders(headers);
        HashMap<String, String> params = new HashMap<String, String>();
        if (otpToken != null && !otpToken.isEmpty()) {
            params.put("otp_token", otpToken);
        }
        if (stateToken != null && !stateToken.isEmpty()) {
            params.put("state_token", stateToken);
        }
        if (!params.isEmpty()) {
            String body = JSONUtils.buildJSON(params);
            bearerRequest.setBody(body);
        }
        Boolean success = true;
        OneloginOAuthJSONResourceResponse oAuthResponse = (OneloginOAuthJSONResourceResponse)oAuthClient.resource(bearerRequest, "POST", OneloginOAuthJSONResourceResponse.class);
        if (oAuthResponse.getResponseCode() != 200) {
            success = false;
            this.error = oAuthResponse.getError();
            this.errorDescription = oAuthResponse.getErrorDescription();
        }
        return success;
    }

    public Boolean verifyFactor(long userId, long deviceId, String otpToken) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        return this.verifyFactor(userId, deviceId, otpToken, null);
    }

    public Boolean verifyFactor(long userId, long deviceId) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        return this.verifyFactor(userId, deviceId, null, null);
    }

    public Boolean removeFactor(long userId, long deviceId) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        this.cleanError();
        this.prepareToken();
        URIBuilder url = new URIBuilder(this.settings.getURL("https://api.%s.onelogin.com/api/1/users/%s/otp_devices/%s", userId, deviceId));
        OneloginURLConnectionClient httpClient = new OneloginURLConnectionClient();
        OAuthClient oAuthClient = new OAuthClient((HttpClient)httpClient);
        OAuthClientRequest bearerRequest = new OAuthBearerClientRequest(url.toString()).buildHeaderMessage();
        Map<String, String> headers = this.getAuthorizedHeader();
        bearerRequest.setHeaders(headers);
        Boolean success = true;
        OneloginOAuthJSONResourceResponse oAuthResponse = (OneloginOAuthJSONResourceResponse)oAuthClient.resource(bearerRequest, "DELETE", OneloginOAuthJSONResourceResponse.class);
        if (oAuthResponse.getResponseCode() != 200) {
            success = false;
            this.error = oAuthResponse.getError();
            this.errorDescription = oAuthResponse.getErrorDescription();
        }
        return success;
    }

    public String generateInviteLink(String email) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        this.cleanError();
        this.prepareToken();
        OneloginURLConnectionClient httpClient = new OneloginURLConnectionClient();
        OAuthClient oAuthClient = new OAuthClient((HttpClient)httpClient);
        URIBuilder url = new URIBuilder(this.settings.getURL("https://api.%s.onelogin.com/api/1/invites/get_invite_link"));
        OAuthClientRequest bearerRequest = new OAuthBearerClientRequest(url.toString()).buildHeaderMessage();
        Map<String, String> headers = this.getAuthorizedHeader();
        bearerRequest.setHeaders(headers);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("email", email);
        String body = JSONUtils.buildJSON(params);
        bearerRequest.setBody(body);
        String urlLink = null;
        OneloginOAuthJSONResourceResponse oAuthResponse = (OneloginOAuthJSONResourceResponse)oAuthClient.resource(bearerRequest, "POST", OneloginOAuthJSONResourceResponse.class);
        if (oAuthResponse.getResponseCode() == 200) {
            if (oAuthResponse.getType().equals("success") && oAuthResponse.getMessage().equals("Success")) {
                Object[] objArray = oAuthResponse.getArrayFromData();
                urlLink = (String)objArray[0];
            }
        } else {
            this.error = oAuthResponse.getError();
            this.errorDescription = oAuthResponse.getErrorDescription();
        }
        return urlLink;
    }

    public Boolean sendInviteLink(String email, String personalEmail) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        this.cleanError();
        this.prepareToken();
        OneloginURLConnectionClient httpClient = new OneloginURLConnectionClient();
        OAuthClient oAuthClient = new OAuthClient((HttpClient)httpClient);
        URIBuilder url = new URIBuilder(this.settings.getURL("https://api.%s.onelogin.com/api/1/invites/send_invite_link"));
        OAuthClientRequest bearerRequest = new OAuthBearerClientRequest(url.toString()).buildHeaderMessage();
        Map<String, String> headers = this.getAuthorizedHeader();
        bearerRequest.setHeaders(headers);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("email", email);
        if (personalEmail != null) {
            params.put("personal_email", personalEmail);
        }
        String body = JSONUtils.buildJSON(params);
        bearerRequest.setBody(body);
        Boolean sent = false;
        OneloginOAuthJSONResourceResponse oAuthResponse = (OneloginOAuthJSONResourceResponse)oAuthClient.resource(bearerRequest, "POST", OneloginOAuthJSONResourceResponse.class);
        if (oAuthResponse.getResponseCode() == 200) {
            if (oAuthResponse.getType().equals("success")) {
                sent = true;
            }
        } else {
            this.error = oAuthResponse.getError();
            this.errorDescription = oAuthResponse.getErrorDescription();
        }
        return sent;
    }

    public Boolean sendInviteLink(String email) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        return this.sendInviteLink(email, null);
    }

    public List<EmbedApp> getEmbedApps(String token, String email) throws URISyntaxException, ClientProtocolException, IOException, ParserConfigurationException, SAXException, XPathExpressionException {
        this.cleanError();
        URIBuilder url = new URIBuilder("https://api.onelogin.com/client/apps/embed2");
        url.addParameter("token", token);
        url.addParameter("email", email);
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpGet httpGet = new HttpGet(url.toString());
        httpGet.setHeader("Accept", "application/json");
        CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);
        String xmlString = EntityUtils.toString((HttpEntity)response.getEntity());
        ArrayList<EmbedApp> embedApps = new ArrayList<EmbedApp>();
        DocumentBuilderFactory docfactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = docfactory.newDocumentBuilder();
        Document doc = builder.parse(new InputSource(new StringReader(xmlString)));
        XPath xpath = XPathFactory.newInstance().newXPath();
        NodeList appNodeList = (NodeList)xpath.evaluate("/apps/app", doc, XPathConstants.NODESET);
        if (appNodeList.getLength() > 0) {
            for (int i = 0; i < appNodeList.getLength(); ++i) {
                Node appNode = appNodeList.item(0);
                NodeList appAttrs = appNode.getChildNodes();
                JSONObject appJson = new JSONObject();
                HashSet<String> desiredAttrs = new HashSet<String>(Arrays.asList("id", "icon", "name", "provisioned", "extension_required", "personal", "login_id"));
                for (int j = 0; j < appAttrs.getLength(); ++j) {
                    String appAttrName = appAttrs.item(j).getNodeName();
                    if (!desiredAttrs.contains(appAttrName)) continue;
                    appJson.put(appAttrName, (Object)appAttrs.item(j).getTextContent());
                }
                EmbedApp embedApp = new EmbedApp(appJson);
                embedApps.add(embedApp);
            }
        }
        return embedApps;
    }

    public void prepareToken() throws OAuthSystemException, OAuthProblemException {
        if (this.accessToken == null) {
            this.getAccessToken();
        } else if (this.isExpired()) {
            this.refreshToken();
        }
    }

    public boolean isExpired() {
        return this.expiration != null && this.expiration.isBeforeNow();
    }

    public String getError() {
        return this.error;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public String getErrorAttribute() {
        return this.errorAttribute;
    }

    public void cleanError() {
        this.error = null;
        this.errorDescription = null;
        this.errorAttribute = null;
    }

    protected Map<String, String> getAuthorizedHeader(Boolean bearer) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("User-Agent", this.userAgent);
        headers.put("Authorization", this.getAuthorization(bearer));
        return headers;
    }

    protected Map<String, String> getAuthorizedHeader() {
        return this.getAuthorizedHeader(true);
    }

    protected String getAuthorization(Boolean bearer) {
        if (bearer.booleanValue()) {
            return "bearer:" + this.accessToken;
        }
        return "client_id:" + this.settings.getClientId() + ", client_secret:" + this.settings.getClientSecret();
    }

    protected String getAuthorization() {
        return this.getAuthorization(true);
    }

    private String collectAfterCursor(URIBuilder url, OAuthClientRequest bearerRequest, OneloginOAuthJSONResourceResponse oAuthResponse) {
        String afterCursor = oAuthResponse.getAfterCursor();
        if (afterCursor != null && !afterCursor.isEmpty()) {
            url.setParameter("after_cursor", afterCursor);
            bearerRequest.setLocationUri(url.toString());
        }
        return afterCursor;
    }

    public String getIP() {
        return this.settings.getIP();
    }

    private void updateTokens(OneloginURLConnectionClient httpClient, OAuthClientRequest request, Map<String, String> headers) throws OAuthSystemException, OAuthProblemException {
        OneloginOAuthJSONAccessTokenResponse oAuthResponse = httpClient.execute(request, headers, "POST", OneloginOAuthJSONAccessTokenResponse.class);
        if (oAuthResponse.getResponseCode() == 200) {
            this.accessToken = oAuthResponse.getAccessToken();
            this.refreshToken = oAuthResponse.getRefreshToken();
            Long expiresIn = oAuthResponse.getExpiresIn();
            this.expiration = null;
            if (expiresIn != null) {
                this.expiration = new DateTime(System.currentTimeMillis() + expiresIn * 1000L);
            }
        } else {
            this.error = oAuthResponse.getError();
            this.errorDescription = oAuthResponse.getErrorDescription();
        }
    }

    private ExtractionContext getResource(HashMap<String, String> queryParameters, String resourceUrl) throws URISyntaxException, OAuthSystemException, OAuthProblemException {
        this.cleanError();
        this.prepareToken();
        URIBuilder url = new URIBuilder(this.settings.getURL(resourceUrl));
        for (Map.Entry<String, String> parameter : queryParameters.entrySet()) {
            url.addParameter(parameter.getKey(), parameter.getValue());
        }
        OneloginURLConnectionClient httpClient = new OneloginURLConnectionClient();
        OAuthClient oAuthClient = new OAuthClient((HttpClient)httpClient);
        OAuthClientRequest bearerRequest = new OAuthBearerClientRequest(url.toString()).buildHeaderMessage();
        Map<String, String> headers = this.getAuthorizedHeader();
        bearerRequest.setHeaders(headers);
        return new ExtractionContext().url(url).request(bearerRequest).client(oAuthClient);
    }

    private ExtractionContext extractResourceBatch(HashMap<String, String> queryParameters, int batchSize, String afterCursor, String resourceUrl) throws OAuthSystemException, OAuthProblemException, URISyntaxException {
        this.cleanError();
        this.prepareToken();
        URIBuilder url = new URIBuilder(this.settings.getURL(resourceUrl));
        if (!queryParameters.containsKey("limit")) {
            url.addParameter("limit", String.valueOf(batchSize));
        }
        for (Map.Entry<String, String> parameter : queryParameters.entrySet()) {
            url.addParameter(parameter.getKey(), parameter.getValue());
        }
        OneloginURLConnectionClient httpClient = new OneloginURLConnectionClient();
        OAuthClient oAuthClient = new OAuthClient((HttpClient)httpClient);
        OAuthClientRequest bearerRequest = new OAuthBearerClientRequest(url.toString()).buildHeaderMessage();
        if (afterCursor != null && !afterCursor.isEmpty()) {
            url.setParameter("after_cursor", afterCursor);
            bearerRequest.setLocationUri(url.toString());
        }
        Map<String, String> headers = this.getAuthorizedHeader();
        bearerRequest.setHeaders(headers);
        OneloginOAuthJSONResourceResponse oAuthResponse = (OneloginOAuthJSONResourceResponse)oAuthClient.resource(bearerRequest, "GET", OneloginOAuthJSONResourceResponse.class);
        return new ExtractionContext().url(url).request(bearerRequest).response(oAuthResponse);
    }

    private class ExtractionContext {
        private OneloginOAuthJSONResourceResponse oAuthResponse;
        private URIBuilder url;
        private OAuthClientRequest bearerRequest;
        private OAuthClient oAuthClient;

        private ExtractionContext() {
        }

        private ExtractionContext url(URIBuilder url) {
            this.url = url;
            return this;
        }

        private ExtractionContext request(OAuthClientRequest bearerRequest) {
            this.bearerRequest = bearerRequest;
            return this;
        }

        private ExtractionContext response(OneloginOAuthJSONResourceResponse oAuthResponse) {
            this.oAuthResponse = oAuthResponse;
            return this;
        }

        private ExtractionContext client(OAuthClient oAuthClient) {
            this.oAuthClient = oAuthClient;
            return this;
        }
    }
}

