/*
 * Decompiled with CFR 0.152.
 */
package com.onelogin.sdk.model;

import com.onelogin.sdk.model.Group;
import com.onelogin.sdk.model.Role;
import org.joda.time.DateTime;
import org.json.JSONObject;

public class Event {
    public long id;
    public DateTime createdAt;
    public int accountId;
    public int userId;
    public String userName;
    public int eventTypeId;
    public String notes;
    public String ipaddr;
    public int actorUserId;
    public String actorUserName;
    public int assumingActingUserId;
    public int roleId;
    public String roleName;
    public int appId;
    public String appName;
    public int groupId;
    public String groupName;
    public int otpDeviceId;
    public String otpDeviceName;
    public int policyId;
    public String policyName;
    public String actorSystem;
    public String customMessage;
    public String operationName;
    public int directorySyncRunId;
    public int directoryId;
    public String resolution;
    public int clientId;
    public int resourceTypeId;
    public String errorDescription;

    public Event(JSONObject data) {
        this.id = data.optLong("id");
        this.createdAt = data.optString("created_at", null) == null ? null : DateTime.parse((String)data.getString("created_at"));
        this.accountId = data.optInt("account_id");
        this.userId = data.optInt("user_id");
        this.userName = data.optString("user_name");
        this.eventTypeId = data.optInt("event_type_id");
        this.notes = data.optString("notes", null);
        this.ipaddr = data.optString("ipaddr", null);
        this.actorUserId = data.optInt("actor_user_id");
        this.actorUserName = data.optString("actor_user_name", null);
        this.assumingActingUserId = data.optInt("assuming_acting_user_id");
        this.roleId = data.optInt("role_id");
        this.roleName = data.optString("role_name", null);
        this.appId = data.optInt("app_id");
        this.appName = data.optString("app_name", null);
        this.groupId = data.optInt("group_id");
        this.groupName = data.optString("group_name", null);
        this.otpDeviceId = data.optInt("otp_device_id");
        this.otpDeviceName = data.optString("otp_device_name", null);
        this.policyId = data.optInt("policy_id");
        this.policyName = data.optString("policy_name", null);
        this.actorSystem = data.optString("actor_system", null);
        this.customMessage = data.optString("custom_message", null);
        this.operationName = data.optString("operation_name", null);
        this.directorySyncRunId = data.optInt("directory_sync_run_id");
        this.directoryId = data.optInt("directory_id");
        this.resolution = data.optString("resolution", null);
        this.clientId = data.optInt("client_id");
        this.resourceTypeId = data.optInt("resource_type_id");
        this.errorDescription = data.optString("error_description", null);
    }

    public Role getRole() {
        Role role = null;
        if (this.roleId != 0 && this.roleName != null) {
            role = new Role(this.roleId, this.roleName);
        }
        return role;
    }

    public Group getGroup() {
        Group group = null;
        if (this.groupId != 0 && this.groupName != null) {
            group = new Group(this.groupId, this.groupName, null);
        }
        return group;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.groupId ^ this.groupId >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Event other = (Event)obj;
        return this.id == other.id;
    }
}

