/*
 * Decompiled with CFR 0.152.
 */
package com.onelogin.sdk.model;

import com.onelogin.sdk.model.UserData;
import com.onelogin.sdk.model.UserMetaData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.json.JSONArray;
import org.json.JSONObject;

public class User {
    public long id;
    public long externalId;
    public String email;
    public String username;
    public String firstname;
    public String lastname;
    public String distinguishedName;
    public String phone;
    public String company;
    public String department;
    public String title;
    public int status;
    public int state;
    public String memberOf;
    public String samaccountname;
    public String userprincipalname;
    public long groupId;
    public List<Long> roleIds;
    public Map<String, String> customAttributes = new HashMap<String, String>();
    public String openidName;
    public String localeCode;
    public String comment;
    public long directoryId;
    public long managerAdId;
    public long trustedIdPId;
    public long managerUserId;
    public DateTime activatedAt;
    public DateTime createdAt;
    public DateTime updatedAt;
    public DateTime passwordChangedAt;
    public int invalidLoginAttempts;
    public DateTime invitationSentAt;
    public DateTime lastLogin;
    public DateTime lockedUntil;

    public User(JSONObject data) {
        this.id = data.optLong("id");
        this.externalId = data.optLong("external_id");
        this.email = data.optString("email", null);
        this.username = data.optString("username", null);
        this.firstname = data.optString("firstname", null);
        this.lastname = data.optString("lastname", null);
        this.distinguishedName = data.optString("distinguished_name", null);
        this.phone = data.optString("phone", null);
        this.company = data.optString("company", null);
        this.department = data.optString("department", null);
        this.title = data.optString("title", null);
        this.status = data.optInt("status");
        this.state = data.optInt("state");
        this.memberOf = data.optString("member_of", null);
        this.samaccountname = data.optString("samaccountname", null);
        this.userprincipalname = data.optString("userprincipalname", null);
        this.groupId = data.optLong("group_id");
        if (!data.isNull("role_id")) {
            this.roleIds = new ArrayList<Long>();
            JSONArray roleData = data.getJSONArray("role_id");
            for (int i = 0; i < roleData.length(); ++i) {
                this.roleIds.add(roleData.getLong(i));
            }
        }
        this.customAttributes = this.readCustomAttributes(data);
        this.openidName = data.optString("openid_name", null);
        this.localeCode = data.optString("locale_code", null);
        this.comment = data.optString("comment", null);
        this.directoryId = data.optLong("directory_id");
        this.managerAdId = data.optLong("manager_ad_id");
        this.trustedIdPId = data.optLong("trusted_idp_id");
        this.managerUserId = data.optLong("manager_user_id");
        this.activatedAt = data.optString("activated_at", null) == null ? null : DateTime.parse((String)data.getString("activated_at"));
        this.createdAt = data.optString("created_at", null) == null ? null : DateTime.parse((String)data.getString("created_at"));
        this.updatedAt = data.optString("updated_at", null) == null ? null : DateTime.parse((String)data.getString("updated_at"));
        this.passwordChangedAt = data.optString("password_changed_at", null) == null ? null : DateTime.parse((String)data.getString("password_changed_at"));
        this.invalidLoginAttempts = data.optInt("invalid_login_attempts");
        this.invitationSentAt = data.optString("invitation_sent_at", null) == null ? null : DateTime.parse((String)data.getString("invitation_sent_at"));
        this.lastLogin = data.optString("last_login", null) == null ? null : DateTime.parse((String)data.getString("last_login"));
        this.lockedUntil = data.optString("locked_until", null) == null ? null : DateTime.parse((String)data.getString("locked_until"));
    }

    public List<Long> getRoleIDs() {
        return this.roleIds;
    }

    public long getGroupID() {
        return this.groupId;
    }

    public UserData getUserData() {
        UserData userData = new UserData();
        userData.id = this.id;
        userData.externalId = this.externalId;
        userData.email = this.email;
        userData.username = this.username;
        userData.firstname = this.firstname;
        userData.lastname = this.lastname;
        userData.distinguishedName = this.distinguishedName;
        userData.phone = this.phone;
        userData.company = this.company;
        userData.department = this.department;
        userData.title = this.title;
        userData.status = this.status;
        userData.state = this.state;
        userData.memberOf = this.memberOf;
        userData.samaccountname = this.samaccountname;
        userData.userprincipalname = this.userprincipalname;
        userData.openidName = this.openidName;
        userData.localeCode = this.localeCode;
        userData.comment = this.comment;
        userData.directoryId = this.directoryId;
        userData.managerAdId = this.managerAdId;
        userData.trustedIdPId = this.trustedIdPId;
        userData.managerUserId = this.managerUserId;
        return userData;
    }

    public UserMetaData getUserMetaData() {
        UserMetaData userMetaData = new UserMetaData();
        userMetaData.activatedAt = this.activatedAt;
        userMetaData.createdAt = this.createdAt;
        userMetaData.updatedAt = this.updatedAt;
        userMetaData.passwordChangedAt = this.passwordChangedAt;
        userMetaData.invalidLoginAttempts = this.invalidLoginAttempts;
        userMetaData.invitationSentAt = this.invitationSentAt;
        userMetaData.lastLogin = this.lastLogin;
        userMetaData.lockedUntil = this.lockedUntil;
        return userMetaData;
    }

    public Map<String, String> getUserCustomAttributes() {
        return this.customAttributes;
    }

    public Map<String, Object> getUserParams() throws NoSuchFieldException {
        HashMap<String, Object> userParams = new HashMap<String, Object>();
        userParams.put("external_id", this.getClass().getField("externalId") == null ? null : Long.toString(this.externalId));
        userParams.put("email", this.email);
        userParams.put("username", this.username);
        userParams.put("firstname", this.firstname);
        userParams.put("lastname", this.lastname);
        userParams.put("distinguished_name", this.distinguishedName);
        userParams.put("phone", this.phone);
        userParams.put("company", this.company);
        userParams.put("department", this.department);
        userParams.put("title", this.title);
        userParams.put("status", this.status);
        userParams.put("state", this.state);
        userParams.put("member_of", this.memberOf);
        userParams.put("samaccountname", this.samaccountname);
        userParams.put("invalid_login_attempts", this.samaccountname);
        userParams.put("userprincipalname", this.userprincipalname);
        userParams.put("group_id", this.getClass().getField("groupId") == null ? null : Long.toString(this.groupId));
        userParams.put("openid_name", this.openidName);
        userParams.put("locale_code", this.localeCode);
        userParams.put("comment", this.comment);
        userParams.put("openid_name", this.openidName);
        userParams.put("directory_id", this.getClass().getField("directoryId") == null ? null : Long.toString(this.directoryId));
        userParams.put("manager_ad_id", this.getClass().getField("managerAdId") == null ? null : Long.toString(this.managerAdId));
        userParams.put("trusted_idp_id", this.getClass().getField("trustedIdPId") == null ? null : Long.toString(this.trustedIdPId));
        userParams.put("manager_user_id", this.getClass().getField("managerUserId") == null ? null : Long.toString(this.managerUserId));
        return userParams;
    }

    private Map<String, String> readCustomAttributes(JSONObject data) {
        JSONObject jsonObject;
        JSONObject jSONObject = jsonObject = data.optJSONObject("custom_attributes") == null ? null : data.getJSONObject("custom_attributes");
        if (jsonObject == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (Object key : jsonObject.keySet()) {
            if (!jsonObject.isNull(String.valueOf(key))) {
                map.put((String)key, (String)jsonObject.get(String.valueOf(key)));
                continue;
            }
            map.put((String)key, null);
        }
        return map;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.groupId ^ this.groupId >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        User other = (User)obj;
        return this.id == other.id;
    }
}

