/*
 * Decompiled with CFR 0.152.
 */
package com.onelogin.sdk.util;

import com.onelogin.sdk.exception.Error;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Settings {
    private static final Logger LOGGER = LoggerFactory.getLogger(Settings.class);
    private Properties prop = new Properties();
    public static final String CLIENT_ID_KEY = "onelogin.sdk.client_id";
    public static final String CLIENT_SECRET_KEY = "onelogin.sdk.client_secret";
    public static final String INSTANCE = "onelogin.sdk.instance";
    public static final String REGION = "onelogin.sdk.region";
    public static final String IP = "onelogin.sdk.ip";
    private String clientID;
    private String clientSecret;
    private String region = "us";
    private String ip;

    public Settings() throws IOException, Error {
        this.loadPropFile("onelogin.sdk.properties");
        this.clientID = this.loadStringProperty(CLIENT_ID_KEY);
        this.clientSecret = this.loadStringProperty(CLIENT_SECRET_KEY);
        String regionValue = this.loadStringProperty(REGION);
        String ip = this.loadStringProperty(IP);
        if (regionValue == null || regionValue.isEmpty()) {
            regionValue = this.loadStringProperty(INSTANCE);
        }
        if (regionValue != null && !regionValue.isEmpty()) {
            this.region = regionValue;
        }
        if (ip != null && !ip.isEmpty()) {
            this.ip = ip;
        }
    }

    public Settings(String clientID, String clientSecret, String region) {
        this.clientID = clientID;
        this.clientSecret = clientSecret;
        this.region = region;
    }

    public String getClientId() {
        return this.clientID;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getRegion() {
        return this.region;
    }

    public String getIP() {
        return this.ip;
    }

    public String getURL(String name, String id, String extraId) {
        if (id == null) {
            return String.format(name, this.region);
        }
        if (extraId == null) {
            return String.format(name, this.region, id);
        }
        return String.format(name, this.region, id, extraId);
    }

    public String getURL(String name, int id, int extraId) {
        if (id == 0) {
            return String.format(name, this.region);
        }
        if (extraId == 0) {
            return String.format(name, this.region, id);
        }
        return String.format(name, this.region, id, extraId);
    }

    public String getURL(String name, long id, long extraId) {
        if (id == 0L) {
            return String.format(name, this.region);
        }
        if (extraId == 0L) {
            return String.format(name, this.region, id);
        }
        return String.format(name, this.region, id, extraId);
    }

    public String getURL(String name, String id) {
        if (id != null) {
            return String.format(name, this.region, id);
        }
        return String.format(name, this.region);
    }

    public String getURL(String name, int id) {
        if (id == 0) {
            return String.format(name, this.region);
        }
        return String.format(name, this.region, id);
    }

    public String getURL(String name, long id) {
        if (id == 0L) {
            return String.format(name, this.region);
        }
        return String.format(name, this.region, id);
    }

    public String getURL(String name) {
        return this.getURL(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPropFile(String propFileName) throws IOException, Error {
        block9: {
            InputStream inputStream = null;
            try {
                inputStream = this.getClass().getClassLoader().getResourceAsStream(propFileName);
                if (inputStream != null) {
                    this.prop.load(inputStream);
                    LOGGER.debug("properties file " + propFileName + " loaded succesfully");
                    break block9;
                }
                String errorMsg = "properties file '" + propFileName + "' not found in the classpath";
                LOGGER.error(errorMsg);
                throw new Error(errorMsg, 1);
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    LOGGER.warn("properties file '" + propFileName + "' not closed properly.");
                }
            }
        }
    }

    private String loadStringProperty(String propertyKey) {
        String propValue = this.prop.getProperty(propertyKey);
        if (propValue != null) {
            propValue = propValue.trim();
        }
        return propValue;
    }

    private Boolean loadBooleanProperty(String propertyKey) {
        String booleanPropValue = this.prop.getProperty(propertyKey);
        if (booleanPropValue != null) {
            return Boolean.parseBoolean(booleanPropValue.trim());
        }
        return null;
    }

    private List<String> loadListProperty(String propertyKey) {
        String arrayPropValue = this.prop.getProperty(propertyKey);
        if (arrayPropValue != null && !arrayPropValue.isEmpty()) {
            String[] values = arrayPropValue.trim().split(",");
            for (int i = 0; i < values.length; ++i) {
                values[i] = values[i].trim();
            }
            return Arrays.asList(values);
        }
        return null;
    }

    private URL loadURLProperty(String propertyKey) {
        String urlPropValue = this.prop.getProperty(propertyKey);
        if (urlPropValue == null || urlPropValue.isEmpty()) {
            return null;
        }
        try {
            return new URL(urlPropValue.trim());
        }
        catch (MalformedURLException e) {
            LOGGER.error("'" + propertyKey + "' contains malformed url.", (Throwable)e);
            return null;
        }
    }
}

