/*
 * Decompiled with CFR 0.152.
 */
package com.onelogin.sdk.model;

import com.onelogin.sdk.model.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class Privilege {
    public String id;
    public String name;
    public String version;
    public List<Statement> statements = new ArrayList<Statement>();

    public Privilege(JSONObject data) {
        this.id = data.optString("id");
        this.name = data.optString("name", null);
        JSONObject privilege = (JSONObject)data.get("privilege");
        if (privilege != null) {
            this.version = privilege.optString("Version", null);
            JSONArray jsonArray = privilege.getJSONArray("Statement");
            if (jsonArray != null && jsonArray.length() > 0) {
                for (int i = 0; i < jsonArray.length(); ++i) {
                    this.statements.add(new Statement(jsonArray.getJSONObject(i)));
                }
            }
        }
    }

    public Privilege(String id, String name, String version, List<?> statements) {
        this.id = id;
        this.name = name;
        this.version = version;
        if (!statements.isEmpty()) {
            List<?> data;
            if (statements.get(0) instanceof Statement) {
                this.statements = statements;
            } else if (statements.get(0) instanceof HashMap && ((HashMap)(data = statements).get(0)).containsKey("Effect") && ((HashMap)data.get(0)).containsKey("Action") && ((HashMap)data.get(0)).containsKey("Scope")) {
                for (HashMap statement : data) {
                    this.statements.add(new Statement(statement.get("Effect").toString(), (List)statement.get("Action"), (List)statement.get("Scope")));
                }
            }
        }
    }
}

