/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.oracle;

import com.playtika.test.common.properties.CommonContainerProperties;
import com.playtika.test.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.test.common.utils.ContainerUtils;
import com.playtika.test.oracle.OracleProperties;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.OracleContainer;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@ConditionalOnProperty(name={"embedded.oracle.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={OracleProperties.class})
public class EmbeddedOracleBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedOracleBootstrapConfiguration.class);

    @Bean(name={"embeddedOracle"}, destroyMethod="stop")
    public OracleContainer oracle(ConfigurableEnvironment environment, OracleProperties properties) {
        log.info("Starting oracle server. Docker image: {}", (Object)properties.dockerImage);
        OracleContainer oracle = (OracleContainer)new OracleContainer(properties.dockerImage).withUsername(properties.getUser()).withPassword(properties.getPassword()).withInitScript(properties.initScriptPath);
        oracle = (OracleContainer)ContainerUtils.configureCommonsAndStart((GenericContainer)oracle, (CommonContainerProperties)properties, (Logger)log);
        this.registerOracleEnvironment(oracle, environment, properties);
        return oracle;
    }

    private void registerOracleEnvironment(OracleContainer oracle, ConfigurableEnvironment environment, OracleProperties properties) {
        Integer mappedPort = oracle.getMappedPort(1521);
        String host = oracle.getContainerIpAddress();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.oracle.port", mappedPort);
        map.put("embedded.oracle.host", host);
        map.put("embedded.oracle.database", properties.getDatabase());
        map.put("embedded.oracle.user", properties.getUser());
        map.put("embedded.oracle.password", properties.getPassword());
        String jdbcURL = "jdbc:oracle://{}:{}/{}";
        log.info("Started oracle server. Connection details: {}, JDBC connection url: " + jdbcURL, new Object[]{map, host, mappedPort, "xe"});
        MapPropertySource propertySource = new MapPropertySource("embeddedOracleInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }
}

