/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.indentation.AbstractExpressionHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentLevel;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentationCheck;
import java.util.Optional;

public class MemberDefHandler
extends AbstractExpressionHandler {
    public MemberDefHandler(IndentationCheck indentCheck, DetailAST ast, AbstractExpressionHandler parent) {
        super(indentCheck, "member def", ast, parent);
    }

    @Override
    public void checkIndentation() {
        DetailAST modifiersNode = this.getMainAst().findFirstToken(5);
        if (modifiersNode.hasChildren()) {
            this.checkModifiers();
        } else {
            this.checkType();
        }
        DetailAST firstNode = this.getMainAst();
        DetailAST lastNode = MemberDefHandler.getArrayInitNode(firstNode).orElseGet(() -> MemberDefHandler.getVarDefStatementSemicolon(firstNode));
        if (lastNode != null) {
            this.checkWrappingIndentation(firstNode, lastNode);
        }
    }

    private static Optional<DetailAST> getArrayInitNode(DetailAST firstNode) {
        return Optional.ofNullable(firstNode.findFirstToken(80)).map(assign -> Optional.ofNullable(assign.findFirstToken(28)).map(expr -> expr.findFirstToken(136)).orElse((DetailAST)assign)).map(node -> node.findFirstToken(29));
    }

    @Override
    public IndentLevel getSuggestedChildIndent(AbstractExpressionHandler child) {
        return this.getIndent();
    }

    @Override
    protected void checkModifiers() {
        DetailAST modifier = this.getMainAst().findFirstToken(5);
        if (this.isOnStartOfLine(modifier) && !this.getIndent().isAcceptable(this.expandedTabsColumnNo(modifier))) {
            this.logError(modifier, "modifier", this.expandedTabsColumnNo(modifier));
        }
    }

    private void checkType() {
        DetailAST type = this.getMainAst().findFirstToken(13);
        DetailAST ident = AbstractExpressionHandler.getFirstToken(type);
        int columnNo = this.expandedTabsColumnNo(ident);
        if (this.isOnStartOfLine(ident) && !this.getIndent().isAcceptable(columnNo)) {
            this.logError(ident, "type", columnNo);
        }
    }

    private static DetailAST getVarDefStatementSemicolon(DetailAST variableDef) {
        DetailAST lastNode = variableDef.getLastChild();
        if (lastNode.getType() != 45) {
            lastNode = variableDef.getNextSibling();
        }
        return lastNode;
    }
}

