/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.utils.UnmodifiableCollectionUtil;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class LocalizedMessage {
    private static Locale sLocale = Locale.getDefault();
    private final String bundle;
    private final Class<?> sourceClass;
    private final String key;
    private final Object[] args;

    public LocalizedMessage(String bundle, Class<?> sourceClass, String key, Object ... args) {
        this.bundle = bundle;
        this.sourceClass = sourceClass;
        this.key = key;
        this.args = args == null ? null : UnmodifiableCollectionUtil.copyOfArray(args, args.length);
    }

    public static void setLocale(Locale locale) {
        sLocale = Locale.ENGLISH.getLanguage().equals(locale.getLanguage()) ? Locale.ROOT : locale;
    }

    public String getMessage() {
        String result;
        try {
            ResourceBundle resourceBundle = this.getBundle();
            String pattern = resourceBundle.getString(this.key);
            MessageFormat formatter = new MessageFormat(pattern, Locale.ROOT);
            result = formatter.format(this.args);
        }
        catch (MissingResourceException ignored) {
            MessageFormat formatter = new MessageFormat(this.key, Locale.ROOT);
            result = formatter.format(this.args);
        }
        return result;
    }

    private ResourceBundle getBundle() {
        return ResourceBundle.getBundle(this.bundle, sLocale, this.sourceClass.getClassLoader(), new Utf8Control());
    }

    public static class Utf8Control
    extends ResourceBundle.Control {
        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IOException {
            URLConnection connection;
            String bundleName = this.toBundleName(baseName, locale);
            String resourceName = this.toResourceName(bundleName, "properties");
            URL url = loader.getResource(resourceName);
            PropertyResourceBundle resourceBundle = null;
            if (url != null && (connection = url.openConnection()) != null) {
                connection.setUseCaches(!reload);
                try (InputStreamReader streamReader = new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8);){
                    resourceBundle = new PropertyResourceBundle(streamReader);
                }
            }
            return resourceBundle;
        }
    }
}

