/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.amqp.impl;

import com.rabbitmq.client.amqp.impl.AmqpBindingManagement;
import com.rabbitmq.client.amqp.impl.AmqpExchangeSpecification;
import com.rabbitmq.client.amqp.impl.AmqpQueueSpecification;
import com.rabbitmq.client.amqp.impl.EventLoop;
import com.rabbitmq.client.amqp.impl.TopologyListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class RecordingTopologyListener
implements TopologyListener,
AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecordingTopologyListener.class);
    private final String label;
    private final EventLoop.Client<State> eventLoopClient;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    RecordingTopologyListener(String label, EventLoop eventLoop) {
        this.label = label;
        this.eventLoopClient = eventLoop.register(() -> new State());
    }

    @Override
    public void exchangeDeclared(AmqpExchangeSpecification specification) {
        this.submit(s -> s.exchanges.put(specification.name(), new ExchangeSpec(specification)));
    }

    @Override
    public void exchangeDeleted(String name) {
        this.submit(s -> {
            s.exchanges.remove(name);
            Set<BindingSpec> deletedBindings = this.deleteBindings((State)s, name, true);
            this.deleteAutoDeleteExchanges((State)s, deletedBindings);
        });
    }

    @Override
    public void queueDeclared(AmqpQueueSpecification specification) {
        this.submit(s -> s.queues.put(specification.name(), new QueueSpec(specification)));
    }

    @Override
    public void queueDeleted(String name) {
        this.submit(s -> {
            s.queues.remove(name);
            Set<BindingSpec> deletedBindings = this.deleteBindings((State)s, name, false);
            this.deleteAutoDeleteExchanges((State)s, deletedBindings);
        });
    }

    @Override
    public void bindingDeclared(AmqpBindingManagement.AmqpBindingSpecification specification) {
        this.submit(s -> s.bindings.add(new BindingSpec(specification.state())));
    }

    @Override
    public void bindingDeleted(AmqpBindingManagement.AmqpUnbindSpecification specification) {
        this.submit(s -> {
            BindingSpec spec = new BindingSpec(specification.state());
            s.bindings.remove(spec);
            this.deleteAutoDeleteExchanges((State)s, Collections.singleton(spec));
        });
    }

    @Override
    public void consumerCreated(long id, String queue) {
        this.submit(s -> s.consumers.put(id, new ConsumerSpec(id, queue)));
    }

    @Override
    public void consumerDeleted(long id, String queue) {
        this.submit(s -> {
            QueueSpec queueSpec;
            s.consumers.remove(id);
            boolean atLeastOneConsumerOnQueue = s.consumers.values().stream().anyMatch(spec -> spec.queue.equals(queue));
            if (!atLeastOneConsumerOnQueue && (queueSpec = s.queues.get(queue)) != null && queueSpec.autoDelete) {
                this.queueDeleted(queue);
            }
        });
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.eventLoopClient.close();
        }
    }

    private void submit(Consumer<State> task) {
        if (!this.closed.get()) {
            this.eventLoopClient.submit(task);
        }
    }

    private Set<BindingSpec> deleteBindings(State s, String name, boolean exchange) {
        LinkedHashSet<BindingSpec> deletedBindings = new LinkedHashSet<BindingSpec>();
        Iterator<BindingSpec> iterator = s.bindings.iterator();
        while (iterator.hasNext()) {
            BindingSpec spec = iterator.next();
            if (!spec.isInvolved(name, exchange)) continue;
            iterator.remove();
            deletedBindings.add(spec);
        }
        return deletedBindings;
    }

    private void deleteAutoDeleteExchanges(State s, Set<BindingSpec> deletedBindings) {
        for (BindingSpec binding : deletedBindings) {
            ExchangeSpec exchange;
            String source = binding.source;
            boolean exchangeStillSource = s.bindings.stream().anyMatch(b -> b.source.equals(source));
            if (exchangeStillSource || (exchange = s.exchanges.get(source)) == null || !exchange.autoDelete) continue;
            this.exchangeDeleted(exchange.name);
        }
    }

    void accept(Visitor visitor) {
        LOGGER.debug("Topology listener '{}' visitor, retrieving state...", (Object)this.label);
        AtomicReference exchangeCopy = new AtomicReference();
        AtomicReference queueCopy = new AtomicReference();
        AtomicReference bindingCopy = new AtomicReference();
        this.submit(s -> {
            exchangeCopy.set(new ArrayList<ExchangeSpec>(s.exchanges.values()));
            queueCopy.set(new ArrayList<QueueSpec>(s.queues.values()));
            bindingCopy.set(new LinkedHashSet<BindingSpec>(s.bindings));
        });
        LOGGER.debug("Topology listener '{}' visitor, state retrieved, visiting topology...", (Object)this.label);
        visitor.visitExchanges((List)exchangeCopy.get());
        LOGGER.debug("Topology listener '{}' visitor, exchanges visited...", (Object)this.label);
        visitor.visitQueues((List)queueCopy.get());
        LOGGER.debug("Topology listener '{}' visitor, queues visited...", (Object)this.label);
        visitor.visitBindings((Collection)bindingCopy.get());
        LOGGER.debug("Topology listener '{}' visitor, topology visited...", (Object)this.label);
    }

    private State state() {
        return this.eventLoopClient.state();
    }

    Map<String, ExchangeSpec> exchanges() {
        return new LinkedHashMap<String, ExchangeSpec>(this.state().exchanges);
    }

    Map<String, QueueSpec> queues() {
        return new LinkedHashMap<String, QueueSpec>(this.state().queues);
    }

    int bindingCount() {
        return this.state().bindings.size();
    }

    int exchangeCount() {
        return this.state().exchanges.size();
    }

    int queueCount() {
        return this.state().queues.size();
    }

    static interface Visitor {
        public void visitExchanges(List<ExchangeSpec> var1);

        public void visitQueues(List<QueueSpec> var1);

        public void visitBindings(Collection<BindingSpec> var1);
    }

    static class ConsumerSpec {
        private final long id;
        private final String queue;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConsumerSpec that = (ConsumerSpec)o;
            return this.id == that.id;
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }

        private ConsumerSpec(long id, String queue) {
            this.id = id;
            this.queue = queue;
        }
    }

    static class BindingSpec {
        private final String source;
        private final String destination;
        private final String key;
        private final Map<String, Object> arguments = new LinkedHashMap<String, Object>();
        private final boolean toQueue;

        private BindingSpec(AmqpBindingManagement.BindingState state) {
            this.source = state.source();
            this.destination = state.destination();
            this.key = state.key() == null ? "" : state.key();
            this.toQueue = state.toQueue();
            state.arguments(this.arguments::put);
        }

        private boolean isInvolved(String entityName, boolean exchange) {
            return exchange ? this.isExchangeInvolved(entityName) : this.isQueueInvolved(entityName);
        }

        private boolean isExchangeInvolved(String exchange) {
            return this.source.equals(exchange) || !this.toQueue && this.destination.equals(exchange);
        }

        private boolean isQueueInvolved(String queue) {
            return this.toQueue && this.destination.equals(queue);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BindingSpec that = (BindingSpec)o;
            return this.toQueue == that.toQueue && Objects.equals(this.source, that.source) && Objects.equals(this.destination, that.destination) && Objects.equals(this.key, that.key) && Objects.equals(this.arguments, that.arguments);
        }

        public int hashCode() {
            return Objects.hash(this.source, this.destination, this.key, this.arguments, this.toQueue);
        }

        String source() {
            return this.source;
        }

        String destination() {
            return this.destination;
        }

        String key() {
            return this.key;
        }

        Map<String, Object> arguments() {
            return this.arguments;
        }

        boolean toQueue() {
            return this.toQueue;
        }
    }

    static class QueueSpec {
        private final String name;
        private final boolean exclusive;
        private final boolean autoDelete;
        private final Map<String, Object> arguments = new LinkedHashMap<String, Object>();

        private QueueSpec(AmqpQueueSpecification specification) {
            this.name = specification.name();
            this.exclusive = specification.exclusive();
            this.autoDelete = specification.autoDelete();
            specification.arguments(this.arguments::put);
        }

        String name() {
            return this.name;
        }

        boolean exclusive() {
            return this.exclusive;
        }

        boolean autoDelete() {
            return this.autoDelete;
        }

        Map<String, Object> arguments() {
            return this.arguments;
        }
    }

    static class ExchangeSpec {
        private final String name;
        private final String type;
        private final boolean autoDelete;
        private final Map<String, Object> arguments = new LinkedHashMap<String, Object>();

        private ExchangeSpec(AmqpExchangeSpecification specification) {
            this.name = specification.name();
            this.type = specification.type();
            this.autoDelete = specification.autoDelete();
            specification.arguments(this.arguments::put);
        }

        String name() {
            return this.name;
        }

        String type() {
            return this.type;
        }

        boolean autoDelete() {
            return this.autoDelete;
        }

        public Map<String, Object> arguments() {
            return this.arguments;
        }
    }

    private static class State {
        private final Map<String, ExchangeSpec> exchanges = new LinkedHashMap<String, ExchangeSpec>();
        private final Map<String, QueueSpec> queues = new LinkedHashMap<String, QueueSpec>();
        private final Set<BindingSpec> bindings = new LinkedHashSet<BindingSpec>();
        private final Map<Long, ConsumerSpec> consumers = new LinkedHashMap<Long, ConsumerSpec>();

        private State() {
        }
    }
}

