/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.amqp.impl;

import com.rabbitmq.client.amqp.impl.AmqpConnection;
import com.rabbitmq.client.amqp.impl.ExceptionUtils;
import com.rabbitmq.qpid.protonj2.client.Connection;
import com.rabbitmq.qpid.protonj2.client.Session;
import com.rabbitmq.qpid.protonj2.client.exceptions.ClientException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

interface SessionHandler
extends AutoCloseable {
    public Session session();

    public Session sessionNoCheck();

    @Override
    public void close();

    public static class SingleSessionSessionHandler
    implements SessionHandler {
        private static final Logger LOGGER = LoggerFactory.getLogger(SingleSessionSessionHandler.class);
        private final Supplier<Connection> connection;
        private final AtomicReference<Session> session = new AtomicReference();

        public SingleSessionSessionHandler(AmqpConnection connection) {
            this.connection = connection::nativeConnection;
        }

        @Override
        public Session session() {
            this.closeCurrentSession();
            try {
                Session session = this.connection.get().openSession();
                this.session.set(ExceptionUtils.wrapGet(session.openFuture()));
                return this.session.get();
            }
            catch (ClientException e) {
                this.session.set(null);
                throw ExceptionUtils.convert(e);
            }
        }

        @Override
        public Session sessionNoCheck() {
            return this.session();
        }

        @Override
        public void close() {
            this.closeCurrentSession();
        }

        private void closeCurrentSession() {
            Session previousSession = this.session.getAndSet(null);
            if (previousSession != null) {
                try {
                    previousSession.close();
                }
                catch (RuntimeException e) {
                    LOGGER.debug("Error while closing session: {}", (Object)e.getMessage());
                }
            }
        }
    }

    public static class ConnectionNativeSessionSessionHandler
    implements SessionHandler {
        private final AmqpConnection connection;

        ConnectionNativeSessionSessionHandler(AmqpConnection connection) {
            this.connection = connection;
        }

        @Override
        public Session session() {
            return this.connection.nativeSession();
        }

        @Override
        public Session sessionNoCheck() {
            return this.connection.nativeSession(false);
        }

        @Override
        public void close() {
        }
    }
}

