/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.amqp.impl;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;

final class UriUtils {
    static final BitSet SUB_DELIMS;
    static final BitSet UNRESERVED;
    static final BitSet PCHAR;
    static final BitSet QUERY_PARAM;
    private static final int RADIX = 16;

    private UriUtils() {
    }

    static String encodeNonUnreserved(String value) {
        return UriUtils.encode(value, UNRESERVED);
    }

    static String encodePathSegment(String segment) {
        return UriUtils.encode(segment, PCHAR);
    }

    static String encodeParameter(String value) {
        return UriUtils.encode(value, QUERY_PARAM);
    }

    private static String encode(String value, BitSet safeCharacters) {
        if (value == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        CharBuffer cb = CharBuffer.wrap(value);
        ByteBuffer bb = StandardCharsets.UTF_8.encode(cb);
        while (bb.hasRemaining()) {
            int b = bb.get() & 0xFF;
            if (safeCharacters.get(b)) {
                buf.append((char)b);
                continue;
            }
            buf.append("%");
            char hex1 = Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16));
            char hex2 = Character.toUpperCase(Character.forDigit(b & 0xF, 16));
            buf.append(hex1);
            buf.append(hex2);
        }
        return buf.toString();
    }

    static String decode(CharSequence content) {
        return UriUtils.decode(content, false);
    }

    private static String decode(CharSequence content, boolean plusAsBlank) {
        if (content == null) {
            return null;
        }
        ByteBuffer bb = ByteBuffer.allocate(content.length());
        CharBuffer cb = CharBuffer.wrap(content);
        while (cb.hasRemaining()) {
            char c = cb.get();
            if (c == '%' && cb.remaining() >= 2) {
                char uc = cb.get();
                char lc = cb.get();
                int u = Character.digit(uc, 16);
                int l = Character.digit(lc, 16);
                if (u != -1 && l != -1) {
                    bb.put((byte)((u << 4) + l));
                    continue;
                }
                bb.put((byte)37);
                bb.put((byte)uc);
                bb.put((byte)lc);
                continue;
            }
            if (plusAsBlank && c == '+') {
                bb.put((byte)32);
                continue;
            }
            bb.put((byte)c);
        }
        bb.flip();
        return StandardCharsets.UTF_8.decode(bb).toString();
    }

    static {
        int i;
        SUB_DELIMS = new BitSet(256);
        UNRESERVED = new BitSet(256);
        PCHAR = new BitSet(256);
        QUERY_PARAM = new BitSet(256);
        SUB_DELIMS.set(33);
        SUB_DELIMS.set(36);
        SUB_DELIMS.set(38);
        SUB_DELIMS.set(39);
        SUB_DELIMS.set(40);
        SUB_DELIMS.set(41);
        SUB_DELIMS.set(42);
        SUB_DELIMS.set(43);
        SUB_DELIMS.set(44);
        SUB_DELIMS.set(59);
        SUB_DELIMS.set(61);
        for (i = 97; i <= 122; ++i) {
            UNRESERVED.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            UNRESERVED.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            UNRESERVED.set(i);
        }
        UNRESERVED.set(45);
        UNRESERVED.set(46);
        UNRESERVED.set(95);
        UNRESERVED.set(126);
        PCHAR.or(UNRESERVED);
        PCHAR.or(SUB_DELIMS);
        PCHAR.set(58);
        PCHAR.set(64);
        QUERY_PARAM.or(PCHAR);
        QUERY_PARAM.set(47);
        QUERY_PARAM.set(63);
        QUERY_PARAM.clear(61);
        QUERY_PARAM.clear(38);
    }
}

