/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.amqp.impl;

import com.rabbitmq.client.amqp.Address;
import com.rabbitmq.client.amqp.AmqpException;
import com.rabbitmq.client.amqp.Consumer;
import com.rabbitmq.client.amqp.Message;
import com.rabbitmq.client.amqp.ObservationCollector;
import com.rabbitmq.client.amqp.impl.DefaultAddressBuilder;
import com.rabbitmq.client.amqp.impl.UriUtils;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.Arrays;
import java.util.Base64;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);
    static final boolean VIRTUAL_THREADS_ON = Boolean.parseBoolean(System.getProperty("rabbitmq.stream.threads.virtual.enabled", "false"));
    static final int AVAILABLE_PROCESSORS = Runtime.getRuntime().availableProcessors();
    static final Supplier<String> NAME_SUPPLIER = new NameSupplier("client.gen-");
    private static final ThreadFactory THREAD_FACTORY;
    private static final Function<String, ExecutorService> EXECUTOR_SERVICE_FACTORY;
    static final ObservationCollector NO_OP_OBSERVATION_COLLECTOR;
    private static final Pattern MAX_AGE_PATTERN;

    private Utils() {
    }

    static ExecutorService executorService(String prefixFormat, Object ... args) {
        return EXECUTOR_SERVICE_FACTORY.apply(String.format(prefixFormat, args));
    }

    private static boolean isJava21OrMore() {
        return Runtime.version().compareTo(Runtime.Version.parse("21")) >= 0;
    }

    static void checkMessageAnnotations(Map<String, Object> annotations) {
        annotations.forEach((k, v) -> Utils.validateMessageAnnotationKey(k));
    }

    static void validateMessageAnnotationKey(String key) {
        if (!key.startsWith("x-")) {
            throw new IllegalArgumentException("Message annotation keys must start with 'x-': " + key);
        }
    }

    static ThreadFactory threadFactory(String prefix) {
        if (prefix == null) {
            return Executors.defaultThreadFactory();
        }
        return new NamedThreadFactory(prefix);
    }

    static ThreadFactory defaultThreadFactory() {
        return THREAD_FACTORY;
    }

    static void throwIfInterrupted() throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
    }

    static DefaultAddressBuilder<?> addressBuilder() {
        return new DefaultAddressBuilder<Object>(null){};
    }

    private static String currentVersion(String currentVersion) {
        if (currentVersion.contains("+")) {
            currentVersion = currentVersion.substring(0, currentVersion.indexOf("+"));
        }
        if (currentVersion.contains("~")) {
            currentVersion = currentVersion.substring(0, currentVersion.indexOf("~"));
        }
        if (currentVersion.contains("-")) {
            currentVersion = currentVersion.substring(0, currentVersion.indexOf("-"));
        }
        return currentVersion;
    }

    static int versionCompare(String str1, String str2) {
        int i;
        String[] vals1 = str1.split("\\.");
        String[] vals2 = str2.split("\\.");
        for (i = 0; i < vals1.length && i < vals2.length && vals1[i].equals(vals2[i]); ++i) {
        }
        if (i < vals1.length && i < vals2.length) {
            Integer val1 = Integer.valueOf(vals1[i]);
            Integer val2 = Integer.valueOf(vals2[i]);
            return val1.compareTo(val2);
        }
        return Integer.signum(vals1.length - vals2.length);
    }

    static boolean is4_0_OrMore(String brokerVersion) {
        return Utils.atLeastVersion(brokerVersion, "4.0.0");
    }

    static boolean is4_1_OrMore(String brokerVersion) {
        return Utils.atLeastVersion(brokerVersion, "4.1.0");
    }

    static boolean is4_2_OrMore(String brokerVersion) {
        return Utils.atLeastVersion(brokerVersion, "4.2.0");
    }

    private static boolean atLeastVersion(String brokerVersion, String expectedVersion) {
        try {
            return Utils.versionCompare(Utils.currentVersion(brokerVersion), expectedVersion) >= 0;
        }
        catch (Exception e) {
            LOGGER.debug("Unable to parse broker version {}", (Object)brokerVersion, (Object)e);
            return true;
        }
    }

    static boolean supportFilterExpressions(String brokerVersion) {
        return Utils.is4_1_OrMore(brokerVersion);
    }

    static boolean supportSetToken(String brokerVersion) {
        return Utils.is4_1_OrMore(brokerVersion);
    }

    static boolean supportSqlFilterExpressions(String brokerVersion) {
        return Utils.is4_2_OrMore(brokerVersion);
    }

    static boolean supportDirectReplyTo(String brokerVersion) {
        return Utils.is4_2_OrMore(brokerVersion);
    }

    static void maybeClose(AutoCloseable closeable, Consumer<Exception> exceptionCallback) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                exceptionCallback.accept(e);
            }
        }
    }

    static boolean validateMaxAge(String input) {
        return MAX_AGE_PATTERN.matcher(input).find();
    }

    static Runnable namedRunnable(Runnable task, String format, Object ... args) {
        return new NamedRunnable(String.format(format, args), task);
    }

    static String extractQueueName(String address) {
        if (address == null || !address.startsWith("/queues/")) {
            return null;
        }
        return UriUtils.decode(address.replaceFirst("/queues/", ""));
    }

    static {
        LOGGER.debug("Virtual threads enabled: {}", (Object)VIRTUAL_THREADS_ON);
        LOGGER.debug("Java 21 or more: {}", (Object)Utils.isJava21OrMore());
        if (Utils.isJava21OrMore()) {
            LOGGER.debug("Using virtual threads");
            Class builderClass = Arrays.stream(Thread.class.getDeclaredClasses()).filter(c -> "Builder".equals(c.getSimpleName())).findFirst().get();
            try {
                Object builder = Thread.class.getDeclaredMethod("ofVirtual", new Class[0]).invoke(null, new Object[0]);
                THREAD_FACTORY = (ThreadFactory)builderClass.getDeclaredMethod("factory", new Class[0]).invoke(builder, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            EXECUTOR_SERVICE_FACTORY = prefix -> {
                try {
                    Object builder = Thread.class.getDeclaredMethod("ofVirtual", new Class[0]).invoke(null, new Object[0]);
                    if (prefix != null) {
                        builder = builderClass.getDeclaredMethod("name", String.class, Long.TYPE).invoke(builder, prefix, 0L);
                    }
                    ThreadFactory factory = (ThreadFactory)builderClass.getDeclaredMethod("factory", new Class[0]).invoke(builder, new Object[0]);
                    return (ExecutorService)Executors.class.getDeclaredMethod("newThreadPerTaskExecutor", ThreadFactory.class).invoke(null, factory);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            };
        } else {
            THREAD_FACTORY = Executors.defaultThreadFactory();
            EXECUTOR_SERVICE_FACTORY = prefix -> Executors.newCachedThreadPool(Utils.threadFactory(prefix));
        }
        NO_OP_OBSERVATION_COLLECTOR = new NoOpObservationCollector();
        MAX_AGE_PATTERN = Pattern.compile("^[0-9]+[YMDhms]$");
    }

    @FunctionalInterface
    static interface RunnableWithException {
        public void run() throws Exception;
    }

    private static class NamedRunnable
    implements Runnable {
        private final String name;
        private final Runnable delegate;

        private NamedRunnable(String name, Runnable delegate) {
            this.name = name;
            this.delegate = delegate;
        }

        @Override
        public void run() {
            this.delegate.run();
        }

        public String toString() {
            return this.name;
        }
    }

    static class StopWatch {
        private final long start = System.nanoTime();

        StopWatch() {
        }

        Duration stop() {
            return Duration.ofNanos(System.nanoTime() - this.start);
        }
    }

    private static final class NoOpObservationCollector
    implements ObservationCollector {
        private NoOpObservationCollector() {
        }

        @Override
        public <T> T publish(String exchange, String routingKey, Message message, ObservationCollector.ConnectionInfo connectionInfo, Function<Message, T> publishCall) {
            return publishCall.apply(message);
        }

        @Override
        public Consumer.MessageHandler subscribe(String queue, Consumer.MessageHandler handler) {
            return handler;
        }
    }

    static final class ObservationConnectionInfo
    implements ObservationCollector.ConnectionInfo {
        private final String address;
        private final int port;

        ObservationConnectionInfo(Address address) {
            this.address = address == null ? "" : address.host();
            this.port = address == null ? 0 : address.port();
        }

        @Override
        public String peerAddress() {
            return this.address;
        }

        @Override
        public int peerPort() {
            return this.port;
        }
    }

    private static class NameSupplier
    implements Supplier<String> {
        private final String prefix;

        private NameSupplier(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public String get() {
            String uuid = UUID.randomUUID().toString();
            MessageDigest md = null;
            try {
                md = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new AmqpException(e);
            }
            byte[] digest = md.digest(uuid.getBytes(StandardCharsets.UTF_8));
            return this.prefix + Base64.getEncoder().encodeToString(digest).replace('+', '-').replace('/', '_').replace("=", "");
        }
    }

    private static class NamedThreadFactory
    implements ThreadFactory {
        private final ThreadFactory backingThreadFactory;
        private final String prefix;
        private final AtomicLong count = new AtomicLong(0L);

        private NamedThreadFactory(String prefix) {
            this(Executors.defaultThreadFactory(), prefix);
        }

        private NamedThreadFactory(ThreadFactory backingThreadFactory, String prefix) {
            this.backingThreadFactory = backingThreadFactory;
            this.prefix = prefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = this.backingThreadFactory.newThread(r);
            thread.setName(this.prefix + this.count.getAndIncrement());
            return thread;
        }
    }
}

