/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.amqp.observation.micrometer;

import com.rabbitmq.client.amqp.observation.micrometer.AmqpObservationDocumentation;
import com.rabbitmq.client.amqp.observation.micrometer.DeliverContext;
import com.rabbitmq.client.amqp.observation.micrometer.DeliverObservationConvention;
import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.common.util.StringUtils;

public class DefaultProcessObservationConvention
implements DeliverObservationConvention {
    private static final String OPERATION = "process";
    private static final String OPERATION_SUFFIX = " process";

    public String getName() {
        return "rabbitmq.amqp.process";
    }

    public String getContextualName(DeliverContext context) {
        return DefaultProcessObservationConvention.source(context.queue()) + OPERATION_SUFFIX;
    }

    private static String source(String destination) {
        return StringUtils.isNotBlank((String)destination) ? destination : "(anonymous)";
    }

    public KeyValues getLowCardinalityKeyValues(DeliverContext context) {
        return KeyValues.of((KeyValue[])new KeyValue[]{AmqpObservationDocumentation.LowCardinalityTags.MESSAGING_OPERATION.withValue(OPERATION), AmqpObservationDocumentation.LowCardinalityTags.MESSAGING_SYSTEM.withValue("rabbitmq"), AmqpObservationDocumentation.LowCardinalityTags.NET_PROTOCOL_NAME.withValue("amqp"), AmqpObservationDocumentation.LowCardinalityTags.NET_PROTOCOL_VERSION.withValue("1.0")});
    }

    public KeyValues getHighCardinalityKeyValues(DeliverContext context) {
        String routingKey;
        KeyValues keyValues = KeyValues.of((KeyValue[])new KeyValue[]{AmqpObservationDocumentation.HighCardinalityTags.MESSAGING_SOURCE_NAME.withValue(DefaultProcessObservationConvention.source(context.queue())), AmqpObservationDocumentation.HighCardinalityTags.MESSAGING_MESSAGE_PAYLOAD_SIZE_BYTES.withValue(String.valueOf(context.payloadSizeBytes()))});
        String exchange = context.exchange();
        if (exchange != null) {
            keyValues = keyValues.and(new KeyValue[]{AmqpObservationDocumentation.HighCardinalityTags.MESSAGING_DESTINATION_NAME.withValue(exchange)});
        }
        if ((routingKey = context.routingKey()) != null) {
            keyValues = keyValues.and(new KeyValue[]{AmqpObservationDocumentation.HighCardinalityTags.MESSAGING_ROUTING_KEY.withValue(routingKey)});
        }
        if (context.messageId() != null) {
            keyValues = keyValues.and(new KeyValue[]{AmqpObservationDocumentation.HighCardinalityTags.MESSAGING_MESSAGE_ID.withValue(context.messageId())});
        }
        if (context.correlationId() != null) {
            keyValues = keyValues.and(new KeyValue[]{AmqpObservationDocumentation.HighCardinalityTags.MESSAGING_MESSAGE_CONVERSATION_ID.withValue(context.correlationId())});
        }
        return keyValues;
    }
}

