/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.amqp.observation.micrometer;

import com.rabbitmq.client.amqp.Message;
import com.rabbitmq.client.amqp.observation.micrometer.Utils;
import io.micrometer.observation.transport.ReceiverContext;

public class DeliverContext
extends ReceiverContext<Message> {
    private final String exchange;
    private final String routingKey;
    private final String queue;
    private final int payloadSizeBytes;
    private final String messageId;
    private final String correlationId;

    DeliverContext(String exchange, String routingKey, String queue, Message message) {
        super((carrier, key) -> {
            Object result = carrier.annotation(Utils.annotationKey(key));
            if (result == null) {
                result = carrier.property(key);
            }
            return result == null ? null : result.toString();
        });
        if (exchange == null && routingKey == null) {
            String to = message.to();
            String[] exRk = Utils.exchangeRoutingKeyFromTo(to);
            this.exchange = exRk[0];
            this.routingKey = exRk[1];
        } else {
            this.exchange = exchange;
            this.routingKey = routingKey;
        }
        this.queue = queue;
        this.payloadSizeBytes = message.body() == null ? 0 : message.body().length;
        this.messageId = message.messageId() == null ? null : message.messageId().toString();
        this.correlationId = message.correlationId() == null ? null : message.correlationId().toString();
        this.setCarrier(message);
    }

    public String exchange() {
        return this.exchange;
    }

    public String routingKey() {
        return this.routingKey;
    }

    public String queue() {
        return this.queue;
    }

    public int payloadSizeBytes() {
        return this.payloadSizeBytes;
    }

    public String messageId() {
        return this.messageId;
    }

    public String correlationId() {
        return this.correlationId;
    }
}

