/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.amqp.observation.micrometer;

import com.rabbitmq.client.amqp.Message;
import com.rabbitmq.client.amqp.ObservationCollector;
import com.rabbitmq.client.amqp.observation.micrometer.Utils;
import io.micrometer.observation.transport.SenderContext;

public class PublishContext
extends SenderContext<Message> {
    private final String exchange;
    private final String routingKey;
    private final int payloadSizeBytes;
    private final String messageId;
    private final String correlationId;
    private final String peerAddress;
    private final int peerPort;

    PublishContext(String exchange, String routingKey, Message message, ObservationCollector.ConnectionInfo connectionInfo) {
        super((carrier, key, value) -> carrier.annotation(Utils.annotationKey(key), value));
        if (exchange == null && routingKey == null) {
            String to = message.to();
            String[] exRk = Utils.exchangeRoutingKeyFromTo(to);
            this.exchange = exRk[0];
            this.routingKey = exRk[1];
        } else {
            this.exchange = exchange;
            this.routingKey = routingKey;
        }
        this.payloadSizeBytes = message.body() == null ? 0 : message.body().length;
        this.messageId = message.messageId() == null ? null : message.messageId().toString();
        this.correlationId = message.correlationId() == null ? null : message.correlationId().toString();
        this.peerAddress = connectionInfo == null ? "" : connectionInfo.peerAddress();
        this.peerPort = connectionInfo == null ? 0 : connectionInfo.peerPort();
        this.setCarrier(message);
    }

    public String exchange() {
        return this.exchange;
    }

    public String routingKey() {
        return this.routingKey;
    }

    public int payloadSizeBytes() {
        return this.payloadSizeBytes;
    }

    public String messageId() {
        return this.messageId;
    }

    public String correlationId() {
        return this.correlationId;
    }

    public String peerAddress() {
        return this.peerAddress;
    }

    public int peerPort() {
        return this.peerPort;
    }
}

