/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.client.util;

import com.rabbitmq.qpid.protonj2.client.ReconnectLocation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class ReconnectLocationPool {
    private final LinkedList<ReconnectLocation> entries = new LinkedList();

    public ReconnectLocationPool() {
    }

    public ReconnectLocationPool(List<ReconnectLocation> backups) {
        if (backups != null) {
            backups.forEach(entry -> this.add((ReconnectLocation)entry));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        LinkedList<ReconnectLocation> linkedList = this.entries;
        synchronized (linkedList) {
            return this.entries.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        LinkedList<ReconnectLocation> linkedList = this.entries;
        synchronized (linkedList) {
            return this.entries.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReconnectLocation getNext() {
        ReconnectLocation next = null;
        LinkedList<ReconnectLocation> linkedList = this.entries;
        synchronized (linkedList) {
            if (!this.entries.isEmpty()) {
                next = this.entries.removeFirst();
                this.entries.addLast(next);
            }
        }
        return next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shuffle() {
        LinkedList<ReconnectLocation> linkedList = this.entries;
        synchronized (linkedList) {
            Collections.shuffle(this.entries);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(ReconnectLocation entry) {
        if (entry != null) {
            LinkedList<ReconnectLocation> linkedList = this.entries;
            synchronized (linkedList) {
                if (!this.contains(entry)) {
                    this.entries.add(entry);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(List<ReconnectLocation> additions) {
        if (additions != null && !additions.isEmpty()) {
            LinkedList<ReconnectLocation> linkedList = this.entries;
            synchronized (linkedList) {
                additions.forEach(entry -> this.add((ReconnectLocation)entry));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFirst(ReconnectLocation entry) {
        if (entry != null) {
            LinkedList<ReconnectLocation> linkedList = this.entries;
            synchronized (linkedList) {
                if (!this.contains(entry)) {
                    this.entries.addFirst(entry);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(ReconnectLocation entry) {
        if (entry != null) {
            LinkedList<ReconnectLocation> linkedList = this.entries;
            synchronized (linkedList) {
                for (ReconnectLocation candidate : this.entries) {
                    if (!this.compareEntries(entry, candidate)) continue;
                    return this.entries.remove(candidate);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        LinkedList<ReconnectLocation> linkedList = this.entries;
        synchronized (linkedList) {
            this.entries.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceAll(List<ReconnectLocation> replacements) {
        LinkedList<ReconnectLocation> linkedList = this.entries;
        synchronized (linkedList) {
            this.entries.clear();
            this.addAll(replacements);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ReconnectLocation> getList() {
        LinkedList<ReconnectLocation> linkedList = this.entries;
        synchronized (linkedList) {
            return new ArrayList<ReconnectLocation>(this.entries);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        LinkedList<ReconnectLocation> linkedList = this.entries;
        synchronized (linkedList) {
            return "ReconnectLocationPool { " + String.valueOf(this.entries) + " }";
        }
    }

    private boolean contains(ReconnectLocation newEntry) {
        boolean result = false;
        for (ReconnectLocation entry : this.entries) {
            if (!this.compareEntries(newEntry, entry)) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean compareEntries(ReconnectLocation first, ReconnectLocation second) {
        String secondHost;
        String firstHost;
        boolean result = false;
        if (first == null || second == null) {
            return result;
        }
        if (first.getPort() == second.getPort() && (firstHost = first.getHost()).equalsIgnoreCase(secondHost = second.getHost())) {
            result = true;
        }
        return result;
    }
}

