/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.codec.decoders;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.codec.DecodeEOFException;
import com.rabbitmq.qpid.protonj2.codec.DecodeException;
import com.rabbitmq.qpid.protonj2.codec.Decoder;
import com.rabbitmq.qpid.protonj2.codec.DecoderState;
import com.rabbitmq.qpid.protonj2.codec.DescribedTypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.EncodingCodes;
import com.rabbitmq.qpid.protonj2.codec.TypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.PrimitiveTypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.ProtonDecoderState;
import com.rabbitmq.qpid.protonj2.codec.decoders.UnknownDescribedTypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.Array32TypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.Array8TypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.Binary32TypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.Binary8TypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.BooleanFalseTypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.BooleanTrueTypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.BooleanTypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.ByteTypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.CharacterTypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.Decimal128TypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.Decimal32TypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.Decimal64TypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.DoubleTypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.FloatTypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.Integer32TypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.Integer8TypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.List0TypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.List32TypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.List8TypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.Long8TypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.LongTypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.Map32TypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.Map8TypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.NullTypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.ShortTypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.String32TypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.String8TypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.Symbol32TypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.Symbol8TypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.TimestampTypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.UUIDTypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.UnsignedByteTypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.UnsignedInteger0TypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.UnsignedInteger32TypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.UnsignedInteger8TypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.UnsignedLong0TypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.UnsignedLong64TypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.UnsignedLong8TypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.UnsignedShortTypeDecoder;
import com.rabbitmq.qpid.protonj2.types.Binary;
import com.rabbitmq.qpid.protonj2.types.Decimal128;
import com.rabbitmq.qpid.protonj2.types.Decimal32;
import com.rabbitmq.qpid.protonj2.types.Decimal64;
import com.rabbitmq.qpid.protonj2.types.DeliveryTag;
import com.rabbitmq.qpid.protonj2.types.Symbol;
import com.rabbitmq.qpid.protonj2.types.UnsignedByte;
import com.rabbitmq.qpid.protonj2.types.UnsignedInteger;
import com.rabbitmq.qpid.protonj2.types.UnsignedLong;
import com.rabbitmq.qpid.protonj2.types.UnsignedShort;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class ProtonDecoder
implements Decoder {
    private static final PrimitiveTypeDecoder<?>[] primitiveDecoders = new PrimitiveTypeDecoder[256];
    private Map<Object, DescribedTypeDecoder<?>> describedTypeDecoders = new HashMap();
    private final DescribedTypeDecoder<?>[] amqpTypeDecoders = new DescribedTypeDecoder[256];
    private ProtonDecoderState singleThreadedState;
    private static final Symbol8TypeDecoder symbol8Decoder;
    private static final Symbol32TypeDecoder symbol32Decoder;
    private static final Binary8TypeDecoder binary8Decoder;
    private static final Binary32TypeDecoder binary32Decoder;
    private static final List8TypeDecoder list8Decoder;
    private static final List32TypeDecoder list32Decoder;
    private static final Map8TypeDecoder map8Decoder;
    private static final Map32TypeDecoder map32Decoder;
    private static final String8TypeDecoder string8Decoder;
    private static final String32TypeDecoder string32Decoder;

    @Override
    public ProtonDecoderState newDecoderState() {
        return new ProtonDecoderState(this);
    }

    @Override
    public ProtonDecoderState getCachedDecoderState() {
        ProtonDecoderState state = this.singleThreadedState;
        if (state == null) {
            this.singleThreadedState = state = this.newDecoderState();
        }
        return state.reset();
    }

    @Override
    public Object readObject(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        TypeDecoder<?> decoder = this.readNextTypeDecoder(buffer, state);
        if (decoder == null) {
            throw new DecodeException("Unknown type constructor in encoded bytes");
        }
        return decoder.readValue(buffer, state);
    }

    @Override
    public <T> T readObject(ProtonBuffer buffer, DecoderState state, Class<T> clazz) throws DecodeException {
        Object result = this.readObject(buffer, state);
        if (result == null) {
            return null;
        }
        if (clazz.isAssignableFrom(result.getClass())) {
            return (T)result;
        }
        throw this.signalUnexpectedType(result, clazz);
    }

    @Override
    public <T> T[] readMultiple(ProtonBuffer buffer, DecoderState state, Class<T> clazz) throws DecodeException {
        Object val = this.readObject(buffer, state);
        if (val == null) {
            return null;
        }
        if (val.getClass().isArray()) {
            if (clazz.isAssignableFrom(val.getClass().getComponentType())) {
                return (Object[])val;
            }
            throw this.signalUnexpectedType(val, Array.newInstance(clazz, 0).getClass());
        }
        if (clazz.isAssignableFrom(val.getClass())) {
            Object[] array = (Object[])Array.newInstance(clazz, 1);
            array[0] = val;
            return array;
        }
        throw this.signalUnexpectedType(val, Array.newInstance(clazz, 0).getClass());
    }

    @Override
    public TypeDecoder<?> readNextTypeDecoder(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        int encodingCode = ProtonDecoder.readEncodingCode(buffer) & 0xFF;
        if (encodingCode == 0) {
            int readMark = buffer.getReadOffset();
            try {
                long result = this.readUnsignedLong(buffer, state, this.amqpTypeDecoders.length);
                if (result > 0L && result < (long)this.amqpTypeDecoders.length && this.amqpTypeDecoders[(int)result] != null) {
                    return this.amqpTypeDecoders[(int)result];
                }
                buffer.setReadOffset(readMark);
                return this.slowReadNextTypeDecoder(buffer, state);
            }
            catch (Exception e) {
                buffer.setReadOffset(readMark);
                return this.slowReadNextTypeDecoder(buffer, state);
            }
        }
        return primitiveDecoders[encodingCode];
    }

    private TypeDecoder<?> slowReadNextTypeDecoder(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        Object descriptor;
        int readMark = buffer.getReadOffset();
        try {
            descriptor = this.readUnsignedLong(buffer, state);
        }
        catch (Exception e) {
            buffer.setReadOffset(readMark);
            descriptor = this.readObject(buffer, state);
        }
        TypeDecoder<?> typeDecoder = (TypeDecoder<?>)this.describedTypeDecoders.get(descriptor);
        if (typeDecoder == null) {
            typeDecoder = this.handleUnknownDescribedType(descriptor);
        }
        return typeDecoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypeDecoder<?> peekNextTypeDecoder(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        int readMark = buffer.getReadOffset();
        try {
            TypeDecoder<?> typeDecoder = this.readNextTypeDecoder(buffer, state);
            return typeDecoder;
        }
        finally {
            buffer.setReadOffset(readMark);
        }
    }

    @Override
    public <V> ProtonDecoder registerDescribedTypeDecoder(DescribedTypeDecoder<V> decoder) {
        DescribedTypeDecoder<V> describedTypeDecoder = decoder;
        if (decoder.getDescriptorCode().compareTo(this.amqpTypeDecoders.length) < 0) {
            this.amqpTypeDecoders[decoder.getDescriptorCode().intValue()] = decoder;
        }
        this.describedTypeDecoders.put(describedTypeDecoder.getDescriptorCode(), describedTypeDecoder);
        this.describedTypeDecoders.put(describedTypeDecoder.getDescriptorSymbol(), describedTypeDecoder);
        decoder.decoderRegistered(this);
        return this;
    }

    @Override
    public Boolean readBoolean(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        byte encodingCode = ProtonDecoder.readEncodingCode(buffer);
        switch (encodingCode) {
            case 65: {
                return Boolean.TRUE;
            }
            case 66: {
                return Boolean.FALSE;
            }
            case 86: {
                return buffer.readByte() == 0 ? Boolean.FALSE : Boolean.TRUE;
            }
            case 64: {
                return null;
            }
        }
        throw new DecodeException("Expected Boolean type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public boolean readBoolean(ProtonBuffer buffer, DecoderState state, boolean defaultValue) throws DecodeException {
        byte encodingCode = ProtonDecoder.readEncodingCode(buffer);
        switch (encodingCode) {
            case 65: {
                return true;
            }
            case 66: {
                return false;
            }
            case 86: {
                return buffer.readByte() != 0;
            }
            case 64: {
                return defaultValue;
            }
        }
        throw new DecodeException("Expected Boolean type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public Byte readByte(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        byte encodingCode = ProtonDecoder.readEncodingCode(buffer);
        switch (encodingCode) {
            case 81: {
                return buffer.readByte();
            }
            case 64: {
                return null;
            }
        }
        throw new DecodeException("Expected Byte type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public byte readByte(ProtonBuffer buffer, DecoderState state, byte defaultValue) throws DecodeException {
        byte encodingCode = ProtonDecoder.readEncodingCode(buffer);
        switch (encodingCode) {
            case 81: {
                return buffer.readByte();
            }
            case 64: {
                return defaultValue;
            }
        }
        throw new DecodeException("Expected Byte type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public UnsignedByte readUnsignedByte(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        byte encodingCode = ProtonDecoder.readEncodingCode(buffer);
        switch (encodingCode) {
            case 80: {
                return UnsignedByte.valueOf(buffer.readByte());
            }
            case 64: {
                return null;
            }
        }
        throw new DecodeException("Expected Unsigned Byte type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public byte readUnsignedByte(ProtonBuffer buffer, DecoderState state, byte defaultValue) throws DecodeException {
        byte encodingCode = ProtonDecoder.readEncodingCode(buffer);
        switch (encodingCode) {
            case 80: {
                return buffer.readByte();
            }
            case 64: {
                return defaultValue;
            }
        }
        throw new DecodeException("Expected Unsigned Byte type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public Character readCharacter(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        byte encodingCode = ProtonDecoder.readEncodingCode(buffer);
        switch (encodingCode) {
            case 115: {
                return Character.valueOf((char)(buffer.readInt() & 0xFFFF));
            }
            case 64: {
                return null;
            }
        }
        throw new DecodeException("Expected Character type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public char readCharacter(ProtonBuffer buffer, DecoderState state, char defaultValue) throws DecodeException {
        byte encodingCode = ProtonDecoder.readEncodingCode(buffer);
        switch (encodingCode) {
            case 115: {
                return (char)(buffer.readInt() & 0xFFFF);
            }
            case 64: {
                return defaultValue;
            }
        }
        throw new DecodeException("Expected Character type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public Decimal32 readDecimal32(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        byte encodingCode = ProtonDecoder.readEncodingCode(buffer);
        switch (encodingCode) {
            case 116: {
                return new Decimal32(buffer.readInt());
            }
            case 64: {
                return null;
            }
        }
        throw new DecodeException("Expected Decimal32 type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public Decimal64 readDecimal64(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        byte encodingCode = ProtonDecoder.readEncodingCode(buffer);
        switch (encodingCode) {
            case -124: {
                return new Decimal64(buffer.readLong());
            }
            case 64: {
                return null;
            }
        }
        throw new DecodeException("Expected Decimal64 type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public Decimal128 readDecimal128(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        byte encodingCode = ProtonDecoder.readEncodingCode(buffer);
        switch (encodingCode) {
            case -108: {
                return new Decimal128(buffer.readLong(), buffer.readLong());
            }
            case 64: {
                return null;
            }
        }
        throw new DecodeException("Expected Decimal128 type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public Short readShort(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        byte encodingCode = ProtonDecoder.readEncodingCode(buffer);
        switch (encodingCode) {
            case 97: {
                return buffer.readShort();
            }
            case 64: {
                return null;
            }
        }
        throw new DecodeException("Expected Short type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public short readShort(ProtonBuffer buffer, DecoderState state, short defaultValue) throws DecodeException {
        byte encodingCode = ProtonDecoder.readEncodingCode(buffer);
        switch (encodingCode) {
            case 97: {
                return buffer.readShort();
            }
            case 64: {
                return defaultValue;
            }
        }
        throw new DecodeException("Expected Short type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public UnsignedShort readUnsignedShort(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        byte encodingCode = ProtonDecoder.readEncodingCode(buffer);
        switch (encodingCode) {
            case 96: {
                return UnsignedShort.valueOf(buffer.readShort());
            }
            case 64: {
                return null;
            }
        }
        throw new DecodeException("Expected Unsigned Short type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public short readUnsignedShort(ProtonBuffer buffer, DecoderState state, short defaultValue) throws DecodeException {
        byte encodingCode = ProtonDecoder.readEncodingCode(buffer);
        switch (encodingCode) {
            case 96: {
                return buffer.readShort();
            }
            case 64: {
                return defaultValue;
            }
        }
        throw new DecodeException("Expected Unsigned Short type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public int readUnsignedShort(ProtonBuffer buffer, DecoderState state, int defaultValue) throws DecodeException {
        byte encodingCode = ProtonDecoder.readEncodingCode(buffer);
        switch (encodingCode) {
            case 96: {
                return buffer.readShort() & 0xFFFF;
            }
            case 64: {
                return defaultValue;
            }
        }
        throw new DecodeException("Expected Unsigned Short type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public Integer readInteger(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        byte encodingCode = ProtonDecoder.readEncodingCode(buffer);
        switch (encodingCode) {
            case 84: {
                return buffer.readByte();
            }
            case 113: {
                return buffer.readInt();
            }
            case 64: {
                return null;
            }
        }
        throw new DecodeException("Expected Integer type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public int readInteger(ProtonBuffer buffer, DecoderState state, int defaultValue) throws DecodeException {
        byte encodingCode = ProtonDecoder.readEncodingCode(buffer);
        switch (encodingCode) {
            case 84: {
                return buffer.readByte();
            }
            case 113: {
                return buffer.readInt();
            }
            case 64: {
                return defaultValue;
            }
        }
        throw new DecodeException("Expected Integer type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public UnsignedInteger readUnsignedInteger(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        byte encodingCode = ProtonDecoder.readEncodingCode(buffer);
        switch (encodingCode) {
            case 67: {
                return UnsignedInteger.ZERO;
            }
            case 82: {
                return UnsignedInteger.valueOf(buffer.readByte() & 0xFF);
            }
            case 112: {
                return UnsignedInteger.valueOf(buffer.readInt());
            }
            case 64: {
                return null;
            }
        }
        throw new DecodeException("Expected Unsigned Integer type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public int readUnsignedInteger(ProtonBuffer buffer, DecoderState state, int defaultValue) throws DecodeException {
        byte encodingCode = ProtonDecoder.readEncodingCode(buffer);
        switch (encodingCode) {
            case 67: {
                return 0;
            }
            case 82: {
                return buffer.readByte() & 0xFF;
            }
            case 112: {
                return buffer.readInt();
            }
            case 64: {
                return defaultValue;
            }
        }
        throw new DecodeException("Expected Unsigned Integer type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public long readUnsignedInteger(ProtonBuffer buffer, DecoderState state, long defaultValue) throws DecodeException {
        byte encodingCode = ProtonDecoder.readEncodingCode(buffer);
        switch (encodingCode) {
            case 67: {
                return 0L;
            }
            case 82: {
                return buffer.readByte() & 0xFF;
            }
            case 112: {
                return (long)buffer.readInt() & 0xFFFFFFFFL;
            }
            case 64: {
                return defaultValue;
            }
        }
        throw new DecodeException("Expected Unsigned Integer type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public Long readLong(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        byte encodingCode = ProtonDecoder.readEncodingCode(buffer);
        switch (encodingCode) {
            case 85: {
                return buffer.readByte();
            }
            case -127: {
                return buffer.readLong();
            }
            case 64: {
                return null;
            }
        }
        throw new DecodeException("Expected Long type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public long readLong(ProtonBuffer buffer, DecoderState state, long defaultValue) throws DecodeException {
        byte encodingCode = ProtonDecoder.readEncodingCode(buffer);
        switch (encodingCode) {
            case 85: {
                return buffer.readByte();
            }
            case -127: {
                return buffer.readLong();
            }
            case 64: {
                return defaultValue;
            }
        }
        throw new DecodeException("Expected Unsigned Long type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public UnsignedLong readUnsignedLong(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        byte encodingCode = ProtonDecoder.readEncodingCode(buffer);
        switch (encodingCode) {
            case 68: {
                return UnsignedLong.ZERO;
            }
            case 83: {
                return UnsignedLong.valueOf(buffer.readByte() & 0xFF);
            }
            case -128: {
                return UnsignedLong.valueOf(buffer.readLong());
            }
            case 64: {
                return null;
            }
        }
        throw new DecodeException("Expected Unsigned Long type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public long readUnsignedLong(ProtonBuffer buffer, DecoderState state, long defaultValue) throws DecodeException {
        byte encodingCode = ProtonDecoder.readEncodingCode(buffer);
        switch (encodingCode) {
            case 68: {
                return 0L;
            }
            case 83: {
                return buffer.readByte() & 0xFF;
            }
            case -128: {
                return buffer.readLong();
            }
            case 64: {
                return defaultValue;
            }
        }
        throw new DecodeException("Expected Unsigned Long type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public Float readFloat(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        byte encodingCode = ProtonDecoder.readEncodingCode(buffer);
        switch (encodingCode) {
            case 114: {
                return Float.valueOf(buffer.readFloat());
            }
            case 64: {
                return null;
            }
        }
        throw new DecodeException("Expected Float type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public float readFloat(ProtonBuffer buffer, DecoderState state, float defaultValue) throws DecodeException {
        byte encodingCode = ProtonDecoder.readEncodingCode(buffer);
        switch (encodingCode) {
            case 114: {
                return buffer.readFloat();
            }
            case 64: {
                return defaultValue;
            }
        }
        throw new DecodeException("Expected Float type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public Double readDouble(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        byte encodingCode = ProtonDecoder.readEncodingCode(buffer);
        switch (encodingCode) {
            case -126: {
                return buffer.readDouble();
            }
            case 64: {
                return null;
            }
        }
        throw new DecodeException("Expected Double type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public double readDouble(ProtonBuffer buffer, DecoderState state, double defaultValue) throws DecodeException {
        byte encodingCode = ProtonDecoder.readEncodingCode(buffer);
        switch (encodingCode) {
            case -126: {
                return buffer.readDouble();
            }
            case 64: {
                return defaultValue;
            }
        }
        throw new DecodeException("Expected Double type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public Binary readBinary(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        byte encodingCode = ProtonDecoder.readEncodingCode(buffer);
        switch (encodingCode) {
            case -96: {
                return binary8Decoder.readValue(buffer, state);
            }
            case -80: {
                return binary32Decoder.readValue(buffer, state);
            }
            case 64: {
                return null;
            }
        }
        throw new DecodeException("Expected Binary type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public ProtonBuffer readBinaryAsBuffer(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        byte encodingCode = ProtonDecoder.readEncodingCode(buffer);
        switch (encodingCode) {
            case -96: {
                return binary8Decoder.readValueAsBuffer(buffer, state);
            }
            case -80: {
                return binary32Decoder.readValueAsBuffer(buffer, state);
            }
            case 64: {
                return null;
            }
        }
        throw new DecodeException("Expected Binary type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public DeliveryTag readDeliveryTag(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        byte encodingCode = ProtonDecoder.readEncodingCode(buffer);
        switch (encodingCode) {
            case -96: {
                return new DeliveryTag.ProtonDeliveryTag(binary8Decoder.readValueAsArray(buffer, state));
            }
            case -80: {
                return new DeliveryTag.ProtonDeliveryTag(binary32Decoder.readValueAsArray(buffer, state));
            }
            case 64: {
                return null;
            }
        }
        throw new DecodeException("Expected Binary type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public String readString(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        byte encodingCode = ProtonDecoder.readEncodingCode(buffer);
        switch (encodingCode) {
            case -95: {
                return string8Decoder.readValue(buffer, state);
            }
            case -79: {
                return string32Decoder.readValue(buffer, state);
            }
            case 64: {
                return null;
            }
        }
        throw new DecodeException("Expected String type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public Symbol readSymbol(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        byte encodingCode = ProtonDecoder.readEncodingCode(buffer);
        switch (encodingCode) {
            case -93: {
                return symbol8Decoder.readValue(buffer, state);
            }
            case -77: {
                return symbol32Decoder.readValue(buffer, state);
            }
            case 64: {
                return null;
            }
        }
        throw new DecodeException("Expected Symbol type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public String readSymbol(ProtonBuffer buffer, DecoderState state, String defaultValue) throws DecodeException {
        byte encodingCode = ProtonDecoder.readEncodingCode(buffer);
        switch (encodingCode) {
            case -93: {
                return symbol8Decoder.readString(buffer, state);
            }
            case -77: {
                return symbol32Decoder.readString(buffer, state);
            }
            case 64: {
                return defaultValue;
            }
        }
        throw new DecodeException("Expected Symbol type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public Long readTimestamp(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        byte encodingCode = ProtonDecoder.readEncodingCode(buffer);
        switch (encodingCode) {
            case -125: {
                return buffer.readLong();
            }
            case 64: {
                return null;
            }
        }
        throw new DecodeException("Expected Timestamp type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public long readTimestamp(ProtonBuffer buffer, DecoderState state, long defaultValue) throws DecodeException {
        byte encodingCode = ProtonDecoder.readEncodingCode(buffer);
        switch (encodingCode) {
            case -125: {
                return buffer.readLong();
            }
            case 64: {
                return defaultValue;
            }
        }
        throw new DecodeException("Expected Timestamp type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public UUID readUUID(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        byte encodingCode = ProtonDecoder.readEncodingCode(buffer);
        switch (encodingCode) {
            case -104: {
                return new UUID(buffer.readLong(), buffer.readLong());
            }
            case 64: {
                return null;
            }
        }
        throw new DecodeException("Expected UUID type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public <K, V> Map<K, V> readMap(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        byte encodingCode = ProtonDecoder.readEncodingCode(buffer);
        switch (encodingCode) {
            case -63: {
                return map8Decoder.readValue(buffer, state);
            }
            case -47: {
                return map32Decoder.readValue(buffer, state);
            }
            case 64: {
                return null;
            }
        }
        throw new DecodeException("Expected Map type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    @Override
    public <V> List<V> readList(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        byte encodingCode = ProtonDecoder.readEncodingCode(buffer);
        switch (encodingCode) {
            case 69: {
                return Collections.emptyList();
            }
            case -64: {
                return list8Decoder.readValue(buffer, state);
            }
            case -48: {
                return list32Decoder.readValue(buffer, state);
            }
            case 64: {
                return null;
            }
        }
        throw new DecodeException("Expected List type but found encoding: " + EncodingCodes.toString(encodingCode));
    }

    private static byte readEncodingCode(ProtonBuffer buffer) throws DecodeEOFException {
        try {
            return buffer.readByte();
        }
        catch (IndexOutOfBoundsException iobe) {
            throw new DecodeEOFException("Read of new type failed because buffer exhausted.", iobe);
        }
    }

    private ClassCastException signalUnexpectedType(Object val, Class<?> clazz) {
        return new ClassCastException("Unexpected type " + val.getClass().getName() + ". Expected " + clazz.getName() + ".");
    }

    private TypeDecoder<?> handleUnknownDescribedType(final Object descriptor) {
        UnknownDescribedTypeDecoder typeDecoder = new UnknownDescribedTypeDecoder(){

            @Override
            public Object getDescriptor() {
                return descriptor;
            }
        };
        this.describedTypeDecoders.put(descriptor, typeDecoder);
        return typeDecoder;
    }

    static {
        ProtonDecoder.primitiveDecoders[86] = new BooleanTypeDecoder();
        ProtonDecoder.primitiveDecoders[65] = new BooleanTrueTypeDecoder();
        ProtonDecoder.primitiveDecoders[66] = new BooleanFalseTypeDecoder();
        ProtonDecoder.primitiveDecoders[160] = new Binary8TypeDecoder();
        ProtonDecoder.primitiveDecoders[176] = new Binary32TypeDecoder();
        ProtonDecoder.primitiveDecoders[81] = new ByteTypeDecoder();
        ProtonDecoder.primitiveDecoders[115] = new CharacterTypeDecoder();
        ProtonDecoder.primitiveDecoders[116] = new Decimal32TypeDecoder();
        ProtonDecoder.primitiveDecoders[132] = new Decimal64TypeDecoder();
        ProtonDecoder.primitiveDecoders[148] = new Decimal128TypeDecoder();
        ProtonDecoder.primitiveDecoders[130] = new DoubleTypeDecoder();
        ProtonDecoder.primitiveDecoders[114] = new FloatTypeDecoder();
        ProtonDecoder.primitiveDecoders[64] = new NullTypeDecoder();
        ProtonDecoder.primitiveDecoders[97] = new ShortTypeDecoder();
        ProtonDecoder.primitiveDecoders[84] = new Integer8TypeDecoder();
        ProtonDecoder.primitiveDecoders[113] = new Integer32TypeDecoder();
        ProtonDecoder.primitiveDecoders[85] = new Long8TypeDecoder();
        ProtonDecoder.primitiveDecoders[129] = new LongTypeDecoder();
        ProtonDecoder.primitiveDecoders[80] = new UnsignedByteTypeDecoder();
        ProtonDecoder.primitiveDecoders[96] = new UnsignedShortTypeDecoder();
        ProtonDecoder.primitiveDecoders[67] = new UnsignedInteger0TypeDecoder();
        ProtonDecoder.primitiveDecoders[82] = new UnsignedInteger8TypeDecoder();
        ProtonDecoder.primitiveDecoders[112] = new UnsignedInteger32TypeDecoder();
        ProtonDecoder.primitiveDecoders[68] = new UnsignedLong0TypeDecoder();
        ProtonDecoder.primitiveDecoders[83] = new UnsignedLong8TypeDecoder();
        ProtonDecoder.primitiveDecoders[128] = new UnsignedLong64TypeDecoder();
        ProtonDecoder.primitiveDecoders[161] = new String8TypeDecoder();
        ProtonDecoder.primitiveDecoders[177] = new String32TypeDecoder();
        ProtonDecoder.primitiveDecoders[163] = new Symbol8TypeDecoder();
        ProtonDecoder.primitiveDecoders[179] = new Symbol32TypeDecoder();
        ProtonDecoder.primitiveDecoders[152] = new UUIDTypeDecoder();
        ProtonDecoder.primitiveDecoders[131] = new TimestampTypeDecoder();
        ProtonDecoder.primitiveDecoders[69] = new List0TypeDecoder();
        ProtonDecoder.primitiveDecoders[192] = new List8TypeDecoder();
        ProtonDecoder.primitiveDecoders[208] = new List32TypeDecoder();
        ProtonDecoder.primitiveDecoders[193] = new Map8TypeDecoder();
        ProtonDecoder.primitiveDecoders[209] = new Map32TypeDecoder();
        ProtonDecoder.primitiveDecoders[224] = new Array8TypeDecoder();
        ProtonDecoder.primitiveDecoders[240] = new Array32TypeDecoder();
        symbol8Decoder = (Symbol8TypeDecoder)primitiveDecoders[163];
        symbol32Decoder = (Symbol32TypeDecoder)primitiveDecoders[179];
        binary8Decoder = (Binary8TypeDecoder)primitiveDecoders[160];
        binary32Decoder = (Binary32TypeDecoder)primitiveDecoders[176];
        list8Decoder = (List8TypeDecoder)primitiveDecoders[192];
        list32Decoder = (List32TypeDecoder)primitiveDecoders[208];
        map8Decoder = (Map8TypeDecoder)primitiveDecoders[193];
        map32Decoder = (Map32TypeDecoder)primitiveDecoders[209];
        string32Decoder = (String32TypeDecoder)primitiveDecoders[177];
        string8Decoder = (String8TypeDecoder)primitiveDecoders[161];
    }
}

