/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.codec.decoders.primitives;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.codec.DecodeException;
import com.rabbitmq.qpid.protonj2.codec.DecoderState;
import com.rabbitmq.qpid.protonj2.codec.StreamDecoderState;
import com.rabbitmq.qpid.protonj2.codec.decoders.AbstractPrimitiveTypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.StringTypeDecoder;
import java.io.IOException;
import java.io.InputStream;

public abstract class AbstractStringTypeDecoder
extends AbstractPrimitiveTypeDecoder<String>
implements StringTypeDecoder {
    @Override
    public String readValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        int length = this.readSize(buffer, state);
        if (length > buffer.getReadableBytes()) {
            throw new DecodeException(String.format("String encoded size %d is specified to be greater than the amount of data available (%d)", length, buffer.getReadableBytes()));
        }
        if (length != 0) {
            return state.decodeUTF8(buffer, length);
        }
        return "";
    }

    @Override
    public String readValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        int length = this.readSize(stream, state);
        if (length != 0) {
            return state.decodeUTF8(stream, length);
        }
        return "";
    }

    @Override
    public void skipValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        buffer.advanceReadOffset(this.readSize(buffer, state));
    }

    @Override
    public void skipValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        try {
            stream.skip(this.readSize(stream, state));
        }
        catch (IOException ex) {
            throw new DecodeException("Error while reading String payload bytes", ex);
        }
    }
}

