/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.codec.decoders.transactions;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.codec.DecodeException;
import com.rabbitmq.qpid.protonj2.codec.DecoderState;
import com.rabbitmq.qpid.protonj2.codec.StreamDecoderState;
import com.rabbitmq.qpid.protonj2.codec.StreamTypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.TypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.AbstractDescribedListTypeDecoder;
import com.rabbitmq.qpid.protonj2.codec.decoders.primitives.ListTypeDecoder;
import com.rabbitmq.qpid.protonj2.types.Symbol;
import com.rabbitmq.qpid.protonj2.types.UnsignedLong;
import com.rabbitmq.qpid.protonj2.types.transactions.Coordinator;
import java.io.InputStream;

public final class CoordinatorTypeDecoder
extends AbstractDescribedListTypeDecoder<Coordinator> {
    private static final int MIN_COORDINATOR_LIST_ENTRIES = 0;
    private static final int MAX_COORDINATOR_LIST_ENTRIES = 1;

    @Override
    public Class<Coordinator> getTypeClass() {
        return Coordinator.class;
    }

    @Override
    public UnsignedLong getDescriptorCode() {
        return Coordinator.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return Coordinator.DESCRIPTOR_SYMBOL;
    }

    @Override
    public Coordinator readValue(ProtonBuffer buffer, DecoderState state) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        return this.readCoordinator(buffer, state, (ListTypeDecoder)CoordinatorTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
    }

    public Coordinator[] readArrayElements(ProtonBuffer buffer, DecoderState state, int count) throws DecodeException {
        TypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(buffer, state);
        Coordinator[] result = new Coordinator[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readCoordinator(buffer, state, (ListTypeDecoder)CoordinatorTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
        }
        return result;
    }

    private Coordinator readCoordinator(ProtonBuffer buffer, DecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        Coordinator coordinator = new Coordinator();
        int size = listDecoder.readSize(buffer, state);
        int count = listDecoder.readCount(buffer, state);
        if (count < 0) {
            throw new DecodeException("Not enough entries in Coordinator list encoding: " + count);
        }
        if (count > 1) {
            throw new DecodeException("To many entries in Coordinator list encoding: " + count);
        }
        if (count == 1) {
            coordinator.setCapabilities(state.getDecoder().readMultiple(buffer, state, Symbol.class));
        }
        return coordinator;
    }

    @Override
    public Coordinator readValue(InputStream stream, StreamDecoderState state) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        return this.readCoordinator(stream, state, (ListTypeDecoder)CoordinatorTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
    }

    public Coordinator[] readArrayElements(InputStream stream, StreamDecoderState state, int count) throws DecodeException {
        StreamTypeDecoder<?> decoder = state.getDecoder().readNextTypeDecoder(stream, state);
        Coordinator[] result = new Coordinator[count];
        for (int i = 0; i < count; ++i) {
            result[i] = this.readCoordinator(stream, state, (ListTypeDecoder)CoordinatorTypeDecoder.checkIsExpectedTypeAndCast(ListTypeDecoder.class, decoder));
        }
        return result;
    }

    private Coordinator readCoordinator(InputStream stream, StreamDecoderState state, ListTypeDecoder listDecoder) throws DecodeException {
        Coordinator coordinator = new Coordinator();
        int size = listDecoder.readSize(stream, state);
        int count = listDecoder.readCount(stream, state);
        if (count < 0) {
            throw new DecodeException("Not enough entries in Coordinator list encoding: " + count);
        }
        if (count > 1) {
            throw new DecodeException("To many entries in Coordinator list encoding: " + count);
        }
        if (count == 1) {
            coordinator.setCapabilities(state.getDecoder().readMultiple(stream, state, Symbol.class));
        }
        return coordinator;
    }
}

