/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.codec.encoders.transport;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.codec.Encoder;
import com.rabbitmq.qpid.protonj2.codec.EncoderState;
import com.rabbitmq.qpid.protonj2.codec.encoders.AbstractDescribedListTypeEncoder;
import com.rabbitmq.qpid.protonj2.types.Symbol;
import com.rabbitmq.qpid.protonj2.types.UnsignedLong;
import com.rabbitmq.qpid.protonj2.types.transport.Transfer;

public final class TransferTypeEncoder
extends AbstractDescribedListTypeEncoder<Transfer> {
    @Override
    public UnsignedLong getDescriptorCode() {
        return Transfer.DESCRIPTOR_CODE;
    }

    @Override
    public Symbol getDescriptorSymbol() {
        return Transfer.DESCRIPTOR_SYMBOL;
    }

    @Override
    public Class<Transfer> getTypeClass() {
        return Transfer.class;
    }

    private static void writeCheckedUnsignedInteger(long value, ProtonBuffer buffer) {
        if (value == 0L) {
            buffer.writeByte((byte)67);
        } else if (value <= 255L) {
            buffer.writeByte((byte)82);
            buffer.writeByte((byte)value);
        } else {
            buffer.writeByte((byte)112);
            buffer.writeInt((int)value);
        }
    }

    @Override
    public void writeElement(Transfer transfer, int index, ProtonBuffer buffer, Encoder encoder, EncoderState state) {
        block14: {
            block13: {
                if (!transfer.hasElement(index)) break block13;
                switch (index) {
                    case 0: {
                        TransferTypeEncoder.writeCheckedUnsignedInteger(transfer.getHandle(), buffer);
                        break block14;
                    }
                    case 1: {
                        TransferTypeEncoder.writeCheckedUnsignedInteger(transfer.getDeliveryId(), buffer);
                        break block14;
                    }
                    case 2: {
                        encoder.writeDeliveryTag(buffer, state, transfer.getDeliveryTag());
                        break block14;
                    }
                    case 3: {
                        TransferTypeEncoder.writeCheckedUnsignedInteger(transfer.getMessageFormat(), buffer);
                        break block14;
                    }
                    case 4: {
                        buffer.writeByte(transfer.getSettled() ? (byte)65 : 66);
                        break block14;
                    }
                    case 5: {
                        buffer.writeByte(transfer.getMore() ? (byte)65 : 66);
                        break block14;
                    }
                    case 6: {
                        buffer.writeByte((byte)80);
                        buffer.writeByte(transfer.getRcvSettleMode().byteValue());
                        break block14;
                    }
                    case 7: {
                        encoder.writeObject(buffer, state, transfer.getState());
                        break block14;
                    }
                    case 8: {
                        buffer.writeByte(transfer.getResume() ? (byte)65 : 66);
                        break block14;
                    }
                    case 9: {
                        buffer.writeByte(transfer.getAborted() ? (byte)65 : 66);
                        break block14;
                    }
                    case 10: {
                        buffer.writeByte(transfer.getBatchable() ? (byte)65 : 66);
                        break block14;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown Transfer value index: " + index);
                    }
                }
            }
            buffer.writeByte((byte)64);
        }
    }

    @Override
    public byte getListEncoding(Transfer value) {
        if (value.getState() != null) {
            return -48;
        }
        if (value.getDeliveryTag() != null && value.getDeliveryTag().tagLength() > 200) {
            return -48;
        }
        return -64;
    }

    @Override
    public int getElementCount(Transfer transfer) {
        return transfer.getElementCount();
    }

    @Override
    public int getMinElementCount() {
        return 1;
    }
}

