/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.engine.impl;

import com.rabbitmq.qpid.protonj2.engine.LinkCreditState;
import com.rabbitmq.qpid.protonj2.types.transport.Flow;

public class ProtonLinkCreditState
implements LinkCreditState {
    private int credit;
    private int deliveryCount;
    private boolean drain;
    private boolean echo;
    private boolean deliveryCountInitialized;
    private long remoteDeliveryCount;
    private long remoteLinkCredit;

    public ProtonLinkCreditState() {
    }

    public ProtonLinkCreditState(int deliveryCount) {
        this.initializeDeliveryCount(deliveryCount);
    }

    @Override
    public int getCredit() {
        return this.credit;
    }

    @Override
    public int getDeliveryCount() {
        return this.deliveryCount;
    }

    @Override
    public boolean isDrain() {
        return this.drain;
    }

    @Override
    public boolean isEcho() {
        return this.echo;
    }

    boolean hasCredit() {
        return Integer.compareUnsigned(this.credit, 0) > 0;
    }

    void clearDrain() {
        this.drain = false;
    }

    void clearEcho() {
        this.echo = false;
    }

    void clearCredit() {
        this.credit = 0;
    }

    void incrementCredit(int credit) {
        this.credit += credit;
    }

    void decrementCredit() {
        this.credit = this.credit == 0 ? 0 : this.credit - 1;
    }

    int incrementDeliveryCount() {
        return this.deliveryCount++;
    }

    int incrementDeliveryCount(int amount) {
        return this.deliveryCount += amount;
    }

    int decrementDeliveryCount() {
        return this.deliveryCount--;
    }

    boolean isDeliveryCountInitialized() {
        return this.deliveryCountInitialized;
    }

    void initializeDeliveryCount(int deliveryCount) {
        this.deliveryCount = deliveryCount;
        this.deliveryCountInitialized = true;
    }

    public void updateCredit(int effectiveCredit) {
        this.credit = effectiveCredit;
    }

    public void updateDeliveryCount(int deliveryCount) {
        this.deliveryCount = deliveryCount;
    }

    public void updateEcho(boolean echo) {
        this.echo = echo;
    }

    void remoteFlow(Flow flow) {
        this.remoteDeliveryCount = flow.getDeliveryCount();
        this.remoteLinkCredit = flow.getLinkCredit();
        this.echo = flow.getEcho();
        this.drain = flow.getDrain();
    }

    LinkCreditState snapshot() {
        return new UnmodifiableLinkCreditState(this.credit, this.deliveryCount, this.drain, this.echo);
    }

    private static class UnmodifiableLinkCreditState
    implements LinkCreditState {
        private final int credit;
        private final int deliveryCount;
        private final boolean drain;
        private final boolean echo;

        public UnmodifiableLinkCreditState(int credit, int deliveryCount, boolean drain, boolean echo) {
            this.credit = credit;
            this.deliveryCount = deliveryCount;
            this.drain = drain;
            this.echo = echo;
        }

        @Override
        public int getCredit() {
            return this.credit;
        }

        @Override
        public int getDeliveryCount() {
            return this.deliveryCount;
        }

        @Override
        public boolean isDrain() {
            return this.drain;
        }

        @Override
        public boolean isEcho() {
            return this.echo;
        }
    }
}

