/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.engine.sasl.client;

import com.rabbitmq.qpid.protonj2.buffer.ProtonBuffer;
import com.rabbitmq.qpid.protonj2.buffer.ProtonBufferAllocator;
import com.rabbitmq.qpid.protonj2.engine.sasl.client.AbstractMechanism;
import com.rabbitmq.qpid.protonj2.engine.sasl.client.SaslCredentialsProvider;
import com.rabbitmq.qpid.protonj2.types.Symbol;
import java.nio.charset.StandardCharsets;
import java.util.regex.Pattern;
import javax.security.sasl.SaslException;

public class XOauth2Mechanism
extends AbstractMechanism {
    private final Pattern ACCESS_TOKEN_PATTERN = Pattern.compile("^[\\x20-\\x7F]+$");
    public static final Symbol XOAUTH2 = Symbol.valueOf("XOAUTH2");
    private String additionalFailureInformation;

    @Override
    public Symbol getName() {
        return XOAUTH2;
    }

    @Override
    public boolean isApplicable(SaslCredentialsProvider credentials) {
        if (credentials.username() != null && !credentials.username().isEmpty() && credentials.password() != null && !credentials.password().isEmpty()) {
            return this.ACCESS_TOKEN_PATTERN.matcher(credentials.password()).matches();
        }
        return false;
    }

    @Override
    public ProtonBuffer getInitialResponse(SaslCredentialsProvider credentials) throws SaslException {
        String username = credentials.username();
        String password = credentials.password();
        if (username == null) {
            username = "";
        }
        if (password == null) {
            password = "";
        }
        byte[] usernameBytes = username.getBytes(StandardCharsets.UTF_8);
        byte[] passwordBytes = password.getBytes(StandardCharsets.UTF_8);
        byte[] data = new byte[usernameBytes.length + passwordBytes.length + 20];
        System.arraycopy("user=".getBytes(StandardCharsets.US_ASCII), 0, data, 0, 5);
        System.arraycopy(usernameBytes, 0, data, 5, usernameBytes.length);
        data[5 + usernameBytes.length] = 1;
        System.arraycopy("auth=Bearer ".getBytes(StandardCharsets.US_ASCII), 0, data, 6 + usernameBytes.length, 12);
        System.arraycopy(passwordBytes, 0, data, 18 + usernameBytes.length, passwordBytes.length);
        data[data.length - 2] = 1;
        data[data.length - 1] = 1;
        return ProtonBufferAllocator.defaultAllocator().copy(data).convertToReadOnly();
    }

    @Override
    public ProtonBuffer getChallengeResponse(SaslCredentialsProvider credentials, ProtonBuffer challenge) throws SaslException {
        if (challenge != null && challenge.getReadableBytes() > 0 && this.additionalFailureInformation == null) {
            this.additionalFailureInformation = challenge.toString(StandardCharsets.UTF_8);
        }
        return EMPTY;
    }
}

