/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.engine.util;

import com.rabbitmq.qpid.protonj2.engine.util.SplayMap;
import com.rabbitmq.qpid.protonj2.types.UnsignedInteger;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;

public class LinkedSplayMap<E>
extends SplayMap<E> {
    private final transient SplayMap.SplayedEntry<E> entries = new SplayMap.SplayedEntry();

    @Override
    public void clear() {
        super.clear();
        this.entries.linkPrev = this.entries;
        this.entries.linkNext = this.entries.linkPrev;
    }

    @Override
    public Collection<E> values() {
        if (this.values == null) {
            this.values = new LinkedSplayMapValues();
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<UnsignedInteger, E>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new LinkedSplayMapEntrySet();
        }
        return this.entrySet;
    }

    @Override
    public NavigableSet<UnsignedInteger> navigableKeySet() {
        if (this.keySet == null) {
            this.keySet = new LinkedSplayMapKeySet();
        }
        return this.keySet;
    }

    @Override
    public void forEach(BiConsumer<? super UnsignedInteger, ? super E> action) {
        Objects.requireNonNull(action);
        SplayMap.SplayedEntry<E> root = this.entries;
        SplayMap.SplayedEntry entry = root.linkNext;
        while (entry != root) {
            action.accept(entry.getKey(), entry.getValue());
            entry = entry.linkNext;
        }
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        SplayMap.SplayedEntry<E> root = this.entries;
        SplayMap.SplayedEntry entry = root.linkNext;
        while (entry != root) {
            action.accept(entry.getValue());
            entry = entry.linkNext;
        }
    }

    @Override
    public void replaceAll(BiFunction<? super UnsignedInteger, ? super E, ? extends E> function) {
        Objects.requireNonNull(function, "The replacement function parameter cannot be null");
        int initialModCount = this.modCount;
        SplayMap.SplayedEntry e = this.entries.linkNext;
        while (e != this.entries) {
            e.value = function.apply(e.getKey(), e.value);
            e = e.linkNext;
        }
        if (this.modCount != initialModCount) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    protected void entryAdded(SplayMap.SplayedEntry<E> newEntry) {
        newEntry.linkNext = this.entries;
        newEntry.linkPrev = this.entries.linkPrev;
        this.entries.linkPrev.linkNext = newEntry;
        this.entries.linkPrev = newEntry;
    }

    @Override
    protected void entryDeleted(SplayMap.SplayedEntry<E> deletedEntry) {
        deletedEntry.linkNext.linkPrev = deletedEntry.linkPrev;
        deletedEntry.linkPrev.linkNext = deletedEntry.linkNext;
        deletedEntry.linkPrev = null;
        deletedEntry.linkNext = null;
    }

    private final class LinkedSplayMapEntrySet
    extends AbstractSet<Map.Entry<UnsignedInteger, E>> {
        private LinkedSplayMapEntrySet() {
        }

        @Override
        public Iterator<Map.Entry<UnsignedInteger, E>> iterator() {
            return new LinkedSplayMapEntryIterator(LinkedSplayMap.this.entries.linkNext);
        }

        @Override
        public int size() {
            return LinkedSplayMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            SplayMap.SplayedEntry root = LinkedSplayMap.this.entries;
            SplayMap.SplayedEntry entry = root.linkNext;
            while (entry != root) {
                if (entry.equals(o)) {
                    return true;
                }
                entry = entry.linkNext;
            }
            return false;
        }

        @Override
        public void forEach(Consumer<? super Map.Entry<UnsignedInteger, E>> action) {
            Objects.requireNonNull(action, "forEach action parameter cannot be null");
            int initialModCount = LinkedSplayMap.this.modCount;
            SplayMap.SplayedEntry root = LinkedSplayMap.this.entries;
            SplayMap.SplayedEntry entry = root.linkNext;
            while (entry != LinkedSplayMap.this.entries) {
                action.accept(entry);
                entry = entry.linkNext;
            }
            if (LinkedSplayMap.this.modCount != initialModCount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean remove(Object target) {
            if (!(target instanceof Map.Entry)) {
                throw new IllegalArgumentException("value provided is not an Entry type.");
            }
            SplayMap.SplayedEntry root = LinkedSplayMap.this.entries;
            SplayMap.SplayedEntry entry = root.linkNext;
            while (entry != root) {
                if (entry.equals(target)) {
                    LinkedSplayMap.this.delete(entry);
                    return true;
                }
                entry = entry.linkNext;
            }
            return false;
        }

        @Override
        public void clear() {
            LinkedSplayMap.this.clear();
        }
    }

    private final class LinkedSplayMapKeySet
    extends SplayMap.SplayMapKeySet {
        private LinkedSplayMapKeySet() {
            super(LinkedSplayMap.this);
        }

        @Override
        public Iterator<UnsignedInteger> iterator() {
            return new LinkedSplayMapKeyIterator(LinkedSplayMap.this.entries.linkNext);
        }

        @Override
        public boolean remove(Object target) {
            SplayMap.SplayedEntry root = LinkedSplayMap.this.entries;
            SplayMap.SplayedEntry entry = root.linkNext;
            while (entry != root) {
                if (entry.keyEquals(target)) {
                    LinkedSplayMap.this.delete(entry);
                    return true;
                }
                entry = entry.linkNext;
            }
            return false;
        }

        @Override
        public void forEach(Consumer<? super UnsignedInteger> action) {
            Objects.requireNonNull(action, "forEach action parameter cannot be null");
            int initialModCount = LinkedSplayMap.this.modCount;
            SplayMap.SplayedEntry root = LinkedSplayMap.this.entries;
            SplayMap.SplayedEntry entry = root.linkNext;
            while (entry != LinkedSplayMap.this.entries) {
                action.accept(entry.getKey());
                entry = entry.linkNext;
            }
            if (LinkedSplayMap.this.modCount != initialModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private final class LinkedSplayMapValues
    extends AbstractCollection<E> {
        private LinkedSplayMapValues() {
        }

        @Override
        public Iterator<E> iterator() {
            return new LinkedSplayMapValueIterator(LinkedSplayMap.this.entries.linkNext);
        }

        @Override
        public int size() {
            return LinkedSplayMap.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return LinkedSplayMap.this.containsValue(o);
        }

        @Override
        public boolean remove(Object target) {
            SplayMap.SplayedEntry root = LinkedSplayMap.this.entries;
            SplayMap.SplayedEntry entry = root.linkNext;
            while (entry != root) {
                if (entry.valueEquals(target)) {
                    LinkedSplayMap.this.delete(entry);
                    return true;
                }
                entry = entry.linkNext;
            }
            return false;
        }

        @Override
        public void forEach(Consumer<? super E> action) {
            Objects.requireNonNull(action, "forEach action parameter cannot be null");
            int initialModCount = LinkedSplayMap.this.modCount;
            SplayMap.SplayedEntry root = LinkedSplayMap.this.entries;
            SplayMap.SplayedEntry entry = root.linkNext;
            while (entry != LinkedSplayMap.this.entries) {
                action.accept(entry.value);
                entry = entry.linkNext;
            }
            if (LinkedSplayMap.this.modCount != initialModCount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void clear() {
            LinkedSplayMap.this.clear();
        }
    }

    private class LinkedSplayMapValueIterator
    extends LinkedSplayMapIterator<E> {
        public LinkedSplayMapValueIterator(SplayMap.SplayedEntry<E> startAt) {
            super(startAt);
        }

        @Override
        public E next() {
            return this.nextNode().getValue();
        }
    }

    private class LinkedSplayMapKeyIterator
    extends LinkedSplayMapIterator<UnsignedInteger> {
        public LinkedSplayMapKeyIterator(SplayMap.SplayedEntry<E> startAt) {
            super(startAt);
        }

        @Override
        public UnsignedInteger next() {
            return this.nextNode().getKey();
        }
    }

    private class LinkedSplayMapEntryIterator
    extends LinkedSplayMapIterator<Map.Entry<UnsignedInteger, E>> {
        public LinkedSplayMapEntryIterator(SplayMap.SplayedEntry<E> startAt) {
            super(startAt);
        }

        @Override
        public Map.Entry<UnsignedInteger, E> next() {
            return this.nextNode();
        }
    }

    private abstract class LinkedSplayMapIterator<T>
    implements Iterator<T> {
        private SplayMap.SplayedEntry<E> nextNode;
        private SplayMap.SplayedEntry<E> lastReturned;
        private int expectedModCount;

        public LinkedSplayMapIterator(SplayMap.SplayedEntry<E> startAt) {
            this.nextNode = startAt;
            this.expectedModCount = LinkedSplayMap.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.nextNode != LinkedSplayMap.this.entries;
        }

        protected SplayMap.SplayedEntry<E> nextNode() {
            SplayMap.SplayedEntry entry = this.nextNode;
            if (this.nextNode == LinkedSplayMap.this.entries) {
                throw new NoSuchElementException();
            }
            if (this.expectedModCount != LinkedSplayMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            this.nextNode = entry.linkNext;
            this.lastReturned = entry;
            return this.lastReturned;
        }

        protected SplayMap.SplayedEntry<E> previousNode() {
            SplayMap.SplayedEntry entry = this.nextNode;
            if (this.nextNode == LinkedSplayMap.this.entries) {
                throw new NoSuchElementException();
            }
            if (this.expectedModCount != LinkedSplayMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            this.nextNode = this.nextNode.linkPrev;
            this.lastReturned = entry;
            return this.lastReturned;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (LinkedSplayMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            LinkedSplayMap.this.delete(this.lastReturned);
            this.expectedModCount = LinkedSplayMap.this.modCount;
            this.lastReturned = null;
        }
    }
}

