/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.qpid.protonj2.types.messaging;

import com.rabbitmq.qpid.protonj2.types.Symbol;
import com.rabbitmq.qpid.protonj2.types.UnsignedInteger;
import com.rabbitmq.qpid.protonj2.types.UnsignedLong;
import com.rabbitmq.qpid.protonj2.types.messaging.Outcome;
import com.rabbitmq.qpid.protonj2.types.messaging.Terminus;
import com.rabbitmq.qpid.protonj2.types.messaging.TerminusDurability;
import com.rabbitmq.qpid.protonj2.types.messaging.TerminusExpiryPolicy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public final class Source
implements Terminus {
    public static final UnsignedLong DESCRIPTOR_CODE = UnsignedLong.valueOf(40L);
    public static final Symbol DESCRIPTOR_SYMBOL = Symbol.valueOf("amqp:source:list");
    private String address;
    private TerminusDurability durable = TerminusDurability.NONE;
    private TerminusExpiryPolicy expiryPolicy = TerminusExpiryPolicy.SESSION_END;
    private UnsignedInteger timeout = UnsignedInteger.ZERO;
    private boolean dynamic;
    private Map<Symbol, Object> dynamicNodeProperties;
    private Symbol distributionMode;
    private Map<Symbol, Object> filter;
    private Outcome defaultOutcome;
    private Symbol[] outcomes;
    private Symbol[] capabilities;

    public Source() {
    }

    private Source(Source other) {
        this.address = other.address;
        this.durable = other.durable;
        this.expiryPolicy = other.expiryPolicy;
        this.timeout = other.timeout;
        this.dynamic = other.dynamic;
        if (other.dynamicNodeProperties != null) {
            this.dynamicNodeProperties = new HashMap<Symbol, Object>(other.dynamicNodeProperties);
        }
        if (other.capabilities != null) {
            this.capabilities = (Symbol[])other.capabilities.clone();
        }
        this.distributionMode = other.distributionMode;
        if (other.filter != null) {
            this.filter = new HashMap<Symbol, Object>(other.filter);
        }
        this.defaultOutcome = other.defaultOutcome;
        if (other.outcomes != null) {
            this.outcomes = (Symbol[])other.outcomes.clone();
        }
    }

    @Override
    public Source copy() {
        return new Source(this);
    }

    public String getAddress() {
        return this.address;
    }

    public Source setAddress(String address) {
        this.address = address;
        return this;
    }

    public TerminusDurability getDurable() {
        return this.durable;
    }

    public Source setDurable(TerminusDurability durable) {
        this.durable = durable == null ? TerminusDurability.NONE : durable;
        return this;
    }

    public TerminusExpiryPolicy getExpiryPolicy() {
        return this.expiryPolicy;
    }

    public Source setExpiryPolicy(TerminusExpiryPolicy expiryPolicy) {
        this.expiryPolicy = expiryPolicy == null ? TerminusExpiryPolicy.SESSION_END : expiryPolicy;
        return this;
    }

    public UnsignedInteger getTimeout() {
        return this.timeout;
    }

    public Source setTimeout(UnsignedInteger timeout) {
        this.timeout = timeout;
        return this;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public Source setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
        return this;
    }

    public Map<Symbol, Object> getDynamicNodeProperties() {
        return this.dynamicNodeProperties;
    }

    public Source setDynamicNodeProperties(Map<Symbol, ?> dynamicNodeProperties) {
        this.dynamicNodeProperties = dynamicNodeProperties;
        return this;
    }

    public Symbol[] getCapabilities() {
        return this.capabilities;
    }

    public Source setCapabilities(Symbol ... capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    public Symbol getDistributionMode() {
        return this.distributionMode;
    }

    public Source setDistributionMode(Symbol distributionMode) {
        this.distributionMode = distributionMode;
        return this;
    }

    public Map<Symbol, Object> getFilter() {
        return this.filter;
    }

    public Source setFilter(Map<Symbol, ?> filter) {
        this.filter = filter;
        return this;
    }

    public Outcome getDefaultOutcome() {
        return this.defaultOutcome;
    }

    public Source setDefaultOutcome(Outcome defaultOutcome) {
        this.defaultOutcome = defaultOutcome;
        return this;
    }

    public Symbol[] getOutcomes() {
        return this.outcomes;
    }

    public Source setOutcomes(Symbol ... outcomes) {
        this.outcomes = outcomes;
        return this;
    }

    public String toString() {
        return "Source{address='" + this.getAddress() + "', durable=" + String.valueOf((Object)this.getDurable()) + ", expiryPolicy=" + String.valueOf((Object)this.getExpiryPolicy()) + ", timeout=" + String.valueOf(this.getTimeout()) + ", dynamic=" + this.isDynamic() + ", dynamicNodeProperties=" + String.valueOf(this.getDynamicNodeProperties()) + ", distributionMode=" + String.valueOf(this.distributionMode) + ", filter=" + String.valueOf(this.filter) + ", defaultOutcome=" + String.valueOf(this.defaultOutcome) + ", outcomes=" + String.valueOf(this.outcomes == null ? null : Arrays.asList(this.outcomes)) + ", capabilities=" + String.valueOf(this.getCapabilities() == null ? null : Arrays.asList(this.getCapabilities())) + "}";
    }
}

