/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.async.impl;

import com.restlet.client.async.Deferred;
import com.restlet.client.async.Promise;
import com.restlet.client.async.PromiseHandler;
import com.restlet.client.async.impl.PromiseImpl;
import com.restlet.client.exception.PromiseNotCompletedException;
import com.restlet.client.log.LogService;
import com.restlet.client.log.impl.MockLogService;
import com.restlet.client.utils.NotNull;
import com.restlet.client.utils.Nullable;
import com.restlet.client.utils.Objects;
import java.util.ArrayList;
import java.util.List;

public class DeferredImpl<T>
implements Deferred<T> {
    public static LogService LOG_SERVICE = new MockLogService(DeferredImpl.class);
    private T result;
    private Throwable error;
    @Nullable
    private List<Deferred.DeferredResolvedHandler> handlers;
    private Deferred.State state = Deferred.State.PENDING;

    @Override
    public T getResult() {
        return this.result;
    }

    @Override
    public Throwable getError() {
        return this.error;
    }

    @Override
    public Deferred.State getState() {
        return this.state;
    }

    @Override
    public void addDeferredResolvedHandler(@NotNull Deferred.DeferredResolvedHandler handler) {
        if (this.getState() != Deferred.State.PENDING) {
            throw new IllegalStateException("Deferred has been already resolved");
        }
        if (this.handlers == null) {
            this.handlers = new ArrayList<Deferred.DeferredResolvedHandler>();
        }
        this.handlers.add(handler);
    }

    @Override
    public boolean safeResolve() {
        return this.safeResolve(null);
    }

    @Override
    public boolean safeResolve(T value) {
        if (this.state == Deferred.State.PENDING) {
            this.resolve(value);
            return true;
        }
        return false;
    }

    @Override
    public boolean safeReject(Throwable error) {
        if (this.state == Deferred.State.PENDING) {
            this.reject(error);
            return true;
        }
        return false;
    }

    @Override
    public Promise<T> promise() {
        return new PromiseImpl(this);
    }

    @Override
    public void resolveLater(T result) {
        this.resolve(result);
    }

    @Override
    public void resolve() {
        this.resolve(null);
    }

    @Override
    public void resolve(T result) {
        this.complete(Deferred.State.SUCCESS, result, null);
    }

    @Override
    public void reject(Throwable error) {
        if (error != null && !(error instanceof PromiseNotCompletedException)) {
            LOG_SERVICE.error(error.getMessage(), error);
        }
        this.complete(Deferred.State.ERROR, null, error);
    }

    @Override
    public void reject(String warningMessage) {
        if (!Objects.isNullOrEmpty(warningMessage)) {
            LOG_SERVICE.warning(warningMessage);
        }
        this.complete(Deferred.State.ERROR, null, null);
    }

    protected void complete(@NotNull Deferred.State state, @Nullable T result, @Nullable Throwable error) {
        if (this.state != Deferred.State.PENDING) {
            throw new IllegalStateException("This promise has been already resolved");
        }
        this.error = error;
        this.result = result;
        this.state = state;
        if (this.handlers == null) {
            return;
        }
        for (Deferred.DeferredResolvedHandler handler : this.handlers) {
            try {
                handler.onResolve(this);
            }
            catch (Exception exception) {}
        }
        this.handlers = null;
    }

    @Override
    public PromiseHandler<T> resolver() {
        return new PromiseHandler<T>(){

            @Override
            public Object on(T error) {
                DeferredImpl.this.resolve(error);
                return null;
            }
        };
    }

    @Override
    public PromiseHandler<Throwable> rejector() {
        return new PromiseHandler<Throwable>(){

            @Override
            public Object on(Throwable error) {
                DeferredImpl.this.reject(error);
                return null;
            }
        };
    }
}

