/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.log;

import java.util.logging.Level;

public interface LogService {
    public void debug(Class<?> var1, String var2);

    public void debug(Class<?> var1, String var2, Throwable var3);

    public void fine(Class<?> var1, String var2);

    public void error(String var1);

    public void error(String var1, Throwable var2);

    public void info(String var1);

    public void warning(String var1);

    public void log(Severity var1, String var2);

    public static enum Severity {
        Error(Level.SEVERE){

            @Override
            public void log(LogService logService, String message, Class<?> clazz) {
                logService.error(message);
            }
        }
        ,
        Info(Level.INFO){

            @Override
            public void log(LogService logService, String message, Class<?> clazz) {
                logService.info(message);
            }
        }
        ,
        Warning(Level.WARNING){

            @Override
            public void log(LogService logService, String message, Class<?> clazz) {
                logService.warning(message);
            }
        }
        ,
        Debug(Level.FINE){

            @Override
            public void log(LogService logService, String message, Class<?> clazz) {
                logService.debug(clazz, message);
            }
        }
        ,
        Fine(Level.FINER){

            @Override
            public void log(LogService logService, String message, Class<?> clazz) {
                logService.fine(clazz, message);
            }
        };

        public final Level level;

        private Severity(Level level) {
            this.level = level;
        }

        public abstract void log(LogService var1, String var2, Class<?> var3);
    }
}

