/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.log.impl;

import com.restlet.client.function.Function;
import com.restlet.client.log.LogService;
import com.restlet.client.utils.FunctionalUtils;

public class StdOutLogService
implements LogService {
    private void log(LogService.Severity severity, Class<?> clazz, String message, Throwable error) {
        System.out.println('[' + severity.name().toUpperCase() + ']' + FunctionalUtils.ifNotNull(clazz, new Function<Class<?>, String>(){

            @Override
            public String apply(Class<?> clazz) {
                return clazz.getSimpleName() + ": ";
            }
        }, "") + message + FunctionalUtils.ifNotNull(error, new Function<Throwable, String>(){

            @Override
            public String apply(Throwable error) {
                return error.getMessage();
            }
        }, ""));
    }

    @Override
    public void debug(Class<?> clazz, String message) {
        this.log(LogService.Severity.Debug, clazz, message, null);
    }

    @Override
    public void debug(Class<?> clazz, String message, Throwable e) {
        this.log(LogService.Severity.Debug, clazz, message, e);
    }

    @Override
    public void fine(Class<?> clazz, String message) {
        this.log(LogService.Severity.Fine, clazz, message, null);
    }

    @Override
    public void error(String message) {
        this.log(LogService.Severity.Error, null, message, null);
    }

    @Override
    public void error(String message, Throwable e) {
        this.log(LogService.Severity.Error, null, message, e);
    }

    @Override
    public void info(String message) {
        this.log(LogService.Severity.Info, null, message, null);
    }

    @Override
    public void warning(String message) {
        this.log(LogService.Severity.Warning, null, message, null);
    }

    @Override
    public void log(LogService.Severity severity, String message) {
        this.log(severity, null, message, null);
    }
}

