/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.model;

import com.restlet.client.model.ProjectTo;
import com.restlet.client.model.RemoteUserDriveTo;
import com.restlet.client.model.ServiceTo;
import com.restlet.client.model.environment.EnvironmentTo;
import com.restlet.client.net.http.request.HttpRequestTo;
import com.restlet.client.tests.ScenarioTo;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

public interface EntityTo
extends Serializable {
    public Type getType();

    public void setType(Type var1);

    public String getName();

    public void setName(String var1);

    public String getDescription();

    public void setDescription(String var1);

    public Integer getDescriptionHeight();

    public void setDescriptionHeight(Integer var1);

    public Boolean getDescriptionCollapsed();

    public void setDescriptionCollapsed(Boolean var1);

    public String getId();

    public void setId(String var1);

    public String getLastModified();

    public void setLastModified(String var1);

    public EntityTo getParent();

    public void setParent(EntityTo var1);

    public boolean isShared();

    public void setShared(boolean var1);

    public boolean isLocked();

    public void setLocked(boolean var1);

    public String getRemoteId();

    public void setRemoteId(String var1);

    public String getRemoteModification();

    public void setRemoteModification(String var1);

    public boolean isModifiedLocally();

    public void setModifiedLocally(boolean var1);

    public String getImportedFrom();

    public void setImportedFrom(String var1);

    public static enum Type {
        Request(HttpRequestTo.class, false),
        Project(ProjectTo.class, false),
        Service(ServiceTo.class, false),
        Context(EnvironmentTo.class, false),
        Scenario(ScenarioTo.class, false),
        RemoteUserDrive(RemoteUserDriveTo.class, true),
        LocalDriveRoot(null, true),
        SharedDriveRoot(null, true);

        final Class<? extends EntityTo> typeClass;
        public final boolean isDrive;

        private Type(Class<? extends EntityTo> typeClass, boolean isDrive) {
            this.typeClass = typeClass;
            this.isDrive = isDrive;
        }

        public static RepositoryElementTypeComparator getEntityTypeComparator() {
            return new RepositoryElementTypeComparator();
        }

        public Class<? extends EntityTo> typeClass() {
            return this.typeClass;
        }

        public boolean is(EntityTo entityTo) {
            return Objects.equals((Object)this, (Object)entityTo.getType());
        }

        public boolean isGreaterThan(Type otherType) {
            return Type.getEntityTypeComparator().compare(this, otherType) > 0;
        }

        public boolean isLowerThan(Type otherType) {
            return Type.getEntityTypeComparator().compare(this, otherType) < 0;
        }

        public boolean isGreaterOrEquals(Type otherType) {
            return Type.getEntityTypeComparator().compare(this, otherType) >= 0;
        }

        public boolean isLowerOrEquals(Type otherType) {
            return Type.getEntityTypeComparator().compare(this, otherType) <= 0;
        }

        public static class RepositoryElementTypeComparator
        implements Comparator<Type> {
            @Override
            public int compare(Type type1, Type type2) {
                List<Type> order = Arrays.asList(RemoteUserDrive, Project, Service, Scenario, Request);
                int type1Index = order.indexOf((Object)type1);
                int type2Index = order.indexOf((Object)type2);
                if (type1Index == -1 || type2Index == -1) {
                    throw new IllegalArgumentException("Compared elements must be repository elements. Got: " + (Object)((Object)type1) + " and " + (Object)((Object)type2));
                }
                return -Integer.compare(type1Index, type2Index);
            }
        }
    }
}

