/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.model;

import com.restlet.client.function.Function;
import com.restlet.client.function.Predicate;
import com.restlet.client.model.EntityTreeNode;
import com.restlet.client.utils.Sequence;
import java.util.Set;

public enum ImportPolicy {
    Overwrite("Overwrite", true, true),
    Update("Update", true, false),
    Preserve("Preserve", true, true),
    Sharing("Sharing", false, false),
    Synchronization("Synchronization", false, false);

    public final String name;
    public final boolean isFileImportPolicy;
    public final boolean isBridgeImportPolicy;

    private ImportPolicy(String name, boolean isFileImportPolicy, boolean isBridgeImportPolicy) {
        this.name = name;
        this.isFileImportPolicy = isFileImportPolicy;
        this.isBridgeImportPolicy = isBridgeImportPolicy;
    }

    public static Set<ImportPolicy> getFileImportPolicies() {
        return Sequence.of(ImportPolicy.values()).filter(ImportPolicy.isFileImportPolicyFilter()).toSet();
    }

    private static Predicate<ImportPolicy> isFileImportPolicyFilter() {
        return new Predicate<ImportPolicy>(){

            @Override
            public boolean test(ImportPolicy importPolicy) {
                return importPolicy.isFileImportPolicy;
            }
        };
    }

    private static Predicate<ImportPolicy> isBridgeImportPolicyFilter() {
        return new Predicate<ImportPolicy>(){

            @Override
            public boolean test(ImportPolicy importPolicy) {
                return importPolicy.isBridgeImportPolicy;
            }
        };
    }

    public Function<EntityTreeNode, String> identifierRetriever() {
        return new Function<EntityTreeNode, String>(){

            @Override
            public String apply(EntityTreeNode treeNode) {
                return ImportPolicy.this.isFileImportPolicy ? treeNode.entity.getName() : treeNode.entity.getId();
            }
        };
    }

    public Function<String, EntityTreeNode> childRetriever(final EntityTreeNode parent) {
        return new Function<String, EntityTreeNode>(){

            @Override
            public EntityTreeNode apply(String identifier) {
                return ImportPolicy.this.isFileImportPolicy ? parent.retrieveChildByName(identifier) : parent.retrieveChildById(identifier);
            }
        };
    }
}

