/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.net.http;

import com.restlet.client.function.Function;
import com.restlet.client.function.Predicate;
import com.restlet.client.net.MessageHeaderTo;
import com.restlet.client.net.http.request.HttpRequestTo;
import com.restlet.client.net.http.response.HttpResponseTo;
import com.restlet.client.net.request.RequestHeaderTo;
import com.restlet.client.utils.Maybe;
import com.restlet.client.utils.NotNull;
import com.restlet.client.utils.Nullable;
import com.restlet.client.utils.Objects;
import com.restlet.client.utils.Sequence;
import com.restlet.client.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class HeaderUtils {
    public static final String HEADER_HOST_NAME = "Host";
    public static final String HEADER_CONTENT_TYPE_NAME = "Content-Type";
    public static final String MEDIA_TYPE_MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String MEDIA_TYPE_WEB_FORM = "application/x-www-form-urlencoded";
    public static final String MEDIA_TYPE_JSON = "application/json";
    private static final Function<String, String> GET_HEADER_MAIN_VALUE = new Function<String, String>(){

        @Override
        public String apply(String headerFullValue) {
            return headerFullValue != null ? headerFullValue.split(";")[0].trim() : null;
        }
    };
    private static final Function<MessageHeaderTo, String> GET_HEADER_VALUE = new Function<MessageHeaderTo, String>(){

        @Override
        public String apply(MessageHeaderTo header) {
            return header.getValue();
        }
    };
    private static final Function<RequestHeaderTo, String> GET_REQUEST_HEADER_VALUE = new Function<RequestHeaderTo, String>(){

        @Override
        public String apply(RequestHeaderTo header) {
            return header.getValue();
        }
    };

    public static String findMessageHeaderValue(@NotNull List<MessageHeaderTo> headers, @Nullable String headerName) {
        if (headers != null) {
            for (MessageHeaderTo header : headers) {
                if (!HeaderUtils.areEqualHeaderNames(header.getName(), headerName)) continue;
                return header.getValue();
            }
        }
        return null;
    }

    public static List<String> findHeaderValue(@NotNull List<MessageHeaderTo> headers, @Nullable String headerName) {
        return Sequence.of(headers).filter(HeaderUtils.newPredicateIsHeaderNameEqualTo(headerName)).map(new Function<MessageHeaderTo, String>(){

            @Override
            public String apply(MessageHeaderTo header) {
                return header.getValue();
            }
        }).toList();
    }

    public static boolean hasHeader(@NotNull List<RequestHeaderTo> headers, String headerName, boolean enabled, boolean generated) {
        for (RequestHeaderTo header : headers) {
            if (!HeaderUtils.areEqualHeaderNames(header.getName(), headerName) || enabled != header.isEnabled() || generated != header.isDefault()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasHeader(@NotNull List<RequestHeaderTo> headers, String headerName, boolean enabled) {
        for (RequestHeaderTo header : headers) {
            if (!HeaderUtils.areEqualHeaderNames(header.getName(), headerName) || enabled != header.isEnabled()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static List<RequestHeaderTo> replaceOrAddHeader(@NotNull List<RequestHeaderTo> headers, @NotNull RequestHeaderTo newHeader) {
        ArrayList<RequestHeaderTo> returnValue = new ArrayList<RequestHeaderTo>();
        boolean headerUnset = true;
        for (RequestHeaderTo currentHeader : headers) {
            if (headerUnset && HeaderUtils.areEqualHeaders(currentHeader, newHeader)) {
                newHeader.setEnabled(currentHeader.isEnabled());
                returnValue.add(newHeader);
                headerUnset = false;
                continue;
            }
            returnValue.add(currentHeader);
        }
        if (!headerUnset) {
            return returnValue;
        }
        returnValue = new ArrayList();
        for (RequestHeaderTo currentHeader : headers) {
            if (headerUnset && currentHeader.isEnabled() && StringUtils.isBlank(currentHeader.getName()) && StringUtils.isBlank(currentHeader.getValue())) {
                returnValue.add(newHeader);
                headerUnset = false;
                continue;
            }
            returnValue.add(currentHeader);
        }
        if (!headerUnset) {
            return returnValue;
        }
        returnValue.add(newHeader);
        return returnValue;
    }

    @NotNull
    public static List<RequestHeaderTo> removeHeader(@NotNull List<RequestHeaderTo> headers, @NotNull RequestHeaderTo newHeader) {
        ArrayList<RequestHeaderTo> returnValue = new ArrayList<RequestHeaderTo>();
        for (RequestHeaderTo header : headers) {
            if (HeaderUtils.areEqualHeaders(header, newHeader)) continue;
            returnValue.add(header);
        }
        return returnValue;
    }

    public static boolean isContentTypeHeader(MessageHeaderTo header) {
        return !StringUtils.isBlank(header.getName()) && HEADER_CONTENT_TYPE_NAME.equalsIgnoreCase(header.getName().trim());
    }

    public static boolean isHostHeader(MessageHeaderTo header) {
        return !StringUtils.isBlank(header.getName()) && HEADER_HOST_NAME.equalsIgnoreCase(header.getName().trim());
    }

    private static boolean areEqualHeaders(@Nullable RequestHeaderTo first, @Nullable RequestHeaderTo second) {
        String secondName;
        if (Objects.equals(first, second)) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        String firstName = first.getName();
        return HeaderUtils.areEqualHeaderNames(firstName, secondName = second.getName()) && (first.isDefault() == second.isDefault() || first.isEnabled() == second.isEnabled());
    }

    private static boolean areEqualHeaderNames(@Nullable String firstHeaderName, @Nullable String secondHeaderName) {
        return Objects.equals(firstHeaderName, secondHeaderName) || firstHeaderName != null && secondHeaderName != null && firstHeaderName.trim().equalsIgnoreCase(secondHeaderName.trim());
    }

    private static Predicate<RequestHeaderTo> newPredicateIsRequestHeaderNameEqualTo(final String headerName) {
        return new Predicate<RequestHeaderTo>(){

            @Override
            public boolean test(RequestHeaderTo header) {
                return HeaderUtils.areEqualHeaderNames(header.getName(), headerName) && header.isEnabled();
            }
        };
    }

    private static Predicate<MessageHeaderTo> newPredicateIsHeaderNameEqualTo(final String headerName) {
        return new Predicate<MessageHeaderTo>(){

            @Override
            public boolean test(MessageHeaderTo header) {
                return HeaderUtils.areEqualHeaderNames(header.getName(), headerName);
            }
        };
    }

    public static List<String> findHeaderValue(HttpRequestTo requestTo, String headerName) {
        return Sequence.of(requestTo.getHeaders()).filter(HeaderUtils.newPredicateIsRequestHeaderNameEqualTo(headerName)).map(GET_REQUEST_HEADER_VALUE).toList();
    }

    public static Maybe<String> get(List<MessageHeaderTo> headers, String headerName) {
        return Sequence.of(headers).filter(HeaderUtils.newPredicateIsHeaderNameEqualTo(headerName)).map(GET_HEADER_VALUE).first();
    }

    public static List<MessageHeaderTo> toMessageHeaderTo(List<RequestHeaderTo> headers) {
        return Sequence.of(headers).map(new Function<RequestHeaderTo, MessageHeaderTo>(){

            @Override
            public MessageHeaderTo apply(RequestHeaderTo input) {
                return input;
            }
        }).toList();
    }

    public static Maybe<String> getContentTypeMainValue(List<MessageHeaderTo> headers) {
        return HeaderUtils.get(headers, HEADER_CONTENT_TYPE_NAME).map(GET_HEADER_MAIN_VALUE);
    }

    public static Maybe<String> getContentTypeMainValue(String headerValue) {
        return Maybe.ofNullable(headerValue).map(GET_HEADER_MAIN_VALUE);
    }

    public static Maybe<String> getContentTypeMainValue(HttpRequestTo requestTo) {
        return HeaderUtils.getContentTypeHeader(requestTo).map(GET_REQUEST_HEADER_VALUE).map(GET_HEADER_MAIN_VALUE);
    }

    public static Maybe<RequestHeaderTo> getContentTypeHeader(HttpRequestTo requestTo) {
        return HeaderUtils.getHeader(requestTo, HEADER_CONTENT_TYPE_NAME);
    }

    public static Maybe<MessageHeaderTo> getContentTypeHeader(HttpResponseTo responseTo) {
        return Sequence.of(responseTo.getHeaders()).filter(HeaderUtils.newPredicateIsHeaderNameEqualTo(HEADER_CONTENT_TYPE_NAME)).first();
    }

    public static Maybe<RequestHeaderTo> getHeader(@NotNull HttpRequestTo requestTo, String headerName) {
        return Sequence.of(requestTo.getHeaders()).filter(HeaderUtils.newPredicateIsRequestHeaderNameEqualTo(headerName)).first();
    }
}

