/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.net.http;

import java.util.Arrays;
import java.util.List;

public enum HttpStatusCodeRange {
    ZERO(0),
    ONE_HUNDRED(100, 199),
    TWO_HUNDRED(200, 299),
    THREE_HUNDRED(300, 399),
    FOUR_HUNDRED(400, 499),
    FIVE_HUNDRED(500, 599);

    public static final List<HttpStatusCodeRange> TESTING_VIEW_CODE_RANGES;
    public static final List<HttpStatusCodeRange> REQUESTS_VIEW_CODE_RANGES;
    public final int min;
    public final int max;

    private HttpStatusCodeRange(int value) {
        this(value, value);
    }

    private HttpStatusCodeRange(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public boolean contains(int value) {
        return value >= this.min & value <= this.max;
    }

    static {
        TESTING_VIEW_CODE_RANGES = Arrays.asList(ONE_HUNDRED, TWO_HUNDRED, THREE_HUNDRED, FOUR_HUNDRED, FIVE_HUNDRED);
        REQUESTS_VIEW_CODE_RANGES = Arrays.asList(ONE_HUNDRED, TWO_HUNDRED, THREE_HUNDRED);
    }
}

