/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.net.http.request.impl;

import com.restlet.client.net.MessageHeaderTo;
import com.restlet.client.net.http.HttpClientException;
import com.restlet.client.net.uri.UriUtils;
import java.util.List;

public class HttpRequest {
    private String host = null;
    private boolean ip6 = false;
    private int peerPort = -1;
    private boolean secure;
    private String method;
    private String absolutePath;
    private List<MessageHeaderTo> headers;

    public static HttpRequest parse(String uri) throws HttpClientException {
        HttpRequest request = new HttpRequest();
        String authorityAndPath = null;
        int peerPort = 80;
        boolean secure = false;
        if (UriUtils.isHttp(uri)) {
            authorityAndPath = uri.substring("http://".length()).trim();
            secure = false;
            peerPort = 80;
            HttpRequest.parseAuthorityAndPath(request, authorityAndPath);
        } else if (UriUtils.isHttps(uri)) {
            authorityAndPath = uri.substring("https://".length()).trim();
            peerPort = 443;
            secure = true;
            HttpRequest.parseAuthorityAndPath(request, authorityAndPath);
        }
        if (request.getPeerAddress() == null) {
            request.setPeerAddress(authorityAndPath);
        }
        if (request.getPeerPort() == -1) {
            request.setPeerPort(peerPort);
        }
        request.setSecure(secure);
        return request;
    }

    private static void parseAuthorityAndPath(HttpRequest request, String authorityAndPath) throws HttpClientException {
        if (authorityAndPath.indexOf(47) != -1) {
            request.absolutePath = authorityAndPath.substring(authorityAndPath.indexOf(47));
            HttpRequest.parseHostAndPort(request, authorityAndPath.substring(0, authorityAndPath.indexOf(47)).trim());
        } else {
            request.absolutePath = "/";
            HttpRequest.parseHostAndPort(request, authorityAndPath);
        }
    }

    private static void parseHostAndPort(HttpRequest request, String authority) throws HttpClientException {
        int i;
        if (authority.startsWith("[") && (i = authority.indexOf("]")) != -1) {
            request.ip6 = true;
            request.setPeerAddress(authority.substring(1, i));
            String host = authority.substring(i + 1).trim();
            if (host.startsWith(":")) {
                try {
                    int port = Integer.parseInt(host.substring(1).trim());
                    request.setPeerPort(port);
                    return;
                }
                catch (NumberFormatException e) {
                    throw new HttpClientException("Invalid port " + host.substring(1).trim());
                }
            }
            return;
        }
        i = authority.indexOf(58);
        if (i != -1) {
            request.setPeerAddress(authority.substring(0, i));
            try {
                int port = Integer.valueOf(authority.substring(i + 1).trim());
                request.setPeerPort(port);
            }
            catch (NumberFormatException e) {
                throw new HttpClientException("Invalid port " + authority.substring(i + 1).trim());
            }
        } else {
            request.setPeerAddress(authority);
        }
    }

    public String getPeerAddress() {
        return this.host;
    }

    public void setPeerAddress(String peerAddress) {
        this.host = peerAddress;
    }

    public int getPeerPort() {
        return this.peerPort;
    }

    public void setPeerPort(int peerPort) {
        this.peerPort = peerPort;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String name) {
        this.method = name;
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public List<MessageHeaderTo> getHeaders() {
        return this.headers;
    }

    public void setHeaders(List<MessageHeaderTo> headers) {
        this.headers = headers;
    }

    public boolean isIp6() {
        return this.ip6;
    }
}

