/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.net.uri;

import com.restlet.client.function.BiConsumer;
import com.restlet.client.function.Predicate;
import com.restlet.client.net.http.HttpClientException;
import com.restlet.client.net.http.request.impl.HttpRequest;
import com.restlet.client.net.uri.UriQueryParamTo;
import com.restlet.client.net.uri.UriSchemeTo;
import com.restlet.client.net.uri.UriTo;
import com.restlet.client.net.uri.impl.UriSchemeToImpl;
import com.restlet.client.utils.Maybe;
import com.restlet.client.utils.Sequence;
import com.restlet.client.utils.StringUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class UriUtils {
    public static final String HTTP_SCHEME_AS_STRING = "http";
    public static final String HTTPS_SCHEME_AS_STRING = "https";
    private static final String LOCAL_IPV6_ADDRESS = "::1";
    private static final Set<String> LOCAL_IPV4_ADDRESSES = new HashSet<String>(Arrays.asList("localhost", "127.0.0.1", "0.0.0.0"));

    public static String appendQuery(String url, String query) {
        if (!StringUtils.isBlank(url)) {
            int qindex;
            String fragment = "";
            int findex = url.indexOf(35);
            if (findex != -1) {
                fragment = url.substring(findex);
                url = url.substring(0, findex);
            }
            url = (qindex = url.indexOf(63)) != -1 ? url + "&" + query + fragment : url + "?" + query + fragment;
            return url;
        }
        if (!StringUtils.isBlank(query)) {
            return query.startsWith("?") ? query : "?".concat(query);
        }
        return "?";
    }

    public static String replaceQuery(String url, String query) {
        if (!StringUtils.isBlank(url)) {
            int qindex;
            String fragment = "";
            int findex = url.indexOf(35);
            if (findex != -1) {
                fragment = url.substring(findex);
                url = url.substring(0, findex);
            }
            if ((qindex = url.indexOf(63)) != -1) {
                url = url.substring(0, qindex);
            }
            if (!StringUtils.isBlank(query) && !"?".equals(query)) {
                url = query.startsWith("?") ? url.concat(query) : url.concat("?").concat(query);
            }
            return url + fragment;
        }
        if (!StringUtils.isBlank(query)) {
            return query.startsWith("?") ? query : "?".concat(query);
        }
        return null;
    }

    public static String replaceAbsolutePath(String url, String path) {
        if (!StringUtils.isBlank(url)) {
            int index = url.indexOf(47);
            if (index == -1) {
                return !StringUtils.isBlank(path) ? url.concat(path) : url;
            }
            url = url.substring(0, index);
            return !StringUtils.isBlank(path) ? url.concat(path) : url;
        }
        return path;
    }

    public static String replaceRelativePath(String url, String path) {
        if (!StringUtils.isBlank(url)) {
            int index = url.lastIndexOf(47);
            if (index == -1) {
                return !StringUtils.isBlank(path) ? url.concat("/").concat(path) : url;
            }
            url = url.substring(0, index).concat("/");
            return !StringUtils.isBlank(path) ? url.concat(path) : url;
        }
        return path;
    }

    public static String printUri(UriTo uri, SchemePrintOption schemePrintOption) {
        if (uri == null) {
            return "";
        }
        final StringBuilder uriAsString = new StringBuilder();
        String path = uri.getPath();
        if (schemePrintOption == SchemePrintOption.PRINT_SCHEME && uri.getScheme() != null || schemePrintOption == SchemePrintOption.PRINT_SCHEME_DEFAULT) {
            uriAsString.append((uri.getScheme() == null ? UriSchemeToImpl.DEFAULT_SCHEME.getName() : uri.getScheme().getName()).toLowerCase());
            if (StringUtils.isBlank(path) || !path.startsWith("://")) {
                uriAsString.append("://");
            }
        }
        uriAsString.append(Maybe.ofNullable(uri.getHost()).orElse("")).append(Maybe.ofNullable(path).orElse(""));
        if (uri.getQuery() != null) {
            Sequence.of(uri.getQuery().getItems()).filter(new Predicate<UriQueryParamTo>(){

                @Override
                public boolean test(UriQueryParamTo value) {
                    return value.isEnabled();
                }
            }).each(new BiConsumer<UriQueryParamTo, Integer>(){

                @Override
                public void consume(UriQueryParamTo queryParameter, Integer index) {
                    uriAsString.append(index == 0 ? "?" : "&");
                    if (!StringUtils.isBlank(queryParameter.getName())) {
                        uriAsString.append(queryParameter.getName());
                    }
                    if (!StringUtils.isBlank(queryParameter.getValue())) {
                        uriAsString.append("=").append(queryParameter.getValue());
                    }
                }
            });
        }
        if (uri.getFragment() != null) {
            uriAsString.append("#").append(uri.getFragment());
        }
        return uriAsString.toString();
    }

    public static String extractHostPort(String path) {
        if (path == null || path.trim().isEmpty()) {
            return path;
        }
        int i = path.indexOf(47);
        if (i == -1 && (i = path.indexOf(63)) == -1) {
            i = path.indexOf(35);
        }
        if (i != -1) {
            return path.substring(0, i).trim();
        }
        return path;
    }

    public static String printScheme(UriSchemeTo scheme) {
        if (scheme == null) {
            return "";
        }
        if ("V11".equals(scheme.getVersion())) {
            return scheme.getName().toUpperCase() + "/1.1";
        }
        if ("V11".equals(scheme.getVersion())) {
            return scheme.getName().toUpperCase() + "/1.0";
        }
        if ("V09".equals(scheme.getVersion())) {
            // empty if block
        }
        return "";
    }

    public static String addProtocolIfMissing(String path) {
        String url = path;
        String lowerCaseUrl = path.trim().toLowerCase();
        if (lowerCaseUrl.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        if (!UriUtils.isHttp(lowerCaseUrl) && !UriUtils.isHttps(lowerCaseUrl)) {
            url = "http://" + url;
        }
        return url;
    }

    public static String getAbsolutePath(UriTo uri) {
        StringBuilder sb = new StringBuilder();
        if (uri.getScheme() == null) {
            sb.append(HTTP_SCHEME_AS_STRING);
        } else {
            sb.append(uri.getScheme().getName());
        }
        sb.append("://");
        if (!StringUtils.isBlank(uri.getHost())) {
            sb.append(uri.getHost());
        }
        if (!StringUtils.isBlank(uri.getPath())) {
            sb.append(uri.getPath());
        }
        return sb.toString();
    }

    public static boolean isHttp(String uri) {
        return !StringUtils.isBlank(uri) && uri.trim().toLowerCase().startsWith("http://");
    }

    public static boolean isHttps(String uri) {
        return !StringUtils.isBlank(uri) && uri.trim().toLowerCase().startsWith("https://");
    }

    public static boolean isHttpOrHttps(String uri) {
        return UriUtils.isHttp(uri) || UriUtils.isHttps(uri);
    }

    public static boolean isMailto(String uri) {
        return !StringUtils.isBlank(uri) && uri.trim().toLowerCase().startsWith("mailto:");
    }

    public static boolean isJavascript(String uri) {
        return !StringUtils.isBlank(uri) && uri.trim().toLowerCase().startsWith("javascript:");
    }

    public static void ensureSchemeIsSet(UriTo requestUri) {
        String stringUri = UriUtils.printUri(requestUri, SchemePrintOption.DONT_PRINT_SCHEME);
        if (UriUtils.isHttp(stringUri) || UriUtils.isHttps(stringUri)) {
            if (UriUtils.isHttps(requestUri.getHost())) {
                requestUri.setScheme(UriSchemeToImpl.valueOf(HTTPS_SCHEME_AS_STRING));
                requestUri.setHost(requestUri.getHost().substring("https://".length()));
                return;
            }
            if (UriUtils.isHttp(requestUri.getHost())) {
                requestUri.setScheme(UriSchemeToImpl.valueOf(HTTP_SCHEME_AS_STRING));
                requestUri.setHost(requestUri.getHost().substring("http://".length()));
                return;
            }
            if (UriUtils.isHttps(requestUri.getPath())) {
                requestUri.setScheme(UriSchemeToImpl.valueOf(HTTPS_SCHEME_AS_STRING));
                requestUri.setPath(requestUri.getPath().substring("https://".length()));
            } else if (UriUtils.isHttp(requestUri.getPath())) {
                requestUri.setScheme(UriSchemeToImpl.valueOf(HTTP_SCHEME_AS_STRING));
                requestUri.setPath(requestUri.getPath().substring("http://".length()));
            }
        } else if (requestUri.getScheme() == null) {
            requestUri.setScheme(UriSchemeToImpl.valueOf(HTTP_SCHEME_AS_STRING));
        }
    }

    public static boolean isLoopbackAddress(UriTo uri) {
        if (uri == null || StringUtils.isBlank(uri.getHost())) {
            return false;
        }
        String uriString = UriUtils.printUri(uri, SchemePrintOption.PRINT_SCHEME);
        try {
            HttpRequest request = HttpRequest.parse(uriString.trim());
            if (request.isIp6()) {
                String[] groups = request.getPeerAddress().split(":");
                for (int i = 0; i < groups.length; ++i) {
                    groups[i] = StringUtils.trimLeft(groups[i], '0');
                }
                return LOCAL_IPV6_ADDRESS.equals(StringUtils.joiner(groups).joinWith(":"));
            }
            return LOCAL_IPV4_ADDRESSES.contains(request.getPeerAddress());
        }
        catch (HttpClientException e) {
            return false;
        }
    }

    public static enum SchemePrintOption {
        PRINT_SCHEME(true, true, false),
        PRINT_SCHEME_DEFAULT(true, true, true),
        DONT_PRINT_SCHEME(false, true, false),
        DONT_PRINT_HOST(false, false, false);

        public final boolean shouldPrintScheme;
        public final boolean shouldPrintHost;
        public final boolean shouldPrintDefaultSchemeIfNull;

        private SchemePrintOption(boolean shouldPrintScheme, boolean shouldPrintHost, boolean shouldPrintDefaultSchemeIfNull) {
            this.shouldPrintScheme = shouldPrintScheme;
            this.shouldPrintHost = shouldPrintHost;
            this.shouldPrintDefaultSchemeIfNull = shouldPrintDefaultSchemeIfNull;
        }
    }
}

