/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.net.uri.impl;

import com.restlet.client.function.Predicate;
import com.restlet.client.net.http.request.HttpVersion;
import com.restlet.client.net.uri.UriSchemeTo;
import com.restlet.client.utils.Objects;
import com.restlet.client.utils.Sequence;
import com.restlet.client.utils.StringUtils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

public class UriSchemeToImpl
implements UriSchemeTo,
Serializable {
    public static final UriSchemeTo HTTPS_SCHEME = new UriSchemeToImpl("https", HttpVersion.V11, true);
    public static final UriSchemeTo HTTP_SCHEME;
    public static final UriSchemeTo DEFAULT_SCHEME;
    private static final List<UriSchemeTo> SUPPORTED_SCHEME;
    private static final long serialVersionUID = 5786500393808068720L;
    private boolean secure;
    private String version;
    private String name;

    public UriSchemeToImpl() {
        this(null, null, false);
    }

    public UriSchemeToImpl(String name, HttpVersion version, boolean secure) {
        this.name = name;
        this.secure = secure;
        this.version = version == null ? null : version.name();
    }

    public static UriSchemeTo valueOf(String value) {
        if (StringUtils.isBlank(value)) {
            return null;
        }
        if ("http".equalsIgnoreCase(value)) {
            return HTTP_SCHEME;
        }
        if ("https".equalsIgnoreCase(value)) {
            return HTTPS_SCHEME;
        }
        return null;
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static boolean isSupportedScheme(final String schemeName) {
        return Sequence.of(SUPPORTED_SCHEME).some(new Predicate<UriSchemeTo>(){

            @Override
            public boolean test(UriSchemeTo uriSchemeTo) {
                return Objects.equals(schemeName, uriSchemeTo.getName());
            }
        });
    }

    public static boolean isSupportedScheme(UriSchemeTo scheme) {
        return scheme != null && UriSchemeToImpl.isSupportedScheme(scheme.getName());
    }

    static {
        DEFAULT_SCHEME = HTTP_SCHEME = new UriSchemeToImpl("http", HttpVersion.V11, false);
        SUPPORTED_SCHEME = Arrays.asList(HTTP_SCHEME, HTTPS_SCHEME);
    }
}

