/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.platform.json;

import com.restlet.client.platform.json.JsonArray;
import com.restlet.client.platform.json.JsonArrayImpl;
import com.restlet.client.platform.json.JsonBoolean;
import com.restlet.client.platform.json.JsonBooleanImpl;
import com.restlet.client.platform.json.JsonEngine;
import com.restlet.client.platform.json.JsonNull;
import com.restlet.client.platform.json.JsonNumber;
import com.restlet.client.platform.json.JsonNumberImpl;
import com.restlet.client.platform.json.JsonObject;
import com.restlet.client.platform.json.JsonString;
import com.restlet.client.platform.json.JsonStringImpl;
import com.restlet.client.platform.json.JsonValue;
import com.restlet.client.utils.Objects;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class JsonObjectImpl
implements JsonObject {
    private final Map<String, Object> object;
    private final JsonEngine jsonEngine;

    public JsonObjectImpl(JsonEngine jsonEngine) {
        this(new HashMap<String, Object>(), jsonEngine);
    }

    public JsonObjectImpl(Map<String, Object> object, JsonEngine jsonEngine) {
        this.object = object;
        this.jsonEngine = jsonEngine;
    }

    protected static Object unwrap(JsonValue value) {
        if (value == null) {
            return null;
        }
        if (value instanceof JsonObjectImpl) {
            return ((JsonObjectImpl)value).map();
        }
        if (value instanceof JsonString) {
            return ((JsonString)value).stringValue();
        }
        if (value instanceof JsonNumber) {
            return ((JsonNumber)value).doubleValue();
        }
        if (value instanceof JsonArrayImpl) {
            return ((JsonArrayImpl)value).collection();
        }
        if (value instanceof JsonBoolean) {
            return ((JsonBoolean)value).booleanValue();
        }
        if (value instanceof JsonNull) {
            return null;
        }
        return null;
    }

    protected static JsonValue wrap(Object value, JsonEngine jsonEngine) {
        if (value != null) {
            if (value instanceof Map) {
                return new JsonObjectImpl((Map)value, jsonEngine);
            }
            if (value instanceof String) {
                return new JsonStringImpl((String)value);
            }
            if (value instanceof Integer) {
                return new JsonNumberImpl(((Integer)value).intValue());
            }
            if (value instanceof Long) {
                return new JsonNumberImpl(((Long)value).longValue());
            }
            if (value instanceof Float) {
                return new JsonNumberImpl(((Float)value).floatValue());
            }
            if (value instanceof Double) {
                return new JsonNumberImpl((Double)value);
            }
            if (value instanceof Collection) {
                return new JsonArrayImpl((Collection)value, jsonEngine);
            }
            if (value instanceof Boolean) {
                return new JsonBooleanImpl((Boolean)value);
            }
        }
        return null;
    }

    @Override
    public JsonObject isObject() {
        return this;
    }

    @Override
    public JsonArray isArray() {
        return null;
    }

    @Override
    public JsonNull isNull() {
        return null;
    }

    @Override
    public JsonString isString() {
        return null;
    }

    @Override
    public JsonBoolean isBoolean() {
        return null;
    }

    @Override
    public JsonNumber isNumber() {
        return null;
    }

    @Override
    public JsonValue get(String path) {
        return JsonObjectImpl.wrap(this.object.get(path), this.jsonEngine);
    }

    @Override
    public Set<String> keySet() {
        return this.object.keySet();
    }

    @Override
    public boolean containsKey(String key) {
        return this.object.containsKey(key);
    }

    @Override
    public JsonObject put(String name, JsonValue value) {
        this.object.put(name, JsonObjectImpl.unwrap(value));
        return this;
    }

    public Map<String, Object> map() {
        return this.object;
    }

    @Override
    public Integer size() {
        return this.object.size();
    }

    public String toString() {
        if (this.object == null) {
            return "null";
        }
        return this.jsonEngine.toJson(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Objects.equals(this.object, ((JsonObjectImpl)o).object);
    }

    public int hashCode() {
        return this.object.hashCode();
    }
}

