/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.script;

import com.restlet.client.async.Deferred;
import com.restlet.client.async.Promise;
import com.restlet.client.async.PromiseHandler;
import com.restlet.client.async.Promises;
import com.restlet.client.dao.EnvironmentsDao;
import com.restlet.client.dao.RepositoryDao;
import com.restlet.client.function.Consumer;
import com.restlet.client.function.Function;
import com.restlet.client.function.Predicate;
import com.restlet.client.log.LogService;
import com.restlet.client.model.EntityTo;
import com.restlet.client.model.environment.EnvironmentTo;
import com.restlet.client.net.http.request.HttpRequestTo;
import com.restlet.client.net.http.response.HttpResponseTo;
import com.restlet.client.net.response.ResponseBodyTo;
import com.restlet.client.platform.Base64;
import com.restlet.client.platform.CryptoApi;
import com.restlet.client.platform.RandomValueGenerator;
import com.restlet.client.platform.blob.BlobReader;
import com.restlet.client.platform.json.JsonEngine;
import com.restlet.client.script.RepositoryReader;
import com.restlet.client.script.ScriptService;
import com.restlet.client.script.method.Base64Method;
import com.restlet.client.script.method.ConcatMethod;
import com.restlet.client.script.method.HMACMethod;
import com.restlet.client.script.method.HashMethod;
import com.restlet.client.script.method.JsonPathMethod;
import com.restlet.client.script.method.LengthMethod;
import com.restlet.client.script.method.LowerMethod;
import com.restlet.client.script.method.MD5Method;
import com.restlet.client.script.method.RandomNumberMethod;
import com.restlet.client.script.method.StringMethod;
import com.restlet.client.script.method.SubStringMethod;
import com.restlet.client.script.method.TimestampMethod;
import com.restlet.client.script.method.UUIDGeneratorMethod;
import com.restlet.client.script.method.UpperMethod;
import com.restlet.client.script.parser.impl.ScriptParserImpl;
import com.restlet.client.script.parser.token.ScriptToken;
import com.restlet.client.script.parser.token.ScriptTokenType;
import com.restlet.client.script.runtime.ScriptMethod;
import com.restlet.client.script.runtime.ScriptRuntime;
import com.restlet.client.script.runtime.ScriptValue;
import com.restlet.client.script.runtime.impl.RepositoryRecordReference;
import com.restlet.client.script.runtime.impl.RequestContainerJsonReference;
import com.restlet.client.script.runtime.impl.RequestJSONReference;
import com.restlet.client.script.runtime.impl.ResponseJSONReference;
import com.restlet.client.script.value.ScriptJsonValue;
import com.restlet.client.script.value.ScriptNumberValue;
import com.restlet.client.script.value.ScriptStringValue;
import com.restlet.client.utils.BlobUtils;
import com.restlet.client.utils.EnvironmentToHelper;
import com.restlet.client.utils.Holder;
import com.restlet.client.utils.MapBuilder;
import com.restlet.client.utils.Nullable;
import com.restlet.client.utils.Objects;
import com.restlet.client.utils.Sequence;
import com.restlet.client.utils.StringUtils;
import java.util.List;
import java.util.Map;

public class ScriptEvaluator
implements RepositoryReader,
ScriptService,
ScriptRuntime {
    private static final Predicate<ScriptToken> EXPRESSION_TOKEN_FILTER = new Predicate<ScriptToken>(){

        @Override
        public boolean test(ScriptToken token) {
            return token.getType() == ScriptTokenType.Expression;
        }
    };
    private static final Predicate<ScriptToken> LEGACY_CONTENT_OR_NON_EMPTY_STATEMENT_FILTER = new Predicate<ScriptToken>(){

        @Override
        public boolean test(ScriptToken token) {
            return token.getType() == ScriptTokenType.LegacyContext || token.getType() == ScriptTokenType.Statement && !Objects.isNullOrEmpty(token.getChildren());
        }
    };
    private final JsonEngine jsonEngine;
    private final BlobReader blobReader;
    private final LogService logService;
    private final Function<String, Promise<HttpResponseTo>> lastResponseProvider;
    private final Function<ResponseBodyTo, Promise<ResponseBodyTo>> responseBodyProvider;
    private final Map<String, ScriptMethod> methods;

    public ScriptEvaluator(Base64 base64, CryptoApi cryptoApi, JsonEngine jsonEngine, RandomValueGenerator randomValueGenerator, BlobReader blobReader, LogService logService, Function<String, Promise<HttpResponseTo>> lastResponseProvider, Function<ResponseBodyTo, Promise<ResponseBodyTo>> responseBodyProvider) {
        this.jsonEngine = jsonEngine;
        this.blobReader = blobReader;
        this.logService = logService;
        this.lastResponseProvider = lastResponseProvider;
        this.responseBodyProvider = responseBodyProvider;
        this.methods = MapBuilder.builder().put("random", new RandomNumberMethod(randomValueGenerator)).put("uuid", (RandomNumberMethod)((Object)new UUIDGeneratorMethod(jsonEngine))).put("jsonPath", (RandomNumberMethod)((Object)new JsonPathMethod(jsonEngine))).put("string", (RandomNumberMethod)((Object)new StringMethod(jsonEngine))).put("substring", (RandomNumberMethod)((Object)new SubStringMethod(jsonEngine, logService))).put("base64", (RandomNumberMethod)((Object)new Base64Method(base64, jsonEngine))).put("md5", (RandomNumberMethod)((Object)new MD5Method(cryptoApi, jsonEngine))).put("hmac", (RandomNumberMethod)((Object)new HMACMethod(cryptoApi, jsonEngine, logService))).put("concat", (RandomNumberMethod)((Object)new ConcatMethod(jsonEngine))).put("lower", (RandomNumberMethod)((Object)new LowerMethod(jsonEngine))).put("upper", (RandomNumberMethod)((Object)new UpperMethod(jsonEngine))).put("timestamp", (RandomNumberMethod)((Object)new TimestampMethod())).put("length", (RandomNumberMethod)((Object)new LengthMethod(jsonEngine))).put("size", (RandomNumberMethod)((Object)new LengthMethod(jsonEngine))).put("sha", (RandomNumberMethod)((Object)new HashMethod(cryptoApi, jsonEngine, logService))).build();
    }

    @Override
    public ScriptMethod getMethod(String name) {
        return this.methods.get(name.trim());
    }

    @Override
    public Promise<Void> restore() {
        return Promises.of();
    }

    @Override
    public Promise<Void> suspend() {
        return Promises.of();
    }

    @Override
    public Promise<String> evaluate(final String expression, EnvironmentsDao environmentsDao, RepositoryDao repositoryDao) {
        if (StringUtils.isBlank(expression)) {
            return Promises.of(expression);
        }
        final List<ScriptToken> tokens = new ScriptParserImpl().parse(expression);
        return this.evaluateTokens(tokens, environmentsDao, repositoryDao).map(new Function<List<ScriptValue>, String>(){

            @Override
            public String apply(List<ScriptValue> values) {
                return ScriptEvaluator.this.buildExpressionResultFromTokensAndValues(expression, tokens, values);
            }
        }).recoverOnReject((String)((Object)new PromiseHandler<Throwable>(){

            @Override
            public Object on(@Nullable Throwable error) {
                ScriptEvaluator.this.logService.error(error.getMessage(), error);
                return expression;
            }
        }));
    }

    @Override
    public Promise<ScriptValue> getVariable(final String path, final EnvironmentsDao environmentsDao, final RepositoryDao repositoryDao) {
        if (StringUtils.isBlank(path)) {
            return Promises.of();
        }
        return environmentsDao.readSelected().flatMap(new Function<EnvironmentTo, Promise<ScriptValue>>(){

            @Override
            public Promise<ScriptValue> apply(EnvironmentTo selectedEnvironment) {
                String computedValue;
                if (selectedEnvironment == null || (computedValue = EnvironmentToHelper.expandVariables(selectedEnvironment.getVariables(), path)) == null) {
                    return ScriptEvaluator.this.readFromRepo(path, null, repositoryDao, environmentsDao);
                }
                ScriptStringValue scriptStringValue = new ScriptStringValue(computedValue, ScriptEvaluator.this.jsonEngine);
                return Promises.of(scriptStringValue);
            }
        }).recoverOnReject((ScriptValue)((Object)new PromiseHandler<Throwable>(){

            @Override
            public Object on(@Nullable Throwable error) {
                return null;
            }
        }));
    }

    private Promise<List<ScriptValue>> evaluateTokens(List<ScriptToken> tokens, final EnvironmentsDao environmentsDao, final RepositoryDao repositoryDao) {
        if (Objects.isNullOrEmpty(tokens)) {
            return Promises.of();
        }
        List tokensResolution = Sequence.of(tokens).omitNulls().filter(EXPRESSION_TOKEN_FILTER).flatMap(new Function<ScriptToken, Iterable<Promise<ScriptValue>>>(){

            @Override
            public Iterable<Promise<ScriptValue>> apply(final ScriptToken token) {
                return Sequence.of(token.getChildren()).omitNulls().filter(LEGACY_CONTENT_OR_NON_EMPTY_STATEMENT_FILTER).map(new Function<ScriptToken, Promise<ScriptValue>>(){

                    @Override
                    public Promise<ScriptValue> apply(ScriptToken part) {
                        if (part.getType() == ScriptTokenType.LegacyContext) {
                            return ScriptEvaluator.this.getVariable(part.getValue(), environmentsDao, repositoryDao).doOnResolve(ScriptEvaluator.this.tokenValueSetter(token));
                        }
                        return ScriptEvaluator.this.evaluateStatement(part, environmentsDao, repositoryDao).doOnResolve(ScriptEvaluator.this.tokenValueSetter(token));
                    }
                }).toList();
            }
        }).toList();
        return Promises.all(tokensResolution);
    }

    private Consumer<ScriptValue> tokenValueSetter(final ScriptToken token) {
        return new Consumer<ScriptValue>(){

            @Override
            public void consume(ScriptValue value) {
                token.setValue(value != null ? value.toString() : null);
            }
        };
    }

    private Promise<ScriptValue> evaluateStatement(ScriptToken statement, final EnvironmentsDao environmentsDao, final RepositoryDao repositoryDao) {
        if (statement == null || Objects.isNullOrEmpty(statement.getChildren())) {
            return Promises.of();
        }
        List<ScriptToken> statementParts = Sequence.of(statement.getChildren()).omitNulls().toList();
        Promise<ScriptValue> promise = this.doStatementItem(statementParts.iterator().next(), environmentsDao, repositoryDao);
        if (promise == null) {
            return Promises.of();
        }
        block5: for (int i = 1; i < statementParts.size(); ++i) {
            final ScriptToken nextItem = statement.getChildren().get(i);
            switch (nextItem.getType()) {
                case String: 
                case Reference: {
                    promise = promise.flatMap(new Function<ScriptValue, Promise<ScriptValue>>(){

                        @Override
                        public Promise<ScriptValue> apply(ScriptValue scriptValue) {
                            if (scriptValue == null) {
                                return Promises.of();
                            }
                            return scriptValue.select(nextItem.getValue());
                        }
                    });
                    continue block5;
                }
                case IndexReference: {
                    promise = promise.flatMap(new Function<ScriptValue, Promise<ScriptValue>>(){

                        @Override
                        public Promise<ScriptValue> apply(ScriptValue previousValue) {
                            return previousValue == null ? Promises.of() : previousValue.select(nextItem.getValue());
                        }
                    }).flatMap(this.resolveChildrenScriptValues(nextItem, environmentsDao, repositoryDao));
                    continue block5;
                }
                case Method: {
                    final ScriptMethod method = this.getMethod(nextItem.getValue());
                    if (method == null) {
                        return Promises.of();
                    }
                    promise = promise.flatMap(new Function<ScriptValue, Promise<ScriptValue>>(){

                        @Override
                        public Promise<ScriptValue> apply(ScriptValue prevValue) {
                            if (prevValue == null) {
                                return Promises.of();
                            }
                            return ScriptEvaluator.this.executeMethod(method, prevValue, nextItem, environmentsDao, repositoryDao);
                        }
                    });
                    continue block5;
                }
                default: {
                    return Promises.of();
                }
            }
        }
        if (promise == null) {
            return Promises.of();
        }
        return promise;
    }

    private Promise<ScriptValue> doStatementItem(final ScriptToken scriptToken, EnvironmentsDao environmentsDao, RepositoryDao repositoryDao) {
        if (scriptToken == null) {
            return Promises.of();
        }
        if (scriptToken.getType() == ScriptTokenType.Number) {
            try {
                ScriptNumberValue value = new ScriptNumberValue(Long.valueOf(scriptToken.getValue()));
                return Promises.of(value);
            }
            catch (NumberFormatException ignored) {
                this.logService.error(StringUtils.format("Provided number %s is not a valid long", scriptToken.getValue()), ignored);
            }
        }
        switch (scriptToken.getType()) {
            case String: 
            case Number: {
                return this.getVariable(scriptToken.getValue(), environmentsDao, repositoryDao).map(new Function<ScriptValue, ScriptValue>(){

                    @Override
                    public ScriptValue apply(ScriptValue originalValue) {
                        return originalValue == null ? new ScriptStringValue(scriptToken.getValue(), ScriptEvaluator.this.jsonEngine) : originalValue;
                    }
                });
            }
            case Reference: {
                return this.getVariable(scriptToken.getValue(), environmentsDao, repositoryDao);
            }
            case IndexReference: {
                return this.getVariable(scriptToken.getValue(), environmentsDao, repositoryDao).flatMap(this.resolveChildrenScriptValues(scriptToken, environmentsDao, repositoryDao));
            }
            case Method: {
                ScriptMethod method = this.getMethod(scriptToken.getValue());
                if (method == null) break;
                return this.executeMethod(method, null, scriptToken, environmentsDao, repositoryDao);
            }
        }
        return null;
    }

    private Function<ScriptValue, Promise<ScriptValue>> resolveChildrenScriptValues(final ScriptToken scriptToken, final EnvironmentsDao environmentsDao, final RepositoryDao repositoryDao) {
        return new Function<ScriptValue, Promise<ScriptValue>>(){

            @Override
            public Promise<ScriptValue> apply(ScriptValue value) {
                if (value == null) {
                    return null;
                }
                Promise<ScriptValue> promise = Promises.of(value);
                if (!Objects.isNullOrEmpty(scriptToken.getChildren())) {
                    for (ScriptToken token : scriptToken.getChildren()) {
                        final Holder previousChildrenTokenValue = Holder.empty();
                        promise = promise.assignTo(previousChildrenTokenValue).flatMap(ScriptEvaluator.this.evaluateStatement(token, environmentsDao, repositoryDao).doOnResolve(ScriptEvaluator.this.tokenValueSetter(token))).flatMap(new Function<ScriptValue, Promise<ScriptValue>>(){

                            @Override
                            public Promise<ScriptValue> apply(ScriptValue input) {
                                if (input == null) {
                                    return Promises.of(previousChildrenTokenValue.value);
                                }
                                return ((ScriptValue)previousChildrenTokenValue.value).select(input.toString());
                            }
                        });
                    }
                }
                return promise;
            }
        };
    }

    @Override
    public Promise<ScriptValue> readFromRepo(String path, EntityTo parent, final RepositoryDao repositoryDao, final EnvironmentsDao environmentsDao) {
        if (StringUtils.isBlank(path)) {
            return Promises.of();
        }
        return repositoryDao.find(path, parent).flatMap(new Function<EntityTo, Promise<ScriptValue>>(){

            @Override
            public Promise<ScriptValue> apply(EntityTo entity) {
                if (entity == null) {
                    return Promises.of();
                }
                switch (entity.getType()) {
                    case Project: 
                    case Service: 
                    case Scenario: {
                        RepositoryRecordReference reference = new RepositoryRecordReference(ScriptEvaluator.this, entity, environmentsDao, repositoryDao);
                        return Promises.of(reference);
                    }
                    case Request: {
                        final RequestContainerJsonReference requestContainerJsonReference = new RequestContainerJsonReference(ScriptEvaluator.this.jsonEngine.newJsonObject(), ScriptEvaluator.this.jsonEngine);
                        requestContainerJsonReference.setName(entity.getName());
                        Promise lastResponse = (Promise)ScriptEvaluator.this.lastResponseProvider.apply(entity.getId());
                        if (lastResponse == null) {
                            ScriptJsonValue scriptJsonValue = new ScriptJsonValue(requestContainerJsonReference.asJSON(), ScriptEvaluator.this.jsonEngine);
                            return Promises.of(scriptJsonValue);
                        }
                        final Holder responseReferenceHolder = Holder.empty();
                        HttpRequestTo requestTo = (HttpRequestTo)entity;
                        return RequestJSONReference.create(ScriptEvaluator.this.jsonEngine, ScriptEvaluator.this, environmentsDao, repositoryDao, requestTo.getMethod(), requestTo.getHeaders(), requestTo.getUri(), requestTo.getBody()).doOnResolve(new Consumer<RequestJSONReference>(){

                            @Override
                            public void consume(RequestJSONReference requestJsonReference) {
                                requestContainerJsonReference.setRequest(requestJsonReference);
                            }
                        }).flatMap(lastResponse).flatMap(new Function<HttpResponseTo, Promise<ResponseBodyTo>>(){

                            @Override
                            public Promise<ResponseBodyTo> apply(HttpResponseTo result) {
                                responseReferenceHolder.value = new ResponseJSONReference(ScriptEvaluator.this.jsonEngine.newJsonObject(), ScriptEvaluator.this.jsonEngine);
                                if (result == null) {
                                    return Promises.of();
                                }
                                ((ResponseJSONReference)responseReferenceHolder.value).setHeaders(result.getHeaders());
                                if (result.getStatus() != null) {
                                    ((ResponseJSONReference)responseReferenceHolder.value).setStatus(result.getStatus().getCode(), result.getStatus().getMessage());
                                }
                                if (result.getBody() == null) {
                                    return Promises.of();
                                }
                                if (result.getBody().getBlob() == null) {
                                    return (Promise)ScriptEvaluator.this.responseBodyProvider.apply(result.getBody());
                                }
                                return Promises.of(result.getBody());
                            }
                        }).flatMap(new Function<ResponseBodyTo, Promise<String>>(){

                            @Override
                            public Promise<String> apply(ResponseBodyTo responseBodyTo) {
                                if (responseBodyTo == null) {
                                    return Promises.of();
                                }
                                return BlobUtils.read(ScriptEvaluator.this.blobReader, responseBodyTo.getBlob());
                            }
                        }).map(new Function<String, ScriptValue>(){

                            @Override
                            public ScriptValue apply(String readBlob) {
                                ((ResponseJSONReference)responseReferenceHolder.value).setBody(readBlob);
                                return new ScriptJsonValue(requestContainerJsonReference.asJSON(), ScriptEvaluator.this.jsonEngine);
                            }
                        }).recoverOnReject((ScriptValue)((Object)new PromiseHandler<Throwable>(){

                            @Override
                            public Object on(@Nullable Throwable error) {
                                return new ScriptJsonValue(requestContainerJsonReference.asJSON(), ScriptEvaluator.this.jsonEngine);
                            }
                        })).doFinally(new Consumer<Deferred>(){

                            @Override
                            public void consume(Deferred deferred) {
                                requestContainerJsonReference.setResponse((ResponseJSONReference)responseReferenceHolder.value);
                            }
                        });
                    }
                }
                return Promises.of();
            }
        });
    }

    private Promise<ScriptValue> executeMethod(final ScriptMethod method, final ScriptValue value, ScriptToken arguments, final EnvironmentsDao environmentsDao, final RepositoryDao repositoryDao) {
        return Promises.all(Sequence.of(arguments.getChildren()).map(new Function<ScriptToken, Promise<ScriptValue>>(){

            @Override
            public Promise<ScriptValue> apply(ScriptToken argToken) {
                return ScriptEvaluator.this.evaluateStatement(argToken, environmentsDao, repositoryDao).doOnResolve(ScriptEvaluator.this.tokenValueSetter(argToken));
            }
        }).toList()).flatMap(new Function<List<ScriptValue>, Promise<ScriptValue>>(){

            @Override
            public Promise<ScriptValue> apply(List<ScriptValue> arguments) {
                return method.execute(value, arguments);
            }
        });
    }

    private String buildExpressionResultFromTokensAndValues(String expression, List<ScriptToken> tokens, List<ScriptValue> values) {
        if (Objects.isNullOrEmpty(values)) {
            return expression;
        }
        StringBuilder output = new StringBuilder();
        block3: for (ScriptToken token : tokens) {
            switch (token.getType()) {
                case Expression: {
                    String value = token.getValue();
                    if (value != null) {
                        output.append(value);
                        continue block3;
                    }
                    output.append(token.getSource());
                    continue block3;
                }
            }
            output.append(token.getSource());
        }
        return output.toString();
    }
}

