/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.script.impl;

import com.restlet.client.async.Promise;
import com.restlet.client.async.Promises;
import com.restlet.client.dao.EnvironmentsDao;
import com.restlet.client.dao.RepositoryDao;
import com.restlet.client.function.BiFunction;
import com.restlet.client.function.Function;
import com.restlet.client.function.Predicate;
import com.restlet.client.html.form.FormItemTo;
import com.restlet.client.html.form.FormItemType;
import com.restlet.client.model.EntityTo;
import com.restlet.client.net.http.request.HttpMethodDefinition;
import com.restlet.client.net.http.request.HttpRequestTo;
import com.restlet.client.net.http.request.impl.EffectiveHttpRequestTo;
import com.restlet.client.net.request.RequestHeaderTo;
import com.restlet.client.net.uri.UriQueryParamTo;
import com.restlet.client.net.uri.UriSchemeTo;
import com.restlet.client.net.uri.UriTo;
import com.restlet.client.net.uri.UriUtils;
import com.restlet.client.net.uri.impl.UriSchemeToImpl;
import com.restlet.client.script.ScriptService;
import com.restlet.client.utils.EntityCloner;
import com.restlet.client.utils.FunctionalUtils;
import com.restlet.client.utils.Maybe;
import com.restlet.client.utils.Objects;
import com.restlet.client.utils.Sequence;
import com.restlet.client.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseRequestEvaluator {
    private final EnvironmentsDao environmentsDao;
    private final ScriptService scriptService;
    private final Function<String, String> encoder = new Function<String, String>(){

        @Override
        public String apply(String input) {
            return BaseRequestEvaluator.this.encodeQueryString(input);
        }
    };

    protected BaseRequestEvaluator(EnvironmentsDao environmentsDao, ScriptService scriptService) {
        this.environmentsDao = environmentsDao;
        this.scriptService = scriptService;
    }

    protected Promise<String> evaluate(String expression, RepositoryDao repositoryDao) {
        return this.scriptService.evaluate(expression, this.environmentsDao, repositoryDao);
    }

    protected Promise<String> evaluate(String value, boolean isEvaluated, RepositoryDao repositoryDao) {
        return isEvaluated ? this.evaluate(value, repositoryDao) : Promises.of(value);
    }

    protected abstract String decodeQueryString(String var1);

    protected abstract String encodeQueryString(String var1);

    public Promise<Boolean> isDynamic(EntityTo entity, RepositoryDao repositoryDao) {
        if (entity.getType() == EntityTo.Type.Request) {
            return this.isDynamic((HttpRequestTo)entity, repositoryDao);
        }
        return Promises.of(entity.getType() == EntityTo.Type.Scenario);
    }

    public Promise<Boolean> isDynamic(HttpRequestTo requestTo, RepositoryDao repositoryDao) {
        if (requestTo == null) {
            return Promises.of(false);
        }
        return this.effective(requestTo, repositoryDao).map(new Function<EffectiveHttpRequestTo, Boolean>(){

            @Override
            public Boolean apply(EffectiveHttpRequestTo effectiveHttpRequestTo) {
                return effectiveHttpRequestTo.isDynamic();
            }
        });
    }

    private boolean isLocal(HttpRequestTo request) {
        return request != null && UriUtils.isLoopbackAddress(request.getUri());
    }

    public Promise<EffectiveHttpRequestTo> effective(HttpRequestTo requestTo, RepositoryDao repositoryDao) {
        if (requestTo == null) {
            return Promises.of();
        }
        final HttpRequestTo effective = EntityCloner.ENTITY_CLONER.clone(requestTo);
        return this.evaluate(requestTo, effective, repositoryDao).map(new Function<Integer, EffectiveHttpRequestTo>(){

            @Override
            public EffectiveHttpRequestTo apply(Integer nbEvaluatedExpressions) {
                return new EffectiveHttpRequestTo(effective, nbEvaluatedExpressions > 0, BaseRequestEvaluator.this.isLocal(effective));
            }
        });
    }

    private Promise<Integer> evaluate(HttpRequestTo requestTo, HttpRequestTo effective, RepositoryDao repositoryDao) {
        ArrayList nbDynamicExpressionsPromises = new ArrayList();
        nbDynamicExpressionsPromises.add(this.evaluateUri(requestTo, effective.getUri(), repositoryDao));
        nbDynamicExpressionsPromises.add(this.evaluateMethod(requestTo, effective.getMethod(), repositoryDao));
        nbDynamicExpressionsPromises.add(this.evaluateHeaders(effective.getHeaders(), repositoryDao));
        nbDynamicExpressionsPromises.add(this.evaluateBody(requestTo, effective, repositoryDao));
        return Promises.all(nbDynamicExpressionsPromises).map(new Function<List<Integer>, Integer>(){

            @Override
            public Integer apply(List<Integer> input) {
                return Sequence.of(input).reduce(new BiFunction<Integer, Integer, Integer>(){

                    @Override
                    public Integer apply(Integer nbTotalDynamicExpressions, Integer nbDynamicExpressions) {
                        return nbTotalDynamicExpressions + nbDynamicExpressions;
                    }
                }, 0);
            }
        });
    }

    private Promise<Integer> evaluateMethod(final HttpRequestTo requestTo, final HttpMethodDefinition method, RepositoryDao repositoryDao) {
        if (method == null || !method.isCustom()) {
            return Promises.of(0);
        }
        return this.evaluate(method.getName(), repositoryDao).map(new Function<String, Integer>(){

            @Override
            public Integer apply(String evaluatedExpression) {
                method.setName(evaluatedExpression != null ? evaluatedExpression.toUpperCase() : null);
                return Objects.equals(requestTo.getMethod().getName(), evaluatedExpression) ? 0 : 1;
            }
        });
    }

    private Promise<Integer> evaluateBody(final HttpRequestTo requestTo, final HttpRequestTo effective, RepositoryDao repositoryDao) {
        if (effective.getBody() == null || effective.getBody().getBodyType() == null) {
            return Promises.of(0);
        }
        ArrayList<Promise<Boolean>> dynamicExpressionsPromises = new ArrayList<Promise<Boolean>>();
        switch (effective.getBody().getBodyType()) {
            case File: {
                effective.getBody().setFileBody(requestTo.getBody().getFileBody());
                break;
            }
            case Form: {
                if (effective.getBody().getFormBody() == null || effective.getBody().getFormBody().getItems() == null || effective.getBody().getFormBody().getItems().isEmpty()) break;
                int it = 0;
                for (final FormItemTo item : effective.getBody().getFormBody().getItems()) {
                    if (item == null || !item.isEnabled()) {
                        ++it;
                        continue;
                    }
                    if (!StringUtils.isBlank(item.getName())) {
                        final String itemName = item.getName();
                        dynamicExpressionsPromises.add(this.evaluate(item.getName(), !effective.isBodyEvaluationDisabled(), repositoryDao).map(new Function<String, Boolean>(){

                            @Override
                            public Boolean apply(String evaluatedExpression) {
                                item.setName(evaluatedExpression);
                                return !effective.isBodyEvaluationDisabled() && !Objects.equals(itemName, evaluatedExpression);
                            }
                        }));
                    }
                    if (FormItemType.Text.equals((Object)item.getType()) && !StringUtils.isBlank(item.getValue())) {
                        final String itemValue = item.getValue();
                        dynamicExpressionsPromises.add(this.evaluate(item.getValue(), !effective.isBodyEvaluationDisabled(), repositoryDao).map(new Function<String, Boolean>(){

                            @Override
                            public Boolean apply(String evaluatedExpression) {
                                item.setValue(evaluatedExpression);
                                return !effective.isBodyEvaluationDisabled() && !Objects.equals(itemValue, evaluatedExpression);
                            }
                        }));
                    } else if (FormItemType.File.equals((Object)item.getType())) {
                        item.setBlobValue(requestTo.getBody().getFormBody().getItems().get(it).getBlobValue());
                    }
                    ++it;
                }
                break;
            }
            case Text: {
                if (StringUtils.isBlank(effective.getBody().getTextBody())) break;
                dynamicExpressionsPromises.add(this.evaluate(effective.getBody().getTextBody(), !effective.isBodyEvaluationDisabled(), repositoryDao).map(new Function<String, Boolean>(){

                    @Override
                    public Boolean apply(String evaluatedExpression) {
                        effective.getBody().setTextBody(evaluatedExpression);
                        return !effective.isBodyEvaluationDisabled() && !Objects.equals(requestTo.getBody().getTextBody(), evaluatedExpression);
                    }
                }));
            }
        }
        return this.getNumberOfDynamicExpressions(dynamicExpressionsPromises);
    }

    private Promise<Integer> evaluateHeaders(List<RequestHeaderTo> headers, RepositoryDao repositoryDao) {
        if (Objects.isNullOrEmpty(headers)) {
            return Promises.of(0);
        }
        ArrayList<Promise<Boolean>> dynamicExpressionsPromises = new ArrayList<Promise<Boolean>>();
        for (final RequestHeaderTo header : headers) {
            if (header == null || !header.isEnabled()) continue;
            if (!StringUtils.isBlank(header.getName())) {
                final String headerName = header.getName();
                dynamicExpressionsPromises.add(this.evaluate(header.getName(), repositoryDao).map(new Function<String, Boolean>(){

                    @Override
                    public Boolean apply(String evaluatedExpression) {
                        header.setName(evaluatedExpression);
                        return !Objects.equals(headerName, evaluatedExpression);
                    }
                }));
            }
            if (StringUtils.isBlank(header.getValue())) continue;
            final String headerValue = header.getValue();
            dynamicExpressionsPromises.add(this.evaluate(header.getValue(), repositoryDao).map(new Function<String, Boolean>(){

                @Override
                public Boolean apply(String evaluatedExpression) {
                    header.setValue(evaluatedExpression);
                    return !Objects.equals(headerValue, evaluatedExpression);
                }
            }));
        }
        return this.getNumberOfDynamicExpressions(dynamicExpressionsPromises);
    }

    private Promise<Integer> evaluateUri(final HttpRequestTo requestTo, final UriTo requestUri, RepositoryDao repositoryDao) {
        if (requestUri == null) {
            return Promises.of(0);
        }
        ArrayList<Promise<Boolean>> dynamicExpressionsPromises = new ArrayList<Promise<Boolean>>();
        final UriSchemeTo originalScheme = FunctionalUtils.ifNotNull(requestTo.getUri(), new Function<UriTo, UriSchemeTo>(){

            @Override
            public UriSchemeTo apply(UriTo uri) {
                return uri.getScheme();
            }
        });
        requestUri.setScheme(originalScheme);
        if (originalScheme != null && !UriSchemeToImpl.isSupportedScheme(originalScheme)) {
            dynamicExpressionsPromises.add(this.evaluate(originalScheme.getName(), repositoryDao).map(new Function<String, Boolean>(){

                @Override
                public Boolean apply(String evaluatedScheme) {
                    if (UriSchemeToImpl.isSupportedScheme(evaluatedScheme)) {
                        requestUri.setScheme(UriSchemeToImpl.valueOf(evaluatedScheme));
                        return true;
                    }
                    requestUri.setScheme(null);
                    return !Objects.equals(evaluatedScheme, originalScheme.getName());
                }
            }));
        }
        if (!StringUtils.isBlank(requestUri.getHost())) {
            dynamicExpressionsPromises.add(this.evaluate(requestUri.getHost(), repositoryDao).map(new Function<String, Boolean>(){

                @Override
                public Boolean apply(String evaluatedExpression) {
                    requestUri.setHost(evaluatedExpression);
                    return !Objects.equals(requestTo.getUri().getHost(), evaluatedExpression);
                }
            }));
        }
        if (!StringUtils.isBlank(requestUri.getPath())) {
            dynamicExpressionsPromises.add(this.evaluate(requestUri.getPath(), repositoryDao).map(new Function<String, Boolean>(){

                @Override
                public Boolean apply(String evaluatedExpression) {
                    requestUri.setPath(evaluatedExpression);
                    return !Objects.equals(requestTo.getUri().getPath(), evaluatedExpression);
                }
            }));
        }
        if (!StringUtils.isBlank(requestUri.getFragment())) {
            dynamicExpressionsPromises.add(this.evaluate(requestUri.getFragment(), repositoryDao).map(new Function<String, Boolean>(){

                @Override
                public Boolean apply(String evaluatedExpression) {
                    requestUri.setFragment(evaluatedExpression);
                    return !Objects.equals(requestTo.getUri().getFragment(), evaluatedExpression);
                }
            }));
        }
        if (requestUri.getQuery() != null && !Objects.isNullOrEmpty(requestUri.getQuery().getItems())) {
            for (final UriQueryParamTo qp : requestUri.getQuery().getItems()) {
                if (qp == null || !qp.isEnabled() || StringUtils.isBlank(qp.getName())) continue;
                dynamicExpressionsPromises.add(Promises.combine(this.evaluate(qp.getName(), repositoryDao), this.evaluate(qp.getValue(), repositoryDao), new Promises.CombineCallback<String, String, Boolean>(){

                    @Override
                    public Boolean on(String name, String value) {
                        boolean isDynamic;
                        boolean bl = isDynamic = !Objects.equals(qp.getName(), name) || !Objects.equals(qp.getValue(), value);
                        if (qp.isEncoded()) {
                            qp.setName(name);
                            qp.setValue(value);
                        } else {
                            qp.setName(Maybe.ofThrowable(BaseRequestEvaluator.this.encoder, name).orElse(name));
                            qp.setValue(Maybe.ofThrowable(BaseRequestEvaluator.this.encoder, value).orElse(value));
                        }
                        return isDynamic;
                    }
                }));
            }
        }
        return this.getNumberOfDynamicExpressions(dynamicExpressionsPromises).map(new Function<Integer, Integer>(){

            @Override
            public Integer apply(Integer nbOfDynamicExpressions) {
                UriUtils.ensureSchemeIsSet(requestUri);
                return nbOfDynamicExpressions;
            }
        });
    }

    private Promise<Integer> getNumberOfDynamicExpressions(List<Promise<Boolean>> dynamicExpressionsPromises) {
        return Promises.all(dynamicExpressionsPromises).map(new Function<List<Boolean>, Integer>(){

            @Override
            public Integer apply(List<Boolean> dynamicExpressions) {
                return Sequence.of(dynamicExpressions).filter(new Predicate<Boolean>(){

                    @Override
                    public boolean test(Boolean isDynamic) {
                        return isDynamic;
                    }
                }).count();
            }
        });
    }
}

