/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.script.method;

import com.restlet.client.async.Promise;
import com.restlet.client.async.Promises;
import com.restlet.client.platform.json.JsonEngine;
import com.restlet.client.script.runtime.ScriptMethod;
import com.restlet.client.script.runtime.ScriptValue;
import com.restlet.client.script.value.ScriptStringValue;
import com.restlet.client.utils.StringUtils;
import java.util.List;

public class ConcatMethod
implements ScriptMethod {
    final JsonEngine jsonEngine;

    public ConcatMethod(JsonEngine jsonEngine) {
        this.jsonEngine = jsonEngine;
    }

    @Override
    public String getName() {
        return "concat";
    }

    @Override
    public Promise<ScriptValue> execute(ScriptValue value, List<ScriptValue> args) {
        if (value == null) {
            return Promises.of();
        }
        if (args != null && args.size() > 0 && args.get(0) != null) {
            String value1 = value.toString();
            String value2 = args.get(0).toString();
            if (StringUtils.isBlank(value2)) {
                if (!StringUtils.isBlank(value1)) {
                    return Promises.of(new ScriptStringValue(value1, this.jsonEngine));
                }
            } else if (!StringUtils.isBlank(value1) && !StringUtils.isBlank(value1)) {
                return Promises.of(new ScriptStringValue(value1.concat(value2), this.jsonEngine));
            }
        }
        return Promises.of(new ScriptStringValue(value.toString(), this.jsonEngine));
    }
}

