/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.script.method;

import com.restlet.client.async.Promise;
import com.restlet.client.async.Promises;
import com.restlet.client.log.LogService;
import com.restlet.client.platform.CryptoApi;
import com.restlet.client.platform.json.JsonEngine;
import com.restlet.client.script.runtime.ScriptMethod;
import com.restlet.client.script.runtime.ScriptValue;
import com.restlet.client.script.value.ScriptStringValue;
import java.util.List;

public class HMACMethod
implements ScriptMethod {
    private final CryptoApi crypto;
    private final JsonEngine jsonEngine;
    private final LogService logService;

    public HMACMethod(CryptoApi crypto, JsonEngine jsonEngine, LogService logService) {
        this.crypto = crypto;
        this.jsonEngine = jsonEngine;
        this.logService = logService;
    }

    @Override
    public String getName() {
        return "hmac";
    }

    @Override
    public Promise<ScriptValue> execute(ScriptValue value, List<ScriptValue> args) {
        if (value == null) {
            return Promises.of();
        }
        if (args != null && args.size() >= 2) {
            try {
                CryptoApi.HashType type = args.get(0) != null ? CryptoApi.HashType.valueOf(args.get(0).toString().toUpperCase()) : null;
                String secret = args.get(1) != null ? args.get(1).toString() : "";
                CryptoApi.Output output = CryptoApi.Output.Base64;
                if (args.size() > 2 && args.get(2) != null) {
                    output = CryptoApi.Output.valueOf(args.get(2).toString());
                }
                if (type != null) {
                    String hmac = this.crypto.hmac(type, secret, value.toString(), output);
                    return Promises.of(new ScriptStringValue(hmac, this.jsonEngine));
                }
            }
            catch (Exception e) {
                this.logService.error("Cannot execute the " + this.getName() + " method.", e);
            }
        }
        return null;
    }
}

