/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.script.method;

import com.restlet.client.async.Promise;
import com.restlet.client.async.Promises;
import com.restlet.client.log.LogService;
import com.restlet.client.platform.CryptoApi;
import com.restlet.client.platform.json.JsonEngine;
import com.restlet.client.script.runtime.ScriptMethod;
import com.restlet.client.script.runtime.ScriptValue;
import com.restlet.client.script.value.ScriptStringValue;
import java.util.List;

public class HashMethod
implements ScriptMethod {
    private final CryptoApi crypto;
    private final JsonEngine jsonEngine;
    private final LogService logService;

    public HashMethod(CryptoApi crypto, JsonEngine jsonEngine, LogService logService) {
        this.crypto = crypto;
        this.jsonEngine = jsonEngine;
        this.logService = logService;
    }

    @Override
    public String getName() {
        return "sha";
    }

    @Override
    public Promise<ScriptValue> execute(ScriptValue value, List<ScriptValue> args) {
        if (value == null) {
            return Promises.of();
        }
        if (args != null && args.size() == 2) {
            try {
                CryptoApi.HashType type = args.get(0) != null ? CryptoApi.HashType.valueOf(args.get(0).toString().toUpperCase()) : null;
                CryptoApi.Output output = CryptoApi.Output.Base64;
                if (args.get(1) != null) {
                    output = CryptoApi.Output.valueOf(args.get(1).toString());
                }
                if (type != null) {
                    String hash = this.crypto.hash(type, value.toString(), output);
                    return Promises.when(new ScriptStringValue(hash, this.jsonEngine));
                }
            }
            catch (Exception e) {
                this.logService.error("Cannot execute the " + this.getName() + " method due to ", e);
            }
        }
        return null;
    }
}

