/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.script.method;

import com.restlet.client.async.Promise;
import com.restlet.client.async.Promises;
import com.restlet.client.platform.json.JsonEngine;
import com.restlet.client.platform.json.JsonException;
import com.restlet.client.platform.json.JsonValue;
import com.restlet.client.script.runtime.ScriptMethod;
import com.restlet.client.script.runtime.ScriptValue;
import com.restlet.client.script.value.ScriptJsonValue;
import java.util.List;

public class JsonPathMethod
implements ScriptMethod {
    final JsonEngine jsonEngine;

    public JsonPathMethod(JsonEngine jsonParser) {
        this.jsonEngine = jsonParser;
    }

    @Override
    public String getName() {
        return "jsonPath";
    }

    @Override
    public Promise<ScriptValue> execute(ScriptValue value, List<ScriptValue> args) {
        if (value == null) {
            return Promises.of();
        }
        if (args == null || args.isEmpty() || args.get(0) == null) {
            return Promises.of();
        }
        try {
            JsonValue val;
            JsonValue root = value instanceof ScriptJsonValue ? ((ScriptJsonValue)value).getJsonValue() : this.jsonEngine.fromJson(value.toString());
            if (root != null && root.isNull() == null && (val = this.jsonEngine.jsonPath(root, args.get(0).toString())) != null) {
                return Promises.of(new ScriptJsonValue(val, this.jsonEngine));
            }
        }
        catch (JsonException jsonException) {
            // empty catch block
        }
        return Promises.of();
    }
}

