/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.script.method;

import com.restlet.client.async.Promise;
import com.restlet.client.async.Promises;
import com.restlet.client.platform.json.JsonEngine;
import com.restlet.client.platform.json.JsonValue;
import com.restlet.client.script.runtime.ScriptMethod;
import com.restlet.client.script.runtime.ScriptValue;
import com.restlet.client.script.value.ScriptJsonValue;
import com.restlet.client.script.value.ScriptNumberValue;
import com.restlet.client.utils.StringUtils;
import java.util.List;

public class LengthMethod
implements ScriptMethod {
    final JsonEngine jsonEngine;

    public LengthMethod(JsonEngine jsonEngine) {
        this.jsonEngine = jsonEngine;
    }

    @Override
    public String getName() {
        return "length";
    }

    @Override
    public Promise<ScriptValue> execute(ScriptValue value, List<ScriptValue> args) {
        if (value == null) {
            return Promises.of();
        }
        JsonValue jsonValue = null;
        String stringValue = null;
        if (value instanceof ScriptJsonValue) {
            jsonValue = ((ScriptJsonValue)value).getJsonValue();
        } else {
            stringValue = value.toString();
            if (stringValue == null) {
                return Promises.of();
            }
            if (!StringUtils.isBlank(stringValue)) {
                try {
                    jsonValue = this.jsonEngine.fromJson(stringValue);
                }
                catch (Throwable e) {
                    jsonValue = null;
                }
            }
        }
        if (jsonValue != null) {
            if (jsonValue.isArray() != null) {
                return Promises.when(new ScriptNumberValue(jsonValue.isArray().size().intValue()));
            }
            if (jsonValue.isObject() != null) {
                return Promises.when(new ScriptNumberValue(jsonValue.isObject().size().intValue()));
            }
            if (jsonValue.isNull() != null) {
                return Promises.of();
            }
        }
        if (stringValue == null && (stringValue = value.toString()) == null) {
            return Promises.of();
        }
        return Promises.when(new ScriptNumberValue(stringValue.length()));
    }
}

