/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.script.method;

import com.restlet.client.async.Promise;
import com.restlet.client.async.Promises;
import com.restlet.client.function.Function;
import com.restlet.client.log.LogService;
import com.restlet.client.platform.json.JsonEngine;
import com.restlet.client.script.runtime.ScriptMethod;
import com.restlet.client.script.runtime.ScriptValue;
import com.restlet.client.script.value.ScriptStringValue;
import com.restlet.client.utils.StringUtils;
import java.util.List;

public class SubStringMethod
implements ScriptMethod {
    private final LogService logService;
    final JsonEngine jsonEngine;

    public SubStringMethod(JsonEngine jsonEngine, LogService logService) {
        this.jsonEngine = jsonEngine;
        this.logService = logService;
    }

    @Override
    public String getName() {
        return "substring";
    }

    @Override
    public Promise<ScriptValue> execute(ScriptValue value, List<ScriptValue> args) {
        if (value == null) {
            return Promises.of();
        }
        if (args != null && args.size() > 0 && args.get(0) != null) {
            String stringValue = value.toString();
            try {
                int beginIndex = Integer.valueOf(args.get(0).toString());
                if (beginIndex < 0 || beginIndex > stringValue.length()) {
                    beginIndex = 0;
                }
                if (args.size() > 1 && args.get(1) != null) {
                    int endIndex = Integer.valueOf(args.get(1).toString());
                    return Promises.of(new ScriptStringValue(beginIndex > endIndex ? "" : stringValue.substring(beginIndex, endIndex), this.jsonEngine));
                }
                return Promises.of(new ScriptStringValue(stringValue.substring(beginIndex), this.jsonEngine));
            }
            catch (NumberFormatException e) {
                this.logService.error("Failed to evaluate substring with args: " + StringUtils.joiner(args, new Function<ScriptValue, String>(){

                    @Override
                    public String apply(ScriptValue input) {
                        return input.toString();
                    }
                }).joinWith(", "), e);
            }
        }
        return Promises.of(new ScriptStringValue(value.toString(), this.jsonEngine));
    }
}

