/*
 * Decompiled with CFR 0.152.
 */
package com.restlet.client.script.parser.impl;

import com.restlet.client.script.parser.ScriptParser;
import com.restlet.client.script.parser.token.ScriptToken;
import com.restlet.client.script.parser.token.ScriptTokenImpl;
import com.restlet.client.script.parser.token.ScriptTokenType;
import com.restlet.client.script.scanner.ScriptScanner;
import com.restlet.client.script.scanner.impl.ScriptScannerImpl;
import com.restlet.client.script.scanner.lex.ScriptLexType;
import com.restlet.client.script.scanner.lex.ScriptLexeme;
import com.restlet.client.utils.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ScriptParserImpl
implements ScriptParser {
    public static final char EXPRESSION_START_CHARACTER = '{';
    public static final char EXPRESSION_END_CHARACTER = '}';

    static void printTokens(List<ScriptToken> tokens, String prefix) {
        for (ScriptToken tk : tokens) {
            System.out.println(prefix + " " + (Object)((Object)tk.getType()) + ", " + tk.getValue() + ", " + tk.getSource());
            if (tk.getChildren() == null) continue;
            ScriptParserImpl.printTokens(tk.getChildren(), prefix + ">");
        }
    }

    private static ScriptToken parseExpression(ScriptLexeme lex, ScriptScanner scanner, List<ScriptToken> tokens) {
        if (lex == null || !ScriptLexType.ExpressionBegin.equals((Object)lex.getType())) {
            return null;
        }
        ScriptTokenImpl token = new ScriptTokenImpl();
        token.setType(ScriptTokenType.Expression);
        token.setSourceIndex(lex.getIndex());
        int scannerIndex = scanner.getIndex();
        lex = scanner.scan();
        while (lex != null && ScriptLexType.WhiteSpace.equals((Object)lex.getType())) {
            lex = scanner.scan();
        }
        if (lex == null) {
            scanner.setIndex(scannerIndex);
            return null;
        }
        ScriptTokenImpl declToken = new ScriptTokenImpl();
        declToken.setType(ScriptTokenType.Statement);
        declToken.setSourceIndex(scannerIndex);
        ScriptToken decl = ScriptParserImpl.parseStatement(declToken, lex, scanner);
        if (decl != null) {
            lex = scanner.scan();
            while (lex != null && ScriptLexType.WhiteSpace.equals((Object)lex.getType())) {
                lex = scanner.scan();
            }
            if (lex != null) {
                switch (lex.getType()) {
                    case ExpressionEnd: {
                        declToken.setSource(scanner.getSource(scannerIndex, lex.getIndex()));
                        token.append(decl);
                        token.setSource(scanner.getSource(token.getSourceIndex(), scanner.getIndex()));
                        return token;
                    }
                }
            }
        }
        scanner.setIndex(scannerIndex);
        ScriptToken legacy = ScriptParserImpl.parseLegacyContext(scanner);
        if (legacy != null) {
            lex = scanner.scan();
            if (lex != null) {
                switch (lex.getType()) {
                    case ExpressionEnd: {
                        token.append(legacy);
                        token.setSource(scanner.getSource(token.getSourceIndex(), scanner.getIndex()));
                        return token;
                    }
                }
            }
            scanner.setIndex(scannerIndex);
        }
        return null;
    }

    private static ScriptToken parseStatement(ScriptTokenImpl declToken, ScriptLexeme lex, ScriptScanner scanner) {
        if (lex == null) {
            return null;
        }
        ScriptTokenImpl refToken = new ScriptTokenImpl();
        switch (lex.getType()) {
            case Id: {
                refToken.setType(ScriptTokenType.Reference);
                break;
            }
            case Number: {
                refToken.setType(ScriptTokenType.Number);
                break;
            }
            case QuotedString: {
                if (!StringUtils.isBlank(lex.getValue())) {
                    ScriptParserImpl parser;
                    List<ScriptToken> tks;
                    int i2;
                    int i1;
                    if (lex.getValue().trim().startsWith("{") && lex.getValue().trim().endsWith("}")) {
                        System.out.println("TODO: Is JSON? " + lex.getValue().trim());
                    }
                    if ((i1 = lex.getValue().indexOf(123)) != -1 && (i2 = lex.getValue().lastIndexOf(125)) != -1 && i1 < i2 && (tks = (parser = new ScriptParserImpl()).parse(lex.getValue())) != null && !tks.isEmpty()) {
                        for (ScriptToken tk : tks) {
                            if (!ScriptTokenType.Expression.equals((Object)tk.getType())) continue;
                            System.out.println("found expression " + lex);
                            return null;
                        }
                    }
                }
                refToken.setType(ScriptTokenType.String);
                break;
            }
            default: {
                return null;
            }
        }
        boolean id = ScriptLexType.Id.equals((Object)lex.getType());
        refToken.setValue(lex.getValue());
        refToken.setSourceIndex(lex.getIndex());
        declToken.append(refToken);
        int sourceIndex = scanner.getIndex();
        lex = scanner.scan();
        if (lex == null) {
            refToken.setSource(scanner.getSource(refToken.getSourceIndex(), scanner.getIndex()));
            scanner.setIndex(sourceIndex);
            return declToken;
        }
        switch (lex.getType()) {
            case BracketLeft: {
                ScriptToken arg;
                Iterator<ScriptToken> argToken;
                if (!id) break;
                ScriptTokenImpl argsToken = new ScriptTokenImpl();
                do {
                    lex = scanner.scan();
                    while (lex != null && ScriptLexType.WhiteSpace.equals((Object)lex.getType())) {
                        lex = scanner.scan();
                    }
                    if (lex != null && !ScriptLexType.BracketRight.equals((Object)lex.getType())) {
                        argToken = new ScriptTokenImpl();
                        ((ScriptTokenImpl)((Object)argToken)).setType(ScriptTokenType.Statement);
                        ((ScriptTokenImpl)((Object)argToken)).setSourceIndex(lex.getIndex());
                        arg = ScriptParserImpl.parseStatement((ScriptTokenImpl)((Object)argToken), lex, scanner);
                        if (arg != null) {
                            lex = scanner.scan();
                        }
                        ((ScriptTokenImpl)((Object)argToken)).setSource(scanner.getSource(((ScriptTokenImpl)((Object)argToken)).getSourceIndex(), scanner.getIndex() - 1));
                        argsToken.append((ScriptToken)((Object)argToken));
                        while (lex != null && ScriptLexType.WhiteSpace.equals((Object)lex.getType())) {
                            lex = scanner.scan();
                        }
                    }
                    if (lex == null || !ScriptLexType.BracketRight.equals((Object)lex.getType())) {
                        scanner.setIndex(sourceIndex);
                        return null;
                    }
                    lex = scanner.scan();
                    while (lex != null && ScriptLexType.WhiteSpace.equals((Object)lex.getType())) {
                        lex = scanner.scan();
                    }
                } while (lex != null && ScriptLexType.BracketLeft.equals((Object)lex.getType()));
                if (argsToken.getChildren() != null && !argsToken.getChildren().isEmpty()) {
                    for (ScriptToken tk : argsToken.getChildren()) {
                        refToken.append(tk);
                    }
                    refToken.setType(ScriptTokenType.IndexReference);
                    break;
                }
                refToken.setType(ScriptTokenType.Reference);
                break;
            }
            case ParenthesesLeft: {
                ScriptToken arg;
                Iterator<ScriptToken> argToken;
                if (!id) break;
                lex = scanner.scan();
                while (lex != null && ScriptLexType.WhiteSpace.equals((Object)lex.getType())) {
                    lex = scanner.scan();
                }
                ScriptTokenImpl argsToken = new ScriptTokenImpl();
                while (lex != null && !ScriptLexType.ParenthesesRight.equals((Object)lex.getType())) {
                    argToken = new ScriptTokenImpl();
                    ((ScriptTokenImpl)((Object)argToken)).setType(ScriptTokenType.Statement);
                    ((ScriptTokenImpl)((Object)argToken)).setSourceIndex(lex.getIndex());
                    arg = ScriptParserImpl.parseStatement((ScriptTokenImpl)((Object)argToken), lex, scanner);
                    if (arg != null) {
                        lex = scanner.scan();
                    }
                    ((ScriptTokenImpl)((Object)argToken)).setSource(scanner.getSource(((ScriptTokenImpl)((Object)argToken)).getSourceIndex(), scanner.getIndex() - 1));
                    argsToken.append((ScriptToken)((Object)argToken));
                    while (lex != null && ScriptLexType.WhiteSpace.equals((Object)lex.getType())) {
                        lex = scanner.scan();
                    }
                    if (lex == null || !ScriptLexType.Comma.equals((Object)lex.getType())) break;
                    lex = scanner.scan();
                    while (lex != null && ScriptLexType.WhiteSpace.equals((Object)lex.getType())) {
                        lex = scanner.scan();
                    }
                }
                if (lex != null && ScriptLexType.ParenthesesRight.equals((Object)lex.getType())) {
                    if (argsToken.getChildren() != null && !argsToken.getChildren().isEmpty()) {
                        for (ScriptToken tk : argsToken.getChildren()) {
                            refToken.append(tk);
                        }
                    }
                    refToken.setType(ScriptTokenType.Method);
                    lex = scanner.scan();
                    break;
                }
                scanner.setIndex(sourceIndex);
                return null;
            }
        }
        if (lex == null) {
            scanner.setIndex(sourceIndex);
            return null;
        }
        int endIndex = lex.getIndex();
        switch (lex.getType()) {
            case Dot: {
                lex = scanner.scan();
                ScriptToken nextToken = ScriptParserImpl.parseStatement(declToken, lex, scanner);
                if (nextToken == null) break;
                refToken.setSource(scanner.getSource(refToken.getSourceIndex(), endIndex));
                return declToken;
            }
            default: {
                refToken.setSource(scanner.getSource(refToken.getSourceIndex(), lex.getIndex()));
                scanner.setIndex(lex.getIndex());
                return declToken;
            }
        }
        scanner.setIndex(sourceIndex);
        return null;
    }

    private static ScriptToken parseLegacyContext(ScriptScanner scanner) {
        ScriptLexeme lex = scanner.scan();
        if (lex == null || ScriptLexType.ExpressionEnd.equals((Object)lex.getType())) {
            return null;
        }
        ScriptTokenImpl legacy = new ScriptTokenImpl();
        legacy.setType(ScriptTokenType.LegacyContext);
        legacy.setSourceIndex(lex.getIndex());
        scanner.setIndex(lex.getIndex());
        ScriptLexeme ne = scanner.findExpressionBegin();
        if (ne != null) {
            scanner.setIndex(lex.getIndex());
            return null;
        }
        lex = scanner.scan();
        while (lex != null && ScriptLexType.WhiteSpace.equals((Object)lex.getType())) {
            lex = scanner.scan();
        }
        while (lex != null) {
            if (ScriptLexType.ExpressionEnd.equals((Object)lex.getType())) {
                legacy.setSource(scanner.getSource(legacy.getSourceIndex(), lex.getIndex()));
                legacy.setValue(legacy.getSource());
                scanner.setIndex(lex.getIndex());
                return legacy;
            }
            if (ScriptLexType.ExpressionBegin.equals((Object)lex.getType())) {
                scanner.setIndex(lex.getIndex());
                return null;
            }
            lex = scanner.scan();
        }
        return null;
    }

    private static void addTextLex(List<ScriptToken> tokens, ScriptScanner scanner, int start, int end) {
        if (!tokens.isEmpty() && ScriptTokenType.Text.equals((Object)tokens.get(tokens.size() - 1).getType())) {
            ScriptTokenImpl token = (ScriptTokenImpl)tokens.get(tokens.size() - 1);
            String source = scanner.getSource(start, end);
            if (token.getSource() != null) {
                token.setSource(token.getSource().concat(source));
            } else {
                token.setSource(source);
            }
            token.setSourceIndex(start);
            return;
        }
        ScriptTokenImpl token = new ScriptTokenImpl();
        token.setType(ScriptTokenType.Text);
        token.setSource(scanner.getSource(start, end));
        token.setSourceIndex(start);
        tokens.add(token);
    }

    @Override
    public List<ScriptToken> parse(String script) {
        if (StringUtils.isBlank(script)) {
            return null;
        }
        ScriptScannerImpl scanner = new ScriptScannerImpl(script);
        ArrayList<ScriptToken> tokens = new ArrayList<ScriptToken>();
        ScriptLexeme lex = scanner.findExpressionBegin();
        boolean foundExpression = false;
        while (lex != null) {
            switch (lex.getType()) {
                case ExpressionBegin: {
                    ScriptToken token = ScriptParserImpl.parseExpression(lex, scanner, tokens);
                    if (token != null) {
                        foundExpression = foundExpression || ScriptTokenType.Expression.equals((Object)token.getType());
                        tokens.add(token);
                        break;
                    }
                    ScriptParserImpl.addTextLex(tokens, scanner, lex.getIndex(), scanner.getIndex());
                    break;
                }
                default: {
                    ScriptParserImpl.addTextLex(tokens, scanner, lex.getIndex(), scanner.getIndex());
                }
            }
            lex = scanner.findExpressionBegin();
        }
        if (!foundExpression || tokens.isEmpty()) {
            return null;
        }
        if (!scanner.isEOF()) {
            ScriptParserImpl.addTextLex(tokens, scanner, scanner.getIndex(), scanner.getLength());
        }
        return tokens.isEmpty() ? null : tokens;
    }
}

